/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.ruleset2dmn;

import java.io.InputStream;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.ruleset2dmn.Converter;
import org.kie.dmn.ruleset2dmn.TestDMNRuntimeEventListener;
import org.kie.dmn.ruleset2dmn.TestUtils;
import org.kie.internal.io.ResourceFactory;

public class ChurnTest {
    @Test
    public void test() throws Exception {
        String dmnXml = Converter.parse((String)"churn", (InputStream)this.getClass().getResourceAsStream("/churn.pmml"));
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(Arrays.asList(ResourceFactory.newByteArrayResource((byte[])dmnXml.getBytes()))).getOrElseThrow(RuntimeException::new);
        dmnRuntime.addListener((DMNRuntimeEventListener)new TestDMNRuntimeEventListener());
        DMNModel modelUnderTest = (DMNModel)dmnRuntime.getModels().get(0);
        Assertions.assertThat((Object)((DMNDecisionResult)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{ \"Children\": 1, \"Gender\": \"M\", \"Age\": 40, \"EstIncome\": 75000, \"Usage\": 0, \"RatePlan\": 0}")).getDecisionResults().get(0)).getResult()).isEqualTo((Object)"T");
        Assertions.assertThat((Object)((DMNDecisionResult)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{ \"Children\": 1, \"Gender\": \"F\", \"Age\": 0, \"EstIncome\": 35000, \"Status\": \"S\", \"Usage\": 51, \"RatePlan\": 0}")).getDecisionResults().get(0)).getResult()).isEqualTo((Object)"T");
        Assertions.assertThat((Object)((DMNDecisionResult)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{ \"Children\": 0, \"Age\": 0, \"EstIncome\": 35000, \"Status\": \"S\", \"Usage\": 51, \"RatePlan\": 0}")).getDecisionResults().get(0)).getResult()).isEqualTo((Object)"F");
    }
}

