/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.ruleset2dmn;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.model.api.InputData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static DMNContext ctxFromJson(DMNModel dmnModel, String json) throws Exception {
        LOG.debug("INPUT: {}", (Object)json);
        Map jsonMap = (Map)MAPPER.readValue(json, Map.class);
        DMNContext ctx = DMNFactory.newContext();
        Collection ids = dmnModel.getDefinitions().getDrgElement().stream().filter(InputData.class::isInstance).map(InputData.class::cast).collect(Collectors.toList());
        for (InputData id : ids) {
            Object valForId = jsonMap.get(id.getName());
            if (valForId == null && !id.getVariable().getTypeRef().toString().equals("number") && !id.getVariable().getTypeRef().toString().equals("boolean")) {
                valForId = "<unknown>";
            }
            ctx.set(id.getName(), valForId);
        }
        return ctx;
    }
}

