/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.ruleset2dmn;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.Value;
import org.dmg.pmml.rule_set.RuleSelectionMethod;
import org.dmg.pmml.rule_set.RuleSet;
import org.dmg.pmml.rule_set.RuleSetModel;
import org.dmg.pmml.rule_set.SimpleRule;
import org.jpmml.model.PMMLUtil;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.feel.codegen.feel11.CodegenStringUtil;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.model.api.DMNElementReference;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.model.api.HitPolicy;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.api.InputClause;
import org.kie.dmn.model.api.InputData;
import org.kie.dmn.model.api.LiteralExpression;
import org.kie.dmn.model.api.OutputClause;
import org.kie.dmn.model.api.UnaryTests;
import org.kie.dmn.model.v1_2.TDMNElementReference;
import org.kie.dmn.model.v1_2.TDecision;
import org.kie.dmn.model.v1_2.TDecisionRule;
import org.kie.dmn.model.v1_2.TDecisionTable;
import org.kie.dmn.model.v1_2.TDefinitions;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.dmn.model.v1_2.TInformationRequirement;
import org.kie.dmn.model.v1_2.TInputClause;
import org.kie.dmn.model.v1_2.TInputData;
import org.kie.dmn.model.v1_2.TItemDefinition;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.dmn.model.v1_2.TOutputClause;
import org.kie.dmn.model.v1_2.TRuleAnnotation;
import org.kie.dmn.model.v1_2.TRuleAnnotationClause;
import org.kie.dmn.model.v1_2.TUnaryTests;
import org.kie.dmn.ruleset2dmn.SimpleRuleRow;
import org.kie.dmn.ruleset2dmn.WeightComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Converter {
    private static final Logger LOG = LoggerFactory.getLogger(Converter.class);

    public static String parse(String dmnModelName, InputStream is) throws Exception {
        PMML pmml = PMMLUtil.unmarshal((InputStream)is);
        if (pmml.getModels().size() != 1) {
            throw new UnsupportedOperationException("Only single model supported for Decision Table conversion");
        }
        Model model0 = (Model)pmml.getModels().get(0);
        if (!(model0 instanceof RuleSetModel)) {
            throw new UnsupportedOperationException("Only single RuleSetModel supported for Decision Table conversion");
        }
        RuleSetModel rsModel = (RuleSetModel)model0;
        RuleSet rs = rsModel.getRuleSet();
        if (rs.getRuleSelectionMethods().size() != 1) {
            throw new UnsupportedOperationException("Only single RuleSelectionMethods supported for Decision Table conversion");
        }
        RuleSelectionMethod rssMethod0 = (RuleSelectionMethod)rs.getRuleSelectionMethods().get(0);
        Stream<SimpleRule> s0 = rs.getRules().stream().map(SimpleRule.class::cast);
        if (rssMethod0.getCriterion() == RuleSelectionMethod.Criterion.WEIGHTED_MAX) {
            s0 = s0.sorted(new WeightComparator().reversed());
        }
        List rsRules = s0.map(SimpleRuleRow::new).collect(Collectors.toList());
        LinkedHashSet<String> usedPredictors = new LinkedHashSet<String>();
        for (SimpleRuleRow rr : rsRules) {
            usedPredictors.addAll(rr.map.keySet());
            LOG.debug("{}", (Object)rr);
        }
        LOG.debug("{}", usedPredictors);
        HashMap<String, Set> predictorsLoVs = new HashMap<String, Set>();
        TDefinitions definitions = new TDefinitions();
        Converter.setDefaultNSContext((Definitions)definitions);
        definitions.setId("dmnid_" + dmnModelName);
        definitions.setName(dmnModelName);
        String namespace = "ri2dmn_" + UUID.randomUUID();
        definitions.setNamespace(namespace);
        definitions.getNsContext().put("", namespace);
        definitions.setExporter("kie-dmn-ri");
        Converter.appendInputData((Definitions)definitions, pmml, usedPredictors);
        String dtName = rssMethod0.getCriterion() == RuleSelectionMethod.Criterion.WEIGHTED_SUM ? "dt" : null;
        DecisionTable dt = Converter.appendDecisionDT((Definitions)definitions, dtName, pmml, usedPredictors);
        if (rssMethod0.getCriterion() == RuleSelectionMethod.Criterion.WEIGHTED_SUM) {
            dt.setHitPolicy(HitPolicy.COLLECT);
        }
        if (rs.getDefaultScore() != null) {
            LiteralExpression le = Converter.leFromNumberOrString(rs.getDefaultScore());
            ((OutputClause)dt.getOutput().get(0)).setDefaultOutputEntry(le);
        }
        for (SimpleRuleRow simpleRuleRow : rsRules) {
            TDecisionRule dr = new TDecisionRule();
            for (String input : usedPredictors) {
                List<SimplePredicate> predicatesForInput = simpleRuleRow.map.get(input);
                if (predicatesForInput != null && !predicatesForInput.isEmpty()) {
                    FieldName fnLookup = FieldName.create((String)input);
                    Optional<DataField> df = pmml.getDataDictionary().getDataFields().stream().filter(x -> x.getName().equals((Object)fnLookup)).findFirst();
                    UnaryTests ut = Converter.processSimplePredicateUnaryOrBinary(predicatesForInput, df);
                    if (ut.getText().startsWith("\"") && ut.getText().endsWith("\"")) {
                        predictorsLoVs.computeIfAbsent(input, k -> new LinkedHashSet()).add(ut.getText());
                    }
                    dr.getInputEntry().add(ut);
                    continue;
                }
                TUnaryTests ut = new TUnaryTests();
                ut.setText("-");
                dr.getInputEntry().add(ut);
            }
            if (rssMethod0.getCriterion() != RuleSelectionMethod.Criterion.WEIGHTED_SUM) {
                dr.getOutputEntry().add(Converter.leFromNumberOrString(simpleRuleRow.r.getScore()));
            } else {
                String output = "{score: " + Converter.feelLiteralValue(simpleRuleRow.r.getScore(), Optional.empty()) + " , weight: " + simpleRuleRow.r.getWeight() + " }";
                TLiteralExpression le = new TLiteralExpression();
                le.setText(output);
                dr.getOutputEntry().add(le);
            }
            TRuleAnnotation comment = new TRuleAnnotation();
            String commentText = "recordCount=" + simpleRuleRow.r.getRecordCount() + " nbCorrect=" + simpleRuleRow.r.getNbCorrect() + " confidence=" + simpleRuleRow.r.getConfidence() + " weight" + simpleRuleRow.r.getWeight();
            comment.setText(commentText);
            dr.getAnnotationEntry().add(comment);
            dt.getRule().add(dr);
        }
        if (rssMethod0.getCriterion() == RuleSelectionMethod.Criterion.WEIGHTED_SUM) {
            Converter.decisionAggregated((Definitions)definitions, dtName);
            Converter.decisionMax((Definitions)definitions);
            TDecision decision = new TDecision();
            String string = definitions.getName();
            decision.setName(string);
            decision.setId("d_" + CodegenStringUtil.escapeIdentifier((String)string));
            TInformationItem variable = new TInformationItem();
            variable.setName(string);
            variable.setId("dvar_" + CodegenStringUtil.escapeIdentifier((String)string));
            variable.setTypeRef(new QName("Any"));
            decision.setVariable((InformationItem)variable);
            Converter.addRequiredDecisionByName((Decision)decision, "aggregated");
            Converter.addRequiredDecisionByName((Decision)decision, "max");
            TLiteralExpression le = new TLiteralExpression();
            le.setText("aggregated[total=max][1].score");
            decision.setExpression((Expression)le);
            definitions.getDrgElement().add(decision);
        }
        for (DataField dataField : pmml.getDataDictionary().getDataFields()) {
            if (dataField.getDataType() != DataType.STRING || !predictorsLoVs.containsKey(dataField.getName().getValue())) continue;
            for (Value value : dataField.getValues()) {
                ((Set)predictorsLoVs.get(dataField.getName().getValue())).add("\"" + value.getValue().toString() + "\"");
            }
        }
        for (Set set : predictorsLoVs.values()) {
            set.add("\"<unknown>\"");
        }
        for (Map.Entry entry : predictorsLoVs.entrySet()) {
            TItemDefinition idd = new TItemDefinition();
            idd.setName((String)entry.getKey());
            idd.setTypeRef(new QName("string"));
            TUnaryTests lov = new TUnaryTests();
            String lovText = ((Set)entry.getValue()).stream().collect(Collectors.joining(", "));
            lov.setText(lovText);
            idd.setAllowedValues((UnaryTests)lov);
            definitions.getItemDefinition().add(idd);
            Optional<InputData> optInputData = definitions.getDrgElement().stream().filter(InputData.class::isInstance).map(InputData.class::cast).filter(drg -> drg.getName().equals(kv.getKey())).findFirst();
            if (!optInputData.isPresent()) {
                throw new IllegalStateException();
            }
            optInputData.get().getVariable().setTypeRef(new QName((String)entry.getKey()));
            Optional<InputClause> optInputClause = dt.getInput().stream().filter(ic -> ic.getInputExpression().getText().equals(kv.getKey())).findFirst();
            if (optInputClause.isPresent()) {
                TUnaryTests icLov = new TUnaryTests();
                icLov.setText(lovText);
                InputClause ic2 = optInputClause.get();
                ic2.setInputValues((UnaryTests)icLov);
                ic2.getInputExpression().setTypeRef(new QName((String)entry.getKey()));
                continue;
            }
            throw new IllegalStateException();
        }
        DMNMarshaller dmnMarshaller = DMNMarshallerFactory.newDefaultMarshaller();
        String string = dmnMarshaller.marshal((Object)definitions);
        LOG.debug("{}", predictorsLoVs);
        return string;
    }

    private static void addRequiredDecisionByName(Decision decision, String partOfIdentifier) {
        TInformationRequirement ir = new TInformationRequirement();
        TDMNElementReference er = new TDMNElementReference();
        er.setHref("#d_" + CodegenStringUtil.escapeIdentifier((String)partOfIdentifier));
        ir.setRequiredDecision((DMNElementReference)er);
        decision.getInformationRequirement().add(ir);
    }

    private static void decisionMax(Definitions definitions) {
        TDecision decision = new TDecision();
        String decisionName = "max";
        decision.setName(decisionName);
        decision.setId("d_" + CodegenStringUtil.escapeIdentifier((String)decisionName));
        TInformationItem variable = new TInformationItem();
        variable.setName(decisionName);
        variable.setId("dvar_" + CodegenStringUtil.escapeIdentifier((String)decisionName));
        variable.setTypeRef(new QName("Any"));
        decision.setVariable((InformationItem)variable);
        Converter.addRequiredDecisionByName((Decision)decision, "aggregated");
        TLiteralExpression le = new TLiteralExpression();
        le.setText("max(aggregated.total)");
        decision.setExpression((Expression)le);
        definitions.getDrgElement().add(decision);
    }

    private static void decisionAggregated(Definitions definitions, String dtName) {
        TDecision decision = new TDecision();
        String decisionName = "aggregated";
        decision.setName(decisionName);
        decision.setId("d_" + CodegenStringUtil.escapeIdentifier((String)decisionName));
        TInformationItem variable = new TInformationItem();
        variable.setName(decisionName);
        variable.setId("dvar_" + CodegenStringUtil.escapeIdentifier((String)decisionName));
        variable.setTypeRef(new QName("Any"));
        decision.setVariable((InformationItem)variable);
        Converter.addRequiredDecisionByName((Decision)decision, dtName);
        TLiteralExpression le = new TLiteralExpression();
        le.setText("for s in distinct values(dt.score) return {score: s, total: sum(dt[score=s].weight)}");
        decision.setExpression((Expression)le);
        definitions.getDrgElement().add(decision);
    }

    private static UnaryTests processSimplePredicateUnaryOrBinary(List<SimplePredicate> predicatesForInput, Optional<DataField> df) {
        TUnaryTests ut = new TUnaryTests();
        if (predicatesForInput.size() == 1) {
            SimplePredicate p0 = predicatesForInput.get(0);
            String text = Converter.feelUTofOp(p0.getOperator()) + Converter.feelLiteralValue(p0.getValue(), df);
            ut.setText(text);
        } else if (predicatesForInput.size() == 2) {
            SimplePredicate p1;
            List sortedList = predicatesForInput.stream().sorted(Comparator.comparing(o -> o.getOperator().name())).collect(Collectors.toList());
            SimplePredicate p0 = (SimplePredicate)sortedList.get(0);
            if (Converter.canCollapseBinaryPredicate(p0, p1 = (SimplePredicate)sortedList.get(1))) {
                ut.setText(Converter.feelLiteralValue(p0.getValue(), df));
            } else {
                ut.setText(Converter.convertBinaryPredicate(p0, p1, df));
            }
        } else {
            ut.setText("\"?\"");
        }
        return ut;
    }

    private static boolean canCollapseBinaryPredicate(SimplePredicate first, SimplePredicate second) {
        boolean haveCorrectOperators;
        Object firstValue = first.getValue();
        Object secondValue = second.getValue();
        boolean bl = haveCorrectOperators = first.getOperator() == SimplePredicate.Operator.GREATER_OR_EQUAL && second.getOperator() == SimplePredicate.Operator.LESS_OR_EQUAL;
        if (firstValue instanceof BigDecimal && secondValue instanceof BigDecimal) {
            return haveCorrectOperators && ((BigDecimal)firstValue).compareTo((BigDecimal)secondValue) == 0;
        }
        return haveCorrectOperators && firstValue.equals(secondValue);
    }

    private static String convertBinaryPredicate(SimplePredicate firstPart, SimplePredicate secondPart, Optional<DataField> df) {
        StringBuilder sb = new StringBuilder();
        sb.append(Converter.getOperatorText(firstPart.getOperator(), true));
        sb.append(Converter.feelLiteralValue(firstPart.getValue(), df));
        sb.append(" .. ");
        sb.append(Converter.feelLiteralValue(secondPart.getValue(), df));
        sb.append(Converter.getOperatorText(secondPart.getOperator(), false));
        return sb.toString();
    }

    private static String getOperatorText(SimplePredicate.Operator operator, boolean lowerBound) {
        if (lowerBound) {
            if (operator == SimplePredicate.Operator.GREATER_OR_EQUAL) {
                return "[";
            }
            if (operator == SimplePredicate.Operator.GREATER_THAN) {
                return "(";
            }
            throw new UnsupportedOperationException("Unsupported operator in lowerbound: " + operator);
        }
        if (operator == SimplePredicate.Operator.LESS_THAN) {
            return ")";
        }
        if (operator == SimplePredicate.Operator.LESS_OR_EQUAL) {
            return "]";
        }
        throw new UnsupportedOperationException("Unsupported operator in upperbound: " + operator);
    }

    private static String feelUTofOp(SimplePredicate.Operator operator) {
        switch (operator) {
            case EQUAL: {
                return "";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case IS_MISSING: 
            case IS_NOT_MISSING: {
                throw new UnsupportedOperationException("Unsupported operator for FEEL conversion");
            }
            case LESS_OR_EQUAL: {
                return "<=";
            }
            case LESS_THAN: {
                return "<";
            }
            case NOT_EQUAL: {
                return "? !=";
            }
        }
        throw new IllegalStateException();
    }

    private static LiteralExpression leFromNumberOrString(Object rs) {
        TLiteralExpression le = new TLiteralExpression();
        le.setText(Converter.feelLiteralValue(rs, Optional.empty()));
        return le;
    }

    private static String feelLiteralValue(Object input, Optional<DataField> df) {
        if (df.isPresent()) {
            DataType dt = df.get().getDataType();
            switch (dt) {
                case BOOLEAN: {
                    String trimmed;
                    switch (trimmed = input.toString().trim().toLowerCase()) {
                        case "true": {
                            return "true";
                        }
                        case "false": {
                            return "false";
                        }
                    }
                    throw new UnsupportedOperationException("Was expecting a FEEL:boolean but the pmml serialization was: " + input);
                }
                case DOUBLE: 
                case FLOAT: 
                case INTEGER: {
                    BigDecimal bdOrNull = EvalHelper.getBigDecimalOrNull((Object)input);
                    if (bdOrNull != null) {
                        return bdOrNull.toPlainString();
                    }
                    throw new UnsupportedOperationException("Was expecting a FEEL:number but the pmml serialization was: " + input);
                }
                case STRING: {
                    return "\"" + input + "\"";
                }
            }
            throw new UnsupportedOperationException("Unhandled pmml serialization for FEEL conversion: " + input);
        }
        LOG.debug("feelLiteralValue for {} and DD not available", input);
        BigDecimal bdOrNull = EvalHelper.getBigDecimalOrNull((Object)input);
        if (bdOrNull != null) {
            return bdOrNull.toPlainString();
        }
        return "\"" + input + "\"";
    }

    private static DecisionTable appendDecisionDT(Definitions definitions, String name, PMML pmml, Set<String> usedPredictors) {
        TDecision decision = new TDecision();
        String dtName = name == null ? definitions.getName() : name;
        decision.setName(dtName);
        decision.setId("d_" + CodegenStringUtil.escapeIdentifier((String)dtName));
        TInformationItem variable = new TInformationItem();
        variable.setName(dtName);
        variable.setId("dvar_" + CodegenStringUtil.escapeIdentifier((String)dtName));
        variable.setTypeRef(new QName("Any"));
        decision.setVariable((InformationItem)variable);
        for (String string : usedPredictors) {
            TInformationRequirement ir = new TInformationRequirement();
            TDMNElementReference er = new TDMNElementReference();
            er.setHref("#id_" + CodegenStringUtil.escapeIdentifier((String)string));
            ir.setRequiredInput((DMNElementReference)er);
            decision.getInformationRequirement().add(ir);
        }
        TDecisionTable dt = new TDecisionTable();
        dt.setOutputLabel(dtName);
        dt.setId("ddt_" + CodegenStringUtil.escapeIdentifier((String)dtName));
        dt.setHitPolicy(HitPolicy.FIRST);
        for (String ri : usedPredictors) {
            TInputClause ic = new TInputClause();
            ic.setLabel(ri);
            TLiteralExpression le = new TLiteralExpression();
            le.setText(ri);
            le.setTypeRef(new QName(Converter.feelTypeFromDD(pmml.getDataDictionary(), ri)));
            ic.setInputExpression((LiteralExpression)le);
            dt.getInput().add(ic);
        }
        TOutputClause tOutputClause = new TOutputClause();
        dt.getOutput().add(tOutputClause);
        TRuleAnnotationClause comment = new TRuleAnnotationClause();
        comment.setName("comments");
        dt.getAnnotation().add(comment);
        decision.setExpression((Expression)dt);
        definitions.getDrgElement().add(decision);
        return dt;
    }

    private static void appendInputData(Definitions definitions, PMML pmml, Set<String> usedPredictors) {
        DataDictionary dd = pmml.getDataDictionary();
        for (String ri : usedPredictors) {
            TInputData id = new TInputData();
            id.setName(ri);
            id.setId("id_" + CodegenStringUtil.escapeIdentifier((String)ri));
            TInformationItem variable = new TInformationItem();
            variable.setName(ri);
            variable.setId("idvar_" + CodegenStringUtil.escapeIdentifier((String)ri));
            variable.setTypeRef(new QName(Converter.feelTypeFromDD(dd, ri)));
            id.setVariable((InformationItem)variable);
            definitions.getDrgElement().add(id);
        }
    }

    private static String feelTypeFromDD(DataDictionary dd, String id) {
        FieldName lookup = FieldName.create((String)id);
        Optional<DataField> opt = dd.getDataFields().stream().filter(df -> df.getName().equals((Object)lookup)).findFirst();
        if (opt.isEmpty()) {
            return "Any";
        }
        DataType dataType = opt.map(DataField::getDataType).get();
        switch (dataType) {
            case BOOLEAN: {
                return "boolean";
            }
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: {
                return "number";
            }
            case STRING: {
                return "string";
            }
        }
        return "Any";
    }

    private static void setDefaultNSContext(Definitions definitions) {
        Map nsContext = definitions.getNsContext();
        nsContext.put("feel", "http://www.omg.org/spec/DMN/20180521/FEEL/");
        nsContext.put("dmn", "http://www.omg.org/spec/DMN/20180521/MODEL/");
        nsContext.put("dmndi", "http://www.omg.org/spec/DMN/20180521/DMNDI/");
        nsContext.put("di", "http://www.omg.org/spec/DMN/20180521/DI/");
        nsContext.put("dc", "http://www.omg.org/spec/DMN/20180521/DC/");
    }
}

