/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DecisionCompiler;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.internal.utils.DRGAnalysisUtils;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.runtime.functions.AllFunction;
import org.kie.dmn.feel.runtime.functions.AnyFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.MaxFunction;
import org.kie.dmn.feel.runtime.functions.MinFunction;
import org.kie.dmn.feel.runtime.functions.SumFunction;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.model.api.DMNElement;

@XStreamAlias(value="MultiInstanceDecisionLogic")
public class MultiInstanceDecisionLogic {
    @XStreamAlias(value="iterationExpression")
    private String iterationExpression;
    @XStreamAlias(value="iteratorShapeId")
    private String iteratorShapeId;
    @XStreamAlias(value="aggregationFunction")
    private String aggregationFunction;
    @XStreamAlias(value="topLevelDecisionId")
    private String topLevelDecisionId;

    public String getIterationExpression() {
        return this.iterationExpression;
    }

    public String getIteratorShapeId() {
        return this.iteratorShapeId;
    }

    public String getAggregationFunction() {
        return this.aggregationFunction;
    }

    public String getTopLevelDecisionId() {
        return this.topLevelDecisionId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MultiInstanceDecisionLogic [iterationExpression=").append(this.iterationExpression).append(", iteratorShapeId=").append(this.iteratorShapeId).append(", aggregationFunction=").append(this.aggregationFunction).append(", topLevelDecisionId=").append(this.topLevelDecisionId).append("]");
        return builder.toString();
    }

    public static class MultiInstanceDecisionNodeEvaluator
    implements DMNExpressionEvaluator {
        private MultiInstanceDecisionLogic mi;
        private DMNModelImpl model;
        private DecisionNodeImpl di;
        private String contextIteratorName;
        private DecisionNodeImpl topLevelDecision;
        private List<DecisionNodeImpl> reqDecisions = new ArrayList<DecisionNodeImpl>();
        private final FEEL feel;

        public MultiInstanceDecisionNodeEvaluator(MultiInstanceDecisionLogic mi, DMNModelImpl model, DecisionNodeImpl di, FEEL feel) {
            this.mi = mi;
            this.model = model;
            this.di = di;
            this.feel = feel;
            this.contextIteratorName = model.getInputById(mi.iteratorShapeId).getName();
            this.topLevelDecision = (DecisionNodeImpl)model.getDecisionById(mi.topLevelDecisionId);
        }

        public void addReqDecision(DecisionNodeImpl reqDecision) {
            this.reqDecisions.add(reqDecision);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
            FEELFnResult r;
            DMNResultImpl result = (DMNResultImpl)dmnr;
            DMNContext previousContext = result.getContext();
            DMNContextImpl dmnContext = (DMNContextImpl)previousContext.clone();
            result.setContext((DMNContext)dmnContext);
            ArrayList<Object> invokationResults = new ArrayList<Object>();
            try {
                Object cycleOnRaw = this.feel.evaluate(this.mi.iterationExpression, dmnContext.getAll());
                List<Object> cycleOn = null;
                cycleOn = cycleOnRaw instanceof Collection ? (List<Object>)cycleOnRaw : Arrays.asList(cycleOnRaw);
                for (Object e2 : cycleOn) {
                    DMNContext nonCycledContext = result.getContext();
                    DMNContextImpl cyclingContext = (DMNContextImpl)nonCycledContext.clone();
                    result.setContext((DMNContext)cyclingContext);
                    cyclingContext.set(this.contextIteratorName, e2);
                    for (DecisionNodeImpl reqDecision : this.reqDecisions) {
                        Object subResult = reqDecision.getEvaluator().evaluate(eventManager, (DMNResult)result).getResult();
                        cyclingContext.set(reqDecision.getName(), subResult);
                    }
                    Object evaluationResult = this.topLevelDecision.getEvaluator().evaluate(eventManager, (DMNResult)result).getResult();
                    invokationResults.add(evaluationResult);
                    result.setContext(nonCycledContext);
                }
            }
            finally {
                result.setContext(previousContext);
            }
            switch (this.mi.aggregationFunction) {
                case "SUM": {
                    r = new SumFunction().invoke(invokationResults);
                    break;
                }
                case "MIN": {
                    r = new MinFunction().invoke(invokationResults);
                    break;
                }
                case "MAX": {
                    r = new MaxFunction().invoke(invokationResults);
                    break;
                }
                case "COUNT": {
                    r = FEELFnResult.ofResult((Object)EvalHelper.getBigDecimalOrNull((Object)invokationResults.size()));
                    break;
                }
                case "ALLTRUE": {
                    r = new AllFunction().invoke(invokationResults);
                    break;
                }
                case "ANYTRUE": {
                    r = new AnyFunction().invoke(invokationResults);
                    break;
                }
                case "ALLFALSE": {
                    FEELFnResult fEELFnResult = new AnyFunction().invoke(invokationResults);
                    r = fEELFnResult.map(b -> b == false);
                    break;
                }
                default: {
                    r = FEELFnResult.ofResult(invokationResults);
                }
            }
            return new EvaluatorResultImpl(r.getOrElseThrow(e -> new RuntimeException(e.toString())), EvaluatorResult.ResultType.SUCCESS);
        }
    }

    public static class MIDDependenciesProcessor {
        private final MultiInstanceDecisionLogic mid;
        private final DMNModel model;

        public MIDDependenciesProcessor(MultiInstanceDecisionLogic mid, DMNModel model) {
            this.mid = mid;
            this.model = model;
        }

        public Collection<DMNNode> findAllChildElements() {
            return new HashSet<DMNNode>(this.processNode(this.topLevelDecision()));
        }

        public Collection<DMNNode> findAllDependencies() {
            return DRGAnalysisUtils.dependencies((DMNModel)this.model, (DMNNode)this.topLevelDecision()).stream().map(DRGAnalysisUtils.DRGDependency::getDependency).collect(Collectors.toSet());
        }

        private Set<DMNNode> processNode(DMNBaseNode currentNode) {
            if (this.currentNodeIsTheIterator(currentNode)) {
                return Collections.singleton(currentNode);
            }
            Set<DMNNode> pathToIterator = this.findPathToIterator(currentNode);
            if (pathToIterator.isEmpty()) {
                return Collections.emptySet();
            }
            return this.extendPathBy(currentNode, pathToIterator);
        }

        private Set<DMNNode> extendPathBy(DMNBaseNode node, Set<DMNNode> pathToIterator) {
            HashSet<DMNNode> extendedPath = new HashSet<DMNNode>(pathToIterator);
            extendedPath.add((DMNNode)node);
            return extendedPath;
        }

        private Set<DMNNode> findPathToIterator(DMNBaseNode currentNode) {
            return currentNode.getDependencies().values().stream().map(DMNBaseNode.class::cast).map(this::processNode).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        private boolean currentNodeIsTheIterator(DMNBaseNode node) {
            return this.mid.getIteratorShapeId().equals(node.getId());
        }

        private DMNBaseNode topLevelDecision() {
            return (DMNBaseNode)this.model.getDecisionById(this.mid.getTopLevelDecisionId());
        }
    }

    public static class MultiInstanceDecisionNodeCompiler
    extends DecisionCompiler {
        private Optional<MultiInstanceDecisionLogic> getMIDL(DMNNode node) {
            DecisionNodeImpl nodeImpl;
            DMNElement.ExtensionElements extElementsList;
            if (node instanceof DecisionNodeImpl && (extElementsList = (nodeImpl = (DecisionNodeImpl)node).getSource().getExtensionElements()) != null && extElementsList.getAny() != null) {
                return extElementsList.getAny().stream().filter(MultiInstanceDecisionLogic.class::isInstance).map(MultiInstanceDecisionLogic.class::cast).findFirst();
            }
            return Optional.empty();
        }

        public boolean accept(DMNNode node) {
            return this.getMIDL(node).isPresent();
        }

        public void compileEvaluator(DMNNode node, DMNCompilerImpl compiler, DMNCompilerContext ctx, DMNModelImpl model) {
            DecisionNodeImpl di = (DecisionNodeImpl)node;
            compiler.linkRequirements(model, (DMNBaseNode)di);
            MultiInstanceDecisionLogic midl = this.getMIDL(node).orElseThrow(() -> new IllegalStateException("Node doesn't contain multi instance decision logic!" + node.toString()));
            MultiInstanceDecisionNodeEvaluator miEvaluator = new MultiInstanceDecisionNodeEvaluator(midl, model, di, ctx.getFeelHelper().newFEELInstance());
            di.setEvaluator((DMNExpressionEvaluator)miEvaluator);
            compiler.addCallback((cCompiler, cCtx, cModel) -> {
                MIDDependenciesProcessor processor = new MIDDependenciesProcessor(midl, (DMNModel)cModel);
                this.addRequiredDecisions(miEvaluator, processor);
                this.removeChildElementsFromIndex(cModel, processor);
            });
        }

        private void addRequiredDecisions(MultiInstanceDecisionNodeEvaluator miEvaluator, MIDDependenciesProcessor processor) {
            processor.findAllDependencies().stream().filter(DecisionNodeImpl.class::isInstance).map(DecisionNodeImpl.class::cast).forEach(miEvaluator::addReqDecision);
        }

        private void removeChildElementsFromIndex(DMNModelImpl model, MIDDependenciesProcessor processor) {
            processor.findAllChildElements().forEach(arg_0 -> ((DMNModelImpl)model).removeDMNNodeFromIndexes(arg_0));
        }
    }
}

