/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.signavio.MultiInstanceDecisionLogic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignavioTest {
    public static final Logger LOG = LoggerFactory.getLogger(SignavioTest.class);

    @Test
    public void test() {
        DMNRuntime runtime = this.createRuntime("Test_Signavio_multiple.dmn");
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        context.set("persons", Arrays.asList("p1", "p2"));
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        Assertions.assertThat((List)((List)evaluateAll.getContext().get("Greeting for each Person in Persons"))).contains((Object[])new String[]{"Hello p1", "Hello p2"});
    }

    @Test
    public void testUnmarshall() {
        DMNRuntime runtime = this.createRuntime("Test_Signavio_multiple.dmn");
        DMNModel model0 = (DMNModel)runtime.getModels().get(0);
        Definitions definitions = model0.getDefinitions();
        DRGElement decision = definitions.getDrgElement().stream().filter(e -> e.getName().equals("greetingForEachPersonInPersons")).findFirst().orElseThrow(IllegalStateException::new);
        Object extElement = decision.getExtensionElements().getAny().get(0);
        Assertions.assertThat(extElement).isInstanceOf(MultiInstanceDecisionLogic.class);
        MultiInstanceDecisionLogic mid = (MultiInstanceDecisionLogic)extElement;
        LOG.info("{}", (Object)mid);
        Assertions.assertThat((String)mid.getIterationExpression()).isEqualTo("persons");
        Assertions.assertThat((String)mid.getIteratorShapeId()).isEqualTo("id-707bbdf74438414623ac5d7067805b38");
        Assertions.assertThat((String)mid.getAggregationFunction()).isEqualTo("COLLECT");
        Assertions.assertThat((String)mid.getTopLevelDecisionId()).isEqualTo("id-7a23e2f201e3e0db3c991313cff5cd2b");
    }

    @Test
    public void testUsingSignavioFunctions() {
        DMNRuntime runtime = this.createRuntime("Using_Signavio_functions.dmn");
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        LOG.info("{}", (Object)evaluateAll.getContext());
        evaluateAll.getMessages().forEach(System.out::println);
        Assert.assertEquals((Object)true, (Object)evaluateAll.getContext().get("myContext"));
    }

    @Test
    public void testUsingSignavioFunctionsInLiteralExpression() {
        DMNRuntime runtime = this.createRuntime("Starts_with_an_A.dmn");
        this.assertStartsWithAnA(runtime, "Abc", true);
        this.assertStartsWithAnA(runtime, "Xyz", false);
    }

    private void assertStartsWithAnA(DMNRuntime runtime, String testString, boolean startsWithAnA) {
        DMNContext context = runtime.newContext();
        context.set("surname", (Object)testString);
        DMNModel model0 = (DMNModel)runtime.getModels().get(0);
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        evaluateAll.getMessages().forEach(System.out::println);
        Assert.assertFalse((String)evaluateAll.getMessages().toString(), (boolean)evaluateAll.hasErrors());
        Assert.assertEquals((Object)startsWithAnA, (Object)evaluateAll.getContext().get("startsWithAnA"));
    }

    @Test
    public void testSurveyMIDSUM() {
        DMNRuntime runtime = this.createRuntime("survey MID SUM.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 2, 3), new BigDecimal(6));
    }

    private void checkSurveryMID(DMNRuntime runtime, Object numbers, Object iterating) {
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        context.set("numbers", numbers);
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("iterating").getResult()).isEqualTo(iterating);
    }

    private DMNRuntime createRuntime(String modelFileName) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmm = ks.newKieModuleModel();
        kmm.setConfigurationProperty("org.kie.dmn.profiles.signavio", "org.kie.dmn.signavio.KieDMNSignavioProfile");
        kfs.writeKModuleXML(kmm.toXML());
        kfs.write(ks.getResources().newClassPathResource(modelFileName, this.getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results results = kieBuilder.getResults();
        LOG.info("buildAll() completed.");
        results.getMessages(new Message.Level[]{Message.Level.WARNING}).forEach(e -> LOG.warn("{}", e));
        Assert.assertTrue((results.getMessages(new Message.Level[]{Message.Level.WARNING}).size() == 0 ? 1 : 0) != 0);
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        return runtime;
    }

    @Test
    public void testSurveyMIDMIN() {
        DMNRuntime runtime = this.createRuntime("survey MID MIN.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 2, 3), new BigDecimal(1));
    }

    @Test
    public void testSurveyMIDMAX() {
        DMNRuntime runtime = this.createRuntime("survey MID MAX.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 2, 3), new BigDecimal(3));
    }

    @Test
    public void testSurveyMIDCOUNT() {
        DMNRuntime runtime = this.createRuntime("survey MID COUNT.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 1, 1), new BigDecimal(3));
    }

    @Test
    public void testSurveyMIDALLTRUE() {
        DMNRuntime runtime = this.createRuntime("survey MID ALLTRUE.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 2), true);
        this.checkSurveryMID(runtime, Arrays.asList(-1, 2), false);
    }

    @Test
    public void testSurveyMIDANYTRUE() {
        DMNRuntime runtime = this.createRuntime("survey MID ANYTRUE.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, -2), true);
        this.checkSurveryMID(runtime, Arrays.asList(-1, -2), false);
    }

    @Test
    public void testSurveyMIDALLFALSE() {
        DMNRuntime runtime = this.createRuntime("survey MID ALLFALSE.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 2), false);
        this.checkSurveryMID(runtime, Arrays.asList(-1, 2), false);
        this.checkSurveryMID(runtime, Arrays.asList(1, -2), false);
        this.checkSurveryMID(runtime, Arrays.asList(-1, -2), true);
    }

    @Test
    public void testZipFunctions() {
        DMNRuntime runtime = this.createRuntime("Test_SignavioZipFunctions.dmn");
        this.checkBothFunctionsAreWorking(runtime);
    }

    @Test
    public void testMidTakesCareOfRequirements() {
        DMNRuntime runtime = this.createRuntime("Test_SignavioMID.dmn");
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        context.set("numbers1", Arrays.asList(1, 2));
        context.set("numbers2", Arrays.asList(2, 3));
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        List result = (List)evaluateAll.getDecisionResultByName("calculate").getResult();
        Assertions.assertThat((List)result).hasSize(6);
        Assertions.assertThat((List)result).doesNotContainNull();
    }

    @Test
    public void testSignavioConcatFunction() {
        DMNRuntime runtime = this.createRuntime("Signavio_Concat.dmn");
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        context.set("listOfNames", Arrays.asList("John", "Jane", "Doe"));
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        Assert.assertEquals((Object)"JohnJaneDoe", (Object)evaluateAll.getDecisionResultByName("concatNames").getResult());
    }

    private void checkBothFunctionsAreWorking(DMNRuntime runtime) {
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        context.set("names", Arrays.asList("John Doe", "Jane Doe"));
        context.set("ages", Arrays.asList(37, 35));
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        Assertions.assertThat((List)((List)evaluateAll.getDecisionResultByName("zipvararg").getResult())).hasSize(2);
        Assertions.assertThat((List)((List)evaluateAll.getDecisionResultByName("zipsinglelist").getResult())).hasSize(2);
    }

    @Test
    public void testSignavioIterateMultiinstanceWithComplexInputs() {
        DMNRuntime runtime = this.createRuntime("Iterate Complex List.dmn");
        DMNContext context = runtime.newContext();
        HashMap<String, String> johnDoe = new HashMap<String, String>();
        johnDoe.put("iD", "id-john");
        johnDoe.put("name", "John Doe");
        HashMap<String, String> alice = new HashMap<String, String>();
        alice.put("iD", "id-alice");
        alice.put("name", "Alice");
        context.set("customer", Collections.singletonMap("persons", Arrays.asList(johnDoe, alice)));
        DMNModel model0 = (DMNModel)runtime.getModels().get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        Assert.assertEquals(Arrays.asList("John Doe", "Alice"), (Object)evaluateAll.getDecisionResultByName("extractNames").getResult());
    }

    @Test
    public void testSignavioIterateMultiinstanceMultipleDecisions() {
        DMNRuntime runtime = this.createRuntime("MID with multiple inside decisions.dmn");
        DMNContext context = runtime.newContext();
        context.set("names", Arrays.asList("John", "Alice"));
        DMNModel model0 = (DMNModel)runtime.getModels().get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("overallage").getResult()).isEqualTo((Object)new BigDecimal("18"));
    }

    @Test
    public void testSignavioIterateMultiinstanceMultipleDecisionsOutside() {
        DMNRuntime runtime = this.createRuntime("MID with outside requirement.dmn");
        DMNContext context = runtime.newContext();
        context.set("numbers", Arrays.asList(1, 2, 3));
        context.set("operand", (Object)"PLUS");
        DMNModel model0 = (DMNModel)runtime.getModels().get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("sumUp").getResult()).isEqualTo((Object)new BigDecimal("6"));
    }
}

