/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.trisotech.core.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.trisotech.core.util.IterableRange;
import org.kie.dmn.trisotech.core.util.Msg;
import org.kie.dmn.trisotech.model.api.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNIteratorEvaluator
implements DMNExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(DMNIteratorEvaluator.class);
    private String variable;
    private Iterator.IteratorType type;
    private DMNExpressionEvaluator inEvaluator;
    private DMNExpressionEvaluator returnEvaluator;
    private DMNElement node;
    private String name;

    public DMNIteratorEvaluator(String name, DMNElement node, Iterator.IteratorType type, String variable, DMNExpressionEvaluator in, DMNExpressionEvaluator ret) {
        this.name = name;
        this.node = node;
        this.type = type;
        this.variable = variable;
        this.inEvaluator = in;
        this.returnEvaluator = ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        DMNResultImpl result = (DMNResultImpl)dmnr;
        EvaluatorResult inResult = this.inEvaluator.evaluate(eventManager, (DMNResult)result);
        if (inResult == null || inResult.getResultType() != EvaluatorResult.ResultType.SUCCESS) {
            return inResult;
        }
        List<Object> inObj = inResult.getResult();
        if (inObj instanceof Range) {
            inObj = new IterableRange((Range)inObj);
        } else if (!(inObj instanceof Iterable)) {
            if (inObj == null) {
                MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, (DMNMessageManager)result, null, null, (Msg.Message1)Msg.IN_RESULT_NULL, (Object)this.name);
                return new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
            }
            inObj = Collections.singletonList(inObj);
        }
        DMNContext previousContext = result.getContext();
        DMNContext dmnContext = previousContext.clone();
        LinkedList<Object> returnList = new LinkedList<Object>();
        try {
            result.setContext(dmnContext);
            dmnContext.set("partial", returnList);
            for (Object item : (Iterable)inObj) {
                dmnContext.set(this.variable, item);
                EvaluatorResult evaluate = this.returnEvaluator.evaluate(eventManager, dmnr);
                returnList.add(evaluate.getResult());
            }
        }
        finally {
            result.setContext(previousContext);
        }
        switch (this.type) {
            case EVERY: {
                for (Object satisfies : returnList) {
                    if (satisfies instanceof Boolean && ((Boolean)satisfies).booleanValue()) continue;
                    return new EvaluatorResultImpl((Object)Boolean.FALSE, EvaluatorResult.ResultType.SUCCESS);
                }
                return new EvaluatorResultImpl((Object)Boolean.TRUE, EvaluatorResult.ResultType.SUCCESS);
            }
            case SOME: {
                for (Object satisfies : returnList) {
                    if (!(satisfies instanceof Boolean) || !((Boolean)satisfies).booleanValue()) continue;
                    return new EvaluatorResultImpl((Object)Boolean.TRUE, EvaluatorResult.ResultType.SUCCESS);
                }
                return new EvaluatorResultImpl((Object)Boolean.FALSE, EvaluatorResult.ResultType.SUCCESS);
            }
            case FOR: {
                return new EvaluatorResultImpl(returnList, EvaluatorResult.ResultType.SUCCESS);
            }
        }
        return new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
    }
}

