/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.trisotech.core.ast;

import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.trisotech.core.util.Msg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNConditionalEvaluator
implements DMNExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(DMNConditionalEvaluator.class);
    private DMNExpressionEvaluator ifEvaluator;
    private DMNExpressionEvaluator thenEvaluator;
    private DMNExpressionEvaluator elseEvaluator;
    private DMNElement node;
    private String name;

    public DMNConditionalEvaluator(String name, DMNElement node, DMNExpressionEvaluator ifEvaluator, DMNExpressionEvaluator thenEvaluator, DMNExpressionEvaluator elseEvaluator) {
        this.name = name;
        this.node = node;
        this.ifEvaluator = ifEvaluator;
        this.thenEvaluator = thenEvaluator;
        this.elseEvaluator = elseEvaluator;
    }

    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        DMNResultImpl result = (DMNResultImpl)dmnr;
        EvaluatorResult ifEvaluation = this.ifEvaluator.evaluate(eventManager, (DMNResult)result);
        if (ifEvaluation.getResultType().equals((Object)EvaluatorResult.ResultType.SUCCESS)) {
            Object ifResult = ifEvaluation.getResult();
            if (ifResult instanceof Boolean) {
                if (((Boolean)ifResult).booleanValue()) {
                    return this.thenEvaluator.evaluate(eventManager, (DMNResult)result);
                }
                return this.elseEvaluator.evaluate(eventManager, (DMNResult)result);
            }
            if (ifResult == null) {
                return this.elseEvaluator.evaluate(eventManager, (DMNResult)result);
            }
            MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, (DMNMessageManager)result, null, null, (Msg.Message2)Msg.CONDITION_RESULT_NOT_BOOLEAN, (Object)this.name, (Object)(ifResult != null ? ifResult.toString() : "null"));
        }
        return new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
    }
}

