/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.trisotech.core.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.trisotech.core.util.IterableRange;
import org.kie.dmn.trisotech.core.util.Msg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNFilterEvaluator
implements DMNExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(DMNFilterEvaluator.class);
    private DMNExpressionEvaluator inEvaluator;
    private DMNExpressionEvaluator filterEvaluator;
    private DMNElement node;
    private String name;

    public DMNFilterEvaluator(String name, DMNElement node, DMNExpressionEvaluator inEvaluator, DMNExpressionEvaluator filterEvaluator) {
        this.name = name;
        this.node = node;
        this.inEvaluator = inEvaluator;
        this.filterEvaluator = filterEvaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        DMNResultImpl result = (DMNResultImpl)dmnr;
        if (this.inEvaluator == null || this.filterEvaluator == null) {
            return new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
        }
        EvaluatorResult inResult = this.inEvaluator.evaluate(eventManager, (DMNResult)result);
        if (inResult.getResultType() != EvaluatorResult.ResultType.SUCCESS) {
            return inResult;
        }
        List<Object> inObj = inResult.getResult();
        if (inObj instanceof Range) {
            inObj = new IterableRange((Range)inObj);
        } else if (!(inObj instanceof Iterable)) {
            if (inObj == null) {
                MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, (DMNMessageManager)result, null, null, (Msg.Message1)Msg.IN_RESULT_NULL, (Object)this.name);
                return new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
            }
            inObj = Collections.singletonList(inObj);
        }
        DMNContext previousContext = result.getContext();
        DMNContext dmnContext = previousContext.clone();
        LinkedList returnList = new LinkedList();
        try {
            result.setContext(dmnContext);
            boolean first = true;
            for (Object item : (Iterable)inObj) {
                EvaluatorResult evaluate;
                Object evalReturn;
                dmnContext.set("item", item);
                if (item instanceof Map) {
                    Map complexItem = (Map)item;
                    complexItem.forEach((k, v) -> dmnContext.set(k, v));
                }
                if ((evalReturn = (evaluate = this.filterEvaluator.evaluate(eventManager, dmnr)).getResult()) instanceof Boolean && ((Boolean)evalReturn).booleanValue()) {
                    returnList.add(item);
                }
                if (first && evalReturn instanceof Number) {
                    List<Object> list = inObj instanceof List ? inObj : Arrays.asList(inObj);
                    int i = ((Number)evalReturn).intValue();
                    if (i > 0 && i <= list.size()) {
                        EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(list.get(i - 1), EvaluatorResult.ResultType.SUCCESS);
                        return evaluatorResultImpl;
                    }
                    if (i < 0 && Math.abs(i) <= list.size()) {
                        EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(list.get(list.size() + i), EvaluatorResult.ResultType.SUCCESS);
                        return evaluatorResultImpl;
                    }
                    MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, (DMNMessageManager)result, null, null, (Msg.Message2)Msg.INDEX_OUT_OF_BOUND, (Object)list.size(), (Object)i);
                    EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
                    return evaluatorResultImpl;
                }
                first = false;
            }
        }
        finally {
            result.setContext(previousContext);
        }
        return new EvaluatorResultImpl(returnList, EvaluatorResult.ResultType.SUCCESS);
    }
}

