/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.trisotech.core;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.compiler.DMNDecisionLogicCompilerFactory;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.kie.dmn.trisotech.TrisotechDMNProfile;
import org.kie.dmn.trisotech.core.compiler.TrisotechDMNEvaluatorCompilerFactory;
import org.kie.dmn.trisotech.validation.TrisotechValidationTest;

public class DMN14GenericSynthTest {
    public DMNRuntime createRuntime(String model, Class<?> class1) {
        return (DMNRuntime)DMNRuntimeBuilder.fromDefaults().addProfile((DMNProfile)new TrisotechDMNProfile()).setDecisionLogicCompilerFactory((DMNDecisionLogicCompilerFactory)new TrisotechDMNEvaluatorCompilerFactory()).buildConfiguration().fromClasspathResource(model, class1).getOrElseThrow(e -> new RuntimeException("Error initalizing DMNRuntime", (Throwable)e));
    }

    @Test
    public void testFilterDatatype() throws Throwable {
        DMNRuntime runtime = this.createRuntime("boxedcontextextension/filter-datatype.dmn", TrisotechValidationTest.class);
        Assertions.assertThat((Object)runtime).isNotNull();
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_caa02430-93c6-4ba7-a646-81bbcef32978", "Drawing 1");
        Assertions.assertThat((Object)model).isNotNull();
        this.checkFilterDatatype(runtime, model);
    }

    private void checkFilterDatatype(DMNRuntime runtime, DMNModel model) {
        Map tc1 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Value in String", (Object)"x"), DynamicTypeUtils.entry((Object)"Value of Number", (Object)new BigDecimal(1)), DynamicTypeUtils.entry((Object)"value", (Object)"X1")});
        Map tc2 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Value in String", (Object)"y"), DynamicTypeUtils.entry((Object)"Value of Number", (Object)new BigDecimal(2)), DynamicTypeUtils.entry((Object)"value", (Object)"X2")});
        Map tc3 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Value in String", (Object)"x"), DynamicTypeUtils.entry((Object)"Value of Number", (Object)new BigDecimal(3)), DynamicTypeUtils.entry((Object)"value", (Object)"X3")});
        DMNContext context = runtime.newContext();
        context.set("Input", Arrays.asList(tc1, tc2, tc3));
        DMNResult results = runtime.evaluateAll(model, context);
        Assertions.assertThat((Object)results.getDecisionResultByName("Decision").getResult()).isEqualTo(Arrays.asList(tc1, tc3));
    }

    @Test
    public void testFilterDatatype2() throws Throwable {
        DMNRuntime runtime = this.createRuntime("boxedcontextextension/filter-datatype2.dmn", TrisotechValidationTest.class);
        Assertions.assertThat((Object)runtime).isNotNull();
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_caa02430-93c6-4ba7-a646-81bbcef32978", "Drawing 1");
        Assertions.assertThat((Object)model).isNotNull();
        this.checkFilterDatatype(runtime, model);
    }

    @Test
    public void testIteratorDatatype() throws Throwable {
        DMNRuntime runtime = this.createRuntime("boxedcontextextension/iterator-datatype.dmn", TrisotechValidationTest.class);
        Assertions.assertThat((Object)runtime).isNotNull();
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_caa02430-93c6-4ba7-a646-81bbcef32978", "Drawing 1");
        Assertions.assertThat((Object)model).isNotNull();
        this.checkIteratorDatatype(runtime, model);
    }

    private void checkIteratorDatatype(DMNRuntime runtime, DMNModel model) {
        Map tc1 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Value in String", (Object)"x"), DynamicTypeUtils.entry((Object)"Value of Number", (Object)new BigDecimal(1)), DynamicTypeUtils.entry((Object)"value", (Object)"X1")});
        Map tc2 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Value in String", (Object)"y"), DynamicTypeUtils.entry((Object)"Value of Number", (Object)new BigDecimal(2)), DynamicTypeUtils.entry((Object)"value", (Object)"X2")});
        Map tc3 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Value in String", (Object)"z"), DynamicTypeUtils.entry((Object)"Value of Number", (Object)new BigDecimal(3)), DynamicTypeUtils.entry((Object)"value", (Object)"X3")});
        DMNContext context = runtime.newContext();
        context.set("Input", Arrays.asList(tc1, tc2, tc3));
        DMNResult results = runtime.evaluateAll(model, context);
        Assertions.assertThat((Object)results.getDecisionResultByName("Decision").getResult()).isEqualTo(Arrays.asList("x", "y", "z"));
    }

    @Test
    public void testIteratorDatatype2() throws Throwable {
        DMNRuntime runtime = this.createRuntime("boxedcontextextension/iterator-datatype2.dmn", TrisotechValidationTest.class);
        Assertions.assertThat((Object)runtime).isNotNull();
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_caa02430-93c6-4ba7-a646-81bbcef32978", "Drawing 1");
        Assertions.assertThat((Object)model).isNotNull();
        this.checkIteratorDatatype(runtime, model);
    }
}

