/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.MaskedRule;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class SameMsgInAllAPITest
extends AbstractDTAnalysisTest {
    @Test
    public void testSingleModelAPI() {
        List validate = validator.validate(this.getReader("sameMsgInAllAPI.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.verify(validate);
    }

    @Test
    public void testFluentAPI() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.ANALYZE_DECISION_TABLE}).theseModels(new Reader[]{this.getReader("sameMsgInAllAPI.dmn")});
        this.verify(validate);
    }

    private void verify(List<DMNMessage> validate) {
        Assert.assertThat(validate, (Matcher)Matchers.hasSize((int)5));
        DTAnalysis analysis = SameMsgInAllAPITest.getAnalysis(validate, "_4771db14-e088-4d5a-8942-211c57ad0b42");
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)3));
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("2"), Range.RangeBoundary.OPEN, null)))), new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("4"), Range.RangeBoundary.OPEN, null), (Bound)new Bound((Comparable)new BigDecimal("6"), Range.RangeBoundary.OPEN, null)))), new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("8"), Range.RangeBoundary.OPEN, null), (Bound)new Bound((Comparable)new BigDecimal("10"), Range.RangeBoundary.CLOSED, null)))));
        Assert.assertThat(gaps, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.contains((Object[])gaps.toArray()));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)2));
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(1, 2), new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("3"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("4"), Range.RangeBoundary.CLOSED, null))))), new Overlap(Arrays.asList(3, 4), new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("6"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("7"), Range.RangeBoundary.CLOSED, null))))));
        Assert.assertThat(overlaps, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.contains((Object[])overlaps.toArray()));
        Assert.assertThat((Object)analysis.getMaskedRules(), (Matcher)Matchers.hasSize((int)2));
        List<MaskedRule> maskedRules = Arrays.asList(new MaskedRule(2, 1), new MaskedRule(4, 3));
        Assert.assertThat(maskedRules, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)analysis.getMaskedRules(), (Matcher)Matchers.contains((Object[])maskedRules.toArray()));
        Assert.assertTrue((String)"It should contain DMNMessage for the MaskedRule", (boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MASKED_RULE)));
    }
}

