/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class GapsXYTest
extends AbstractDTAnalysisTest {
    @Test
    public void test_GapsXY() {
        List validate = validator.validate(this.getReader("GapsXY.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        GapsXYTest.checkAnalysis(validate);
    }

    @Test
    public void test_GapsXYv2() {
        List validate = validator.validate(this.getReader("GapsXYv2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        GapsXYTest.checkAnalysis(validate);
    }

    public static void checkAnalysis(List<DMNMessage> validate) {
        DTAnalysis analysis = GapsXYTest.getAnalysis(validate, "_ce297a95-b16c-4631-8da5-e739dac9e3c4");
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)3));
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound(Interval.NEG_INF, Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.OPEN, null)), Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.OPEN, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null)))), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null)))), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.OPEN, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound(Interval.NEG_INF, Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.OPEN, null)))));
        Assert.assertThat(gaps, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.contains((Object[])gaps.toArray()));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)0));
    }
}

