/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.lang.ast.DashNode;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.model.api.DecisionRule;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.FunctionDefinition;
import org.kie.dmn.model.api.HitPolicy;
import org.kie.dmn.model.api.InputClause;
import org.kie.dmn.model.api.LiteralExpression;
import org.kie.dmn.model.api.NamedElement;
import org.kie.dmn.model.api.UnaryTests;
import org.kie.dmn.validation.dtanalysis.DMNDTAnalysisMessage;
import org.kie.dmn.validation.dtanalysis.mcdc.MCDCAnalyser;
import org.kie.dmn.validation.dtanalysis.model.Contraction;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputClause;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputEntry;
import org.kie.dmn.validation.dtanalysis.model.DDTAOutputClause;
import org.kie.dmn.validation.dtanalysis.model.DDTARule;
import org.kie.dmn.validation.dtanalysis.model.DDTATable;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.MaskedRule;
import org.kie.dmn.validation.dtanalysis.model.MisleadingRule;
import org.kie.dmn.validation.dtanalysis.model.Overlap;
import org.kie.dmn.validation.dtanalysis.model.RuleColumnCoordinate;
import org.kie.dmn.validation.dtanalysis.model.Subsumption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTAnalysis {
    private static final Logger LOG = LoggerFactory.getLogger(DTAnalysis.class);
    private final List<Hyperrectangle> gaps = new ArrayList<Hyperrectangle>();
    private final List<Overlap> overlaps = new ArrayList<Overlap>();
    private final List<MaskedRule> maskedRules = new ArrayList<MaskedRule>();
    private final Set<MisleadingRule> misleadingRules = new HashSet<MisleadingRule>();
    private final List<Subsumption> subsumptions = new ArrayList<Subsumption>();
    private final List<Contraction> contractions = new ArrayList<Contraction>();
    private final Map<Integer, Collection<Integer>> cacheNonContractingRules = new HashMap<Integer, Collection<Integer>>();
    private boolean c1stNFViolation = false;
    private Collection<Collection<Integer>> cOfDuplicateRules = Collections.emptyList();
    private Collection<Contraction> contractionsViolating2ndNF = new ArrayList<Contraction>();
    private Collection<RuleColumnCoordinate> cellsViolating2ndNF = new ArrayList<RuleColumnCoordinate>();
    private final DecisionTable sourceDT;
    private final Throwable error;
    private final DDTATable ddtaTable;
    private final Collection<DMNMessage> passThruMessages = new ArrayList<DMNMessage>();
    private List<MCDCAnalyser.PosNegBlock> selectedBlocks;

    public DTAnalysis(DecisionTable sourceDT, DDTATable ddtaTable) {
        this.sourceDT = sourceDT;
        this.error = null;
        this.ddtaTable = ddtaTable;
    }

    private DTAnalysis(DecisionTable sourceDT, Throwable error) {
        this.sourceDT = sourceDT;
        this.error = error;
        this.ddtaTable = null;
    }

    public static DTAnalysis ofError(DecisionTable sourceDT, Throwable error) {
        return new DTAnalysis(sourceDT, error);
    }

    public boolean isError() {
        return this.error != null;
    }

    public DDTATable getDdtaTable() {
        return this.ddtaTable;
    }

    public Collection<Hyperrectangle> getGaps() {
        return Collections.unmodifiableList(this.gaps);
    }

    public void addGap(Hyperrectangle gap) {
        this.gaps.add(gap);
    }

    public DecisionTable getSource() {
        return this.sourceDT;
    }

    public List<Overlap> getOverlaps() {
        return Collections.unmodifiableList(this.overlaps);
    }

    public void addOverlap(Overlap overlap) {
        this.overlaps.add(overlap);
    }

    public void normalize() {
        int prevSize = this.overlaps.size();
        this.internalNormalize();
        int curSize = this.overlaps.size();
        if (curSize != prevSize) {
            this.normalize();
        }
    }

    private void internalNormalize() {
        ArrayList<Overlap> newOverlaps = new ArrayList<Overlap>();
        ArrayList<Overlap> overlapsProcessing = new ArrayList<Overlap>();
        overlapsProcessing.addAll(this.overlaps);
        while (!overlapsProcessing.isEmpty()) {
            ArrayList<Overlap> toBeRemoved = new ArrayList<Overlap>();
            ArrayList<Overlap> toBeAdded = new ArrayList<Overlap>();
            Overlap curOverlap = (Overlap)overlapsProcessing.remove(0);
            for (Overlap otherOverlap : overlapsProcessing) {
                if (curOverlap == null) break;
                int x = curOverlap.contigousOnDimension(otherOverlap);
                if (x <= 0) continue;
                Overlap mergedOverlap = Overlap.newByMergeOnDimension(curOverlap, otherOverlap, x);
                curOverlap = null;
                toBeRemoved.add(otherOverlap);
                toBeAdded.add(mergedOverlap);
            }
            for (Overlap x : toBeRemoved) {
                overlapsProcessing.remove(x);
            }
            for (Overlap x : toBeAdded) {
                overlapsProcessing.add(0, x);
            }
            if (curOverlap == null) continue;
            newOverlaps.add(curOverlap);
        }
        this.overlaps.clear();
        this.overlaps.addAll(newOverlaps);
    }

    public List<DMNMessage> asDMNMessages() {
        ArrayList<DMNMessage> results = new ArrayList<DMNMessage>();
        if (this.isError()) {
            DMNDTAnalysisMessage m = new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message2)Msg.DTANALYSIS_ERROR_ANALYSIS_SKIPPED, (Object)this.nameOrIDOfTable(), (Object)this.error.getMessage()), Msg.DTANALYSIS_ERROR_ANALYSIS_SKIPPED.getType());
            results.add((DMNMessage)m);
            return results;
        }
        results.addAll(this.passThruMessages());
        results.addAll(this.gapsAsMessages());
        results.addAll(this.overlapsAsMessages());
        results.addAll(this.maskedAndMisleadingRulesAsMessagesIfPriority());
        results.addAll(this.subsumptionsAsMessages());
        results.addAll(this.contractionsAsMessages());
        results.addAll(this.check1stNFViolationAsMessages());
        results.addAll(this.check2ndNFViolationAsMessages());
        if (results.isEmpty()) {
            DMNDTAnalysisMessage m = new DMNDTAnalysisMessage(this, DMNMessage.Severity.INFO, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_EMPTY, (Object)this.nameOrIDOfTable()), Msg.DTANALYSIS_EMPTY.getType());
            results.add((DMNMessage)m);
            return results;
        }
        return results;
    }

    private Collection<? extends DMNMessage> maskedAndMisleadingRulesAsMessagesIfPriority() {
        if (this.sourceDT.getHitPolicy() != HitPolicy.PRIORITY) {
            return Collections.emptyList();
        }
        ArrayList<DMNDTAnalysisMessage> results = new ArrayList<DMNDTAnalysisMessage>();
        for (MaskedRule masked2 : this.maskedRules) {
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message2)Msg.DTANALYSIS_HITPOLICY_PRIORITY_MASKED_RULE, (Object)masked2.maskedRule, (Object)masked2.maskedBy), Msg.DTANALYSIS_HITPOLICY_PRIORITY_MASKED_RULE.getType(), Collections.singletonList(masked2.maskedRule)));
        }
        for (MisleadingRule misleading : this.misleadingRules) {
            boolean duplicatesAMasked = this.maskedRules.stream().anyMatch(masked -> masked.maskedBy == misleading.misleadingRule && masked.maskedRule == misleading.misleadRule);
            if (!duplicatesAMasked) {
                results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message2)Msg.DTANALYSIS_HITPOLICY_PRIORITY_MISLEADING_RULE, (Object)misleading.misleadingRule, (Object)misleading.misleadRule), Msg.DTANALYSIS_HITPOLICY_PRIORITY_MISLEADING_RULE.getType(), Collections.singletonList(misleading.misleadingRule)));
                continue;
            }
            LOG.debug("Misleading record is not displayed as message because it is redundant to a Masked rule message: {}", (Object)misleading);
        }
        return results;
    }

    private Collection<? extends DMNMessage> subsumptionsAsMessages() {
        ArrayList<DMNDTAnalysisMessage> results = new ArrayList<DMNDTAnalysisMessage>();
        for (Subsumption s : this.subsumptions) {
            List<Integer> inNaturalOrder = Arrays.asList(s.rule, s.includedRule);
            List<Integer> inReversedOrder = Arrays.asList(s.includedRule, s.rule);
            boolean subsumptionIsA1NFdup = this.getDuplicateRulesTuples().stream().anyMatch(tuple -> tuple.equals(inNaturalOrder) || tuple.equals(inReversedOrder));
            if (!subsumptionIsA1NFdup) {
                results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message4)Msg.DTANALYSIS_SUBSUMPTION_RULE, (Object)s.rule, (Object)s.includedRule, (Object)s.rule, (Object)s.includedRule), Msg.DTANALYSIS_SUBSUMPTION_RULE.getType(), Collections.singletonList(s.rule)));
                continue;
            }
            LOG.debug("skipping Subsumption message because it is actually redundant to the 1st NF duplicate rule ERROR: {}", (Object)s);
        }
        return results;
    }

    private Collection<? extends DMNMessage> contractionsAsMessages() {
        ArrayList<DMNDTAnalysisMessage> results = new ArrayList<DMNDTAnalysisMessage>();
        for (Contraction x : this.contractions) {
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message2)Msg.DTANALYSIS_CONTRACTION_RULE, x.impactedRules(), (Object)x.adjacentDimension), Msg.DTANALYSIS_CONTRACTION_RULE.getType(), x.impactedRules()));
        }
        return results;
    }

    private Collection<? extends DMNMessage> check1stNFViolationAsMessages() {
        if (!this.is1stNFViolation()) {
            return Collections.emptyList();
        }
        ArrayList<DMNDTAnalysisMessage> results = new ArrayList<DMNDTAnalysisMessage>();
        if (this.sourceDT.getHitPolicy() == HitPolicy.FIRST) {
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message0)Msg.DTANALYSIS_1STNFVIOLATION_FIRST), Msg.DTANALYSIS_1STNFVIOLATION_FIRST.getType()));
        }
        if (this.sourceDT.getHitPolicy() == HitPolicy.RULE_ORDER) {
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message0)Msg.DTANALYSIS_1STNFVIOLATION_RULE_ORDER), Msg.DTANALYSIS_1STNFVIOLATION_RULE_ORDER.getType()));
        }
        for (Collection<Integer> duplicateRulesTuple : this.getDuplicateRulesTuples()) {
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_1STNFVIOLATION_DUPLICATE_RULES, duplicateRulesTuple), Msg.DTANALYSIS_1STNFVIOLATION_DUPLICATE_RULES.getType(), duplicateRulesTuple));
        }
        return results;
    }

    private Collection<? extends DMNMessage> check2ndNFViolationAsMessages() {
        if (!this.is2ndNFViolation()) {
            return Collections.emptyList();
        }
        ArrayList<DMNDTAnalysisMessage> results = new ArrayList<DMNDTAnalysisMessage>();
        for (Contraction contraction : this.getContractionsViolating2ndNF()) {
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message2)Msg.DTANALYSIS_2NDNFVIOLATION, (Object)contraction.adjacentDimension, contraction.impactedRules()), Msg.DTANALYSIS_2NDNFVIOLATION.getType(), contraction.impactedRules()));
        }
        for (RuleColumnCoordinate ruleColumnCoordinate : this.getCellsViolating2ndNF()) {
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message3)Msg.DTANALYSIS_2NDNFVIOLATION_WAS_DASH, (Object)ruleColumnCoordinate.feelText, (Object)ruleColumnCoordinate.rule, (Object)ruleColumnCoordinate.column), Msg.DTANALYSIS_2NDNFVIOLATION.getType(), Arrays.asList(ruleColumnCoordinate.rule)));
        }
        return results;
    }

    private Collection passThruMessages() {
        return this.passThruMessages;
    }

    private Collection overlapsAsMessages() {
        ArrayList<DMNDTAnalysisMessage> results = new ArrayList<DMNDTAnalysisMessage>();
        block4: for (Overlap overlap : this.overlaps) {
            block0 : switch (this.sourceDT.getHitPolicy()) {
                case UNIQUE: {
                    results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_OVERLAP_HITPOLICY_UNIQUE, (Object)overlap.asHumanFriendly(this.ddtaTable)), Msg.DTANALYSIS_OVERLAP_HITPOLICY_UNIQUE.getType(), overlap.getRules()));
                    break;
                }
                case ANY: {
                    List<Comparable<?>> prevValue = this.ddtaTable.getRule().get(overlap.getRules().get(0) - 1).getOutputEntry();
                    for (int i = 1; i < overlap.getRules().size(); ++i) {
                        int curIndex = overlap.getRules().get(i) - 1;
                        List<Comparable<?>> curValue = this.ddtaTable.getRule().get(curIndex).getOutputEntry();
                        if (!prevValue.equals(curValue)) {
                            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_OVERLAP_HITPOLICY_ANY, (Object)overlap.asHumanFriendly(this.ddtaTable)), Msg.DTANALYSIS_OVERLAP_HITPOLICY_ANY.getType(), overlap.getRules()));
                            break block0;
                        }
                        prevValue = curValue;
                    }
                    continue block4;
                }
                default: {
                    LOG.debug("In case of any other HitPolicy no overalps is reported, DROOLS-5363: {}", (Object)overlap);
                }
            }
        }
        return results;
    }

    private Collection gapsAsMessages() {
        ArrayList<DMNDTAnalysisMessage> results = new ArrayList<DMNDTAnalysisMessage>();
        if (!this.ddtaTable.getColIDsStringWithoutEnum().isEmpty()) {
            List names = this.ddtaTable.getColIDsStringWithoutEnum().stream().map(id -> (InputClause)this.sourceDT.getInput().get(id - 1)).map(InputClause::getInputExpression).map(LiteralExpression::getText).collect(Collectors.toList());
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_GAP_SKIPPED_BECAUSE_FREE_STRING, names), Msg.DTANALYSIS_GAP_SKIPPED_BECAUSE_FREE_STRING.getType()));
            return results;
        }
        for (Hyperrectangle gap : this.gaps) {
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_GAP, (Object)gap.asHumanFriendly(this.ddtaTable)), Msg.DTANALYSIS_GAP.getType()));
        }
        return results;
    }

    public void computeMaskedRules() {
        if (this.sourceDT.getHitPolicy() != HitPolicy.PRIORITY) {
            return;
        }
        for (Overlap overlap : this.overlaps) {
            this.analyseOverlapForMaskedRules(overlap);
        }
    }

    private void analyseOverlapForMaskedRules(Overlap overlap) {
        for (Integer ruleId : overlap.getRules()) {
            List<Comparable<?>> curValues = this.ddtaTable.getRule().get(ruleId - 1).getOutputEntry();
            for (int jOutputIdx = 0; jOutputIdx < this.ddtaTable.outputCols(); ++jOutputIdx) {
                DDTAOutputClause curOutputClause = this.ddtaTable.getOutputs().get(jOutputIdx);
                if (!curOutputClause.isDiscreteDomain()) continue;
                int curOutputIdx = curOutputClause.getOutputOrder().indexOf(curValues.get(jOutputIdx));
                List<Integer> otherRules = DTAnalysis.listWithoutElement(overlap.getRules(), ruleId);
                for (Integer otherRuleID : otherRules) {
                    List<Comparable<?>> otherRuleValues = this.ddtaTable.getRule().get(otherRuleID - 1).getOutputEntry();
                    int otherOutputIdx = curOutputClause.getOutputOrder().indexOf(otherRuleValues.get(jOutputIdx));
                    if (curOutputIdx <= otherOutputIdx) continue;
                    try {
                        boolean isOtherRuleWider = this.comparingRulesIsRightWider(ruleId, otherRuleID);
                        if (!isOtherRuleWider) continue;
                        this.maskedRules.add(new MaskedRule(ruleId, otherRuleID));
                    }
                    catch (ComparingRulesWithMultipleInputEntries e) {
                        this.passThruMessages.add((DMNMessage)new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message3)Msg.DTANALYSIS_HITPOLICY_PRIORITY_ANALYSIS_SKIPPED, (Object)this.sourceDT.getOutputLabel(), (Object)ruleId, (Object)otherRuleID), Msg.DTANALYSIS_HITPOLICY_PRIORITY_ANALYSIS_SKIPPED.getType(), Collections.singletonList(ruleId)));
                    }
                }
            }
        }
    }

    public boolean comparingRulesIsRightWider(int ruleId, int isWiderRuleId) throws ComparingRulesWithMultipleInputEntries {
        boolean isOtherRuleWider = true;
        for (int jInputIdx = 0; isOtherRuleWider && jInputIdx < this.ddtaTable.inputCols(); ++jInputIdx) {
            DDTAInputEntry ruleIdInputAtIdx = this.ddtaTable.getRule().get(ruleId - 1).getInputEntry().get(jInputIdx);
            DDTAInputEntry otherRuleInputAtIdx = this.ddtaTable.getRule().get(isWiderRuleId - 1).getInputEntry().get(jInputIdx);
            if (ruleIdInputAtIdx.getIntervals().size() != 1 || otherRuleInputAtIdx.getIntervals().size() != 1) {
                throw new ComparingRulesWithMultipleInputEntries("Multiple entries not supported");
            }
            Interval ruleIdInterval = ruleIdInputAtIdx.getIntervals().get(0);
            Interval otherRuleInterval = otherRuleInputAtIdx.getIntervals().get(0);
            isOtherRuleWider = isOtherRuleWider && otherRuleInterval.includes(ruleIdInterval);
        }
        return isOtherRuleWider;
    }

    public List<MaskedRule> getMaskedRules() {
        return Collections.unmodifiableList(this.maskedRules);
    }

    public void computeMisleadingRules() {
        if (this.sourceDT.getHitPolicy() != HitPolicy.PRIORITY) {
            return;
        }
        for (Overlap overlap : this.overlaps) {
            this.analyseOverlapForMisleadingRules(overlap);
        }
    }

    private void analyseOverlapForMisleadingRules(Overlap overlap) {
        for (Integer ruleId : overlap.getRules()) {
            List<Comparable<?>> curValues = this.ddtaTable.getRule().get(ruleId - 1).getOutputEntry();
            for (int jOutputIdx = 0; jOutputIdx < this.ddtaTable.outputCols(); ++jOutputIdx) {
                boolean isOutputLowestPriority;
                DDTAOutputClause curOutputClause = this.ddtaTable.getOutputs().get(jOutputIdx);
                if (!curOutputClause.isDiscreteDomain()) continue;
                int curOutputIdx = curOutputClause.getOutputOrder().indexOf(curValues.get(jOutputIdx));
                boolean bl = isOutputLowestPriority = curOutputIdx == curOutputClause.getOutputOrder().size() - 1;
                if (isOutputLowestPriority) continue;
                List<DDTAInputEntry> inputEntry = this.ddtaTable.getRule().get(ruleId - 1).getInputEntry();
                for (int col = 0; col < inputEntry.size(); ++col) {
                    boolean thisColIsHypen = inputEntry.get(col).getUts().stream().anyMatch(DashNode.class::isInstance);
                    if (!thisColIsHypen) continue;
                    List<Integer> otherRules = DTAnalysis.listWithoutElement(overlap.getRules(), ruleId);
                    for (Integer otherRuleID : otherRules) {
                        List<Comparable<?>> otherRuleValues = this.ddtaTable.getRule().get(otherRuleID - 1).getOutputEntry();
                        int otherOutputIdx = curOutputClause.getOutputOrder().indexOf(otherRuleValues.get(jOutputIdx));
                        List<DDTAInputEntry> otherRuleInputEntry = this.ddtaTable.getRule().get(otherRuleID - 1).getInputEntry();
                        boolean thatColIsHypen = otherRuleInputEntry.get(col).getUts().stream().anyMatch(DashNode.class::isInstance);
                        if (otherOutputIdx <= curOutputIdx || thatColIsHypen) continue;
                        this.misleadingRules.add(new MisleadingRule(ruleId, otherRuleID));
                    }
                }
            }
        }
    }

    private static <T> List<T> listWithoutElement(List<T> coll, T elem) {
        ArrayList<T> others = new ArrayList<T>(coll);
        others.remove(elem);
        return others;
    }

    public Collection<MisleadingRule> getMisleadingRules() {
        return Collections.unmodifiableSet(this.misleadingRules);
    }

    public void computeSubsumptions() {
        for (Overlap overlap : this.overlaps) {
            this.analyseOverlapForSubsumptions(overlap);
        }
    }

    private void analyseOverlapForSubsumptions(Overlap overlap) {
        HashSet outputEntries = new HashSet();
        for (Integer n : overlap.getRules()) {
            List<Comparable<?>> curValues = this.ddtaTable.getRule().get(n - 1).getOutputEntry();
            outputEntries.add(curValues);
        }
        for (List list : outputEntries) {
            ArrayList<Integer> rulesWithGivenOutputEntry = new ArrayList<Integer>();
            for (Integer ruleId : overlap.getRules()) {
                List<Comparable<?>> curValues = this.ddtaTable.getRule().get(ruleId - 1).getOutputEntry();
                if (!curValues.equals(list)) continue;
                rulesWithGivenOutputEntry.add(ruleId);
            }
            for (Integer ruleId : rulesWithGivenOutputEntry) {
                List<DDTAInputEntry> curInputEntries = this.ddtaTable.getRule().get(ruleId - 1).getInputEntry();
                List<Integer> otherRules = DTAnalysis.listWithoutElement(rulesWithGivenOutputEntry, ruleId);
                for (Integer otherRuleId : otherRules) {
                    List<DDTAInputEntry> otherInputEntries = this.ddtaTable.getRule().get(otherRuleId - 1).getInputEntry();
                    boolean inputEntriesIncludeAll = DDTARule.inputEntriesIncludeAll(curInputEntries, otherInputEntries);
                    if (!inputEntriesIncludeAll) continue;
                    this.subsumptions.add(new Subsumption(ruleId, otherRuleId));
                }
            }
        }
    }

    public List<Subsumption> getSubsumptions() {
        return Collections.unmodifiableList(this.subsumptions);
    }

    private boolean areRulesSubsumption(Integer a, Integer b) {
        return this.subsumptions.stream().filter(s -> s.rule == a && s.includedRule == b || s.rule == b && s.includedRule == a).findAny().isPresent();
    }

    private boolean areRulesContraction(Integer a, Integer b) {
        return this.contractions.stream().filter(s -> s.rule == b && s.pairedRules.contains(a) || s.rule == a && s.pairedRules.contains(b)).findAny().isPresent();
    }

    private boolean areRulesInNonContractionCache(Integer a, Integer b) {
        return ((Collection)this.cacheNonContractingRules.getOrDefault(a, Collections.emptySet())).contains(b) || ((Collection)this.cacheNonContractingRules.getOrDefault(b, Collections.emptySet())).contains(a);
    }

    public void computeContractions() {
        Set<List<Comparable<?>>> outputEntries = this.ddtaTable.outputEntries();
        for (List<Comparable<?>> curOutputEntry : outputEntries) {
            List<Integer> rulesWithGivenOutputEntry = this.ddtaTable.ruleIDsByOutputEntry(curOutputEntry);
            for (Integer ruleId : rulesWithGivenOutputEntry) {
                List<DDTAInputEntry> curInputEntries = this.ddtaTable.getRule().get(ruleId - 1).getInputEntry();
                List<Integer> otherRules = DTAnalysis.listWithoutElement(rulesWithGivenOutputEntry, ruleId);
                for (Integer otherRuleId : otherRules) {
                    if (this.areRulesSubsumption(ruleId, otherRuleId) || this.areRulesContraction(ruleId, otherRuleId) || this.areRulesInNonContractionCache(ruleId, otherRuleId)) continue;
                    LOG.debug("computeContractions ruleId {} otherRuleId {}", (Object)ruleId, (Object)otherRuleId);
                    List<DDTAInputEntry> otherInputEntries = this.ddtaTable.getRule().get(otherRuleId - 1).getInputEntry();
                    int detectedAdjacentOrOverlap = 0;
                    boolean allEqualsAllowingOneAdjOverlap = true;
                    for (int i = 0; i < curInputEntries.size(); ++i) {
                        boolean canOverlapThisDimention;
                        DDTAInputEntry curIE = curInputEntries.get(i);
                        DDTAInputEntry otherIE = otherInputEntries.get(i);
                        boolean intervalsAreEqual = curIE.getIntervals().equals(otherIE.getIntervals());
                        if (intervalsAreEqual) continue;
                        boolean bl = canOverlapThisDimention = detectedAdjacentOrOverlap == 0 && curIE.adjOrOverlap(otherIE);
                        if (canOverlapThisDimention) {
                            detectedAdjacentOrOverlap = i + 1;
                            continue;
                        }
                        allEqualsAllowingOneAdjOverlap = false;
                    }
                    if (allEqualsAllowingOneAdjOverlap) {
                        ArrayList<Interval> allIntervals = new ArrayList<Interval>();
                        allIntervals.addAll(curInputEntries.get(detectedAdjacentOrOverlap - 1).getIntervals());
                        allIntervals.addAll(otherInputEntries.get(detectedAdjacentOrOverlap - 1).getIntervals());
                        List<Interval> flatten = Interval.flatten(allIntervals);
                        DDTAInputClause ddtaInputClause = this.ddtaTable.getInputs().get(detectedAdjacentOrOverlap - 1);
                        if (ddtaInputClause.isDiscreteDomain()) {
                            flatten = Interval.normalizeDiscrete(flatten, ddtaInputClause.getDiscreteValues());
                        }
                        Contraction contraction = new Contraction(ruleId, Arrays.asList(otherRuleId), detectedAdjacentOrOverlap, flatten);
                        LOG.debug("NEW CONTRACTION: {}", (Object)contraction);
                        this.contractions.add(contraction);
                        continue;
                    }
                    this.cacheNonContractingRules.computeIfAbsent(otherRuleId, x -> new HashSet()).add(ruleId);
                    this.cacheNonContractingRules.computeIfAbsent(ruleId, x -> new HashSet()).add(otherRuleId);
                }
            }
        }
        if (!this.contractions.isEmpty()) {
            this.normalizeContractions();
        }
    }

    private void normalizeContractions() {
        int prevSize = this.overlaps.size();
        this.internalNormalizeContractions();
        int curSize = this.overlaps.size();
        if (curSize != prevSize) {
            this.normalizeContractions();
        }
    }

    private void internalNormalizeContractions() {
        ArrayList<Contraction> newCollection = new ArrayList<Contraction>();
        ArrayList<Contraction> collectionProcessing = new ArrayList<Contraction>();
        collectionProcessing.addAll(this.contractions);
        while (!collectionProcessing.isEmpty()) {
            ArrayList<Contraction> toBeRemoved = new ArrayList<Contraction>();
            ArrayList<Contraction> toBeAdded = new ArrayList<Contraction>();
            Contraction cur = (Contraction)collectionProcessing.remove(0);
            for (Contraction other : collectionProcessing) {
                if (cur == null) break;
                if (cur.adjacentDimension != other.adjacentDimension || !Interval.adjOrOverlap(cur.dimensionAsContracted, other.dimensionAsContracted)) continue;
                ArrayList<Interval> intervals = new ArrayList<Interval>();
                intervals.addAll(cur.dimensionAsContracted);
                intervals.addAll(other.dimensionAsContracted);
                List<Interval> flatten = Interval.flatten(intervals);
                DDTAInputClause ddtaInputClause = this.ddtaTable.getInputs().get(cur.adjacentDimension - 1);
                if (ddtaInputClause.isDiscreteDomain()) {
                    flatten = Interval.normalizeDiscrete(flatten, ddtaInputClause.getDiscreteValues());
                }
                HashSet<Integer> allRules = new HashSet<Integer>();
                allRules.add(cur.rule);
                allRules.add(other.rule);
                allRules.addAll(cur.pairedRules);
                allRules.addAll(other.pairedRules);
                Integer mainRuleId = (Integer)Collections.min(allRules);
                allRules.remove(mainRuleId);
                Contraction merged = new Contraction(mainRuleId, allRules, cur.adjacentDimension, flatten);
                LOG.debug("MERGED CONTRACTION: {}", (Object)merged);
                cur = null;
                toBeRemoved.add(other);
                toBeAdded.add(merged);
            }
            for (Contraction x : toBeRemoved) {
                collectionProcessing.remove(x);
            }
            for (Contraction x : toBeAdded) {
                collectionProcessing.add(0, x);
            }
            if (cur == null) continue;
            newCollection.add(cur);
        }
        this.contractions.clear();
        this.contractions.addAll(newCollection);
    }

    public List<Contraction> getContractions() {
        return Collections.unmodifiableList(this.contractions);
    }

    public void compute1stNFViolations() {
        if (this.sourceDT.getHitPolicy() == HitPolicy.FIRST || this.sourceDT.getHitPolicy() == HitPolicy.RULE_ORDER) {
            this.c1stNFViolation = true;
        }
        this.cOfDuplicateRules = this.ddtaTable.getCacheByInputEntry().values().stream().filter(c -> c.size() > 1).collect(Collectors.toList());
        if (!this.cOfDuplicateRules.isEmpty()) {
            this.c1stNFViolation = true;
        }
        LOG.debug("compute1stNFViolations() c1stNFViolation result: {}", (Object)this.c1stNFViolation);
    }

    public boolean is1stNFViolation() {
        return this.c1stNFViolation;
    }

    public Collection<Collection<Integer>> getDuplicateRulesTuples() {
        return Collections.unmodifiableCollection(this.cOfDuplicateRules);
    }

    public void compute2ndNFViolations() {
        if (this.is1stNFViolation()) {
            LOG.debug("Violated already at 1st NF.");
            return;
        }
        for (Contraction c : this.contractions) {
            Interval domainMinMax;
            if (c.dimensionAsContracted.size() != 1 || !(domainMinMax = this.ddtaTable.getInputs().get(c.adjacentDimension - 1).getDomainMinMax()).equals(c.dimensionAsContracted.get(0))) continue;
            LOG.debug("compute2ndNFViolations() Contraction: {} violates 2NF", (Object)c);
            this.contractionsViolating2ndNF.add(c);
        }
        for (int r = 0; r < this.ddtaTable.getRule().size(); ++r) {
            DDTARule rule = this.ddtaTable.getRule().get(r);
            for (int c = 0; c < this.ddtaTable.getInputs().size(); ++c) {
                DDTAInputClause col;
                boolean includes;
                if (rule.getInputEntry().get(c).getIntervals().size() != 1) continue;
                Interval int0 = rule.getInputEntry().get(c).getIntervals().get(0);
                if (rule.getInputEntry().get(c).getUts().get(0) instanceof DashNode || int0.getLowerBound().getBoundaryType() != Range.RangeBoundary.CLOSED || int0.getUpperBound().getBoundaryType() != Range.RangeBoundary.CLOSED || int0.getLowerBound().getValue().equals(int0.getUpperBound().getValue()) || !(includes = int0.includes((col = this.ddtaTable.getInputs().get(c)).getDomainMinMax()))) continue;
                RuleColumnCoordinate rc = new RuleColumnCoordinate(r + 1, c + 1, ((UnaryTests)((DecisionRule)this.sourceDT.getRule().get(r)).getInputEntry().get(c)).getText());
                LOG.debug("compute2ndNFViolations() Cell: {} violates 2NF", (Object)rc);
                this.cellsViolating2ndNF.add(rc);
            }
        }
        LOG.debug("compute2ndNFViolations() c2ndNFViolation result: {}", (Object)this.is2ndNFViolation());
    }

    public boolean is2ndNFViolation() {
        return !this.contractionsViolating2ndNF.isEmpty() || !this.cellsViolating2ndNF.isEmpty();
    }

    public Collection<Contraction> getContractionsViolating2ndNF() {
        return Collections.unmodifiableCollection(this.contractionsViolating2ndNF);
    }

    public Collection<RuleColumnCoordinate> getCellsViolating2ndNF() {
        return Collections.unmodifiableCollection(this.cellsViolating2ndNF);
    }

    public void computeHitPolicyRecommender() {
        if (!this.gaps.isEmpty() || !this.isHitPolicySingle(this.sourceDT.getHitPolicy())) {
            return;
        }
        if (this.overlaps.isEmpty() && this.sourceDT.getHitPolicy() != HitPolicy.UNIQUE) {
            this.passThruMessages.add((DMNMessage)new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_HITPOLICY_RECOMMENDER_UNIQUE, (Object)this.nameOrIDOfTable()), Msg.DTANALYSIS_HITPOLICY_RECOMMENDER_UNIQUE.getType()));
        } else if (!this.overlaps.isEmpty()) {
            boolean overlapsShareSameOutput = true;
            for (Overlap ol : this.overlaps) {
                List<Integer> rules = ol.getRules();
                HashSet outputsForOverlap = new HashSet();
                for (Integer ruleID : rules) {
                    outputsForOverlap.add(this.ddtaTable.getRule().get(ruleID - 1).getOutputEntry());
                }
                overlapsShareSameOutput &= outputsForOverlap.size() == 1;
            }
            if (overlapsShareSameOutput && this.sourceDT.getHitPolicy() != HitPolicy.ANY) {
                this.passThruMessages.add((DMNMessage)new DMNDTAnalysisMessage(this, this.sourceDT.getHitPolicy() == HitPolicy.UNIQUE ? DMNMessage.Severity.ERROR : DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_HITPOLICY_RECOMMENDER_ANY, (Object)this.nameOrIDOfTable()), Msg.DTANALYSIS_HITPOLICY_RECOMMENDER_ANY.getType()));
            } else if (!overlapsShareSameOutput && this.sourceDT.getHitPolicy() != HitPolicy.PRIORITY) {
                this.passThruMessages.add((DMNMessage)new DMNDTAnalysisMessage(this, this.sourceDT.getHitPolicy() == HitPolicy.FIRST ? DMNMessage.Severity.WARN : DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_HITPOLICY_RECOMMENDER_PRIORITY, (Object)this.nameOrIDOfTable()), Msg.DTANALYSIS_HITPOLICY_RECOMMENDER_PRIORITY.getType()));
            }
        }
    }

    public boolean isHitPolicySingle(HitPolicy hp) {
        return hp == HitPolicy.UNIQUE || hp == HitPolicy.ANY || hp == HitPolicy.PRIORITY || hp == HitPolicy.FIRST;
    }

    public String nameOrIDOfTable() {
        if (this.sourceDT.getOutputLabel() != null && !this.sourceDT.getOutputLabel().isEmpty()) {
            return this.sourceDT.getOutputLabel();
        }
        if (this.sourceDT.getParent() instanceof NamedElement) {
            return ((NamedElement)this.sourceDT.getParent()).getName();
        }
        if (this.sourceDT.getParent() instanceof FunctionDefinition && this.sourceDT.getParent().getParent() instanceof NamedElement) {
            return ((NamedElement)this.sourceDT.getParent().getParent()).getName();
        }
        return "[ID: " + this.sourceDT.getId() + "]";
    }

    public void computeOutputInLOV() {
        for (int ruleIdx = 0; ruleIdx < this.ddtaTable.getRule().size(); ++ruleIdx) {
            DDTARule rule = this.ddtaTable.getRule().get(ruleIdx);
            for (int outputIdx = 0; outputIdx < this.ddtaTable.getOutputs().size(); ++outputIdx) {
                Comparable<?> value = rule.getOutputEntry().get(outputIdx);
                DDTAOutputClause outputClause = this.ddtaTable.getOutputs().get(outputIdx);
                if (!outputClause.isDiscreteDomain() || outputClause.getDiscreteValues().contains(value)) continue;
                this.passThruMessages.add((DMNMessage)new DMNDTAnalysisMessage(this, DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message4)Msg.DTANALYSIS_ERROR_RULE_OUTPUT_OUTSIDE_LOV, (Object)(ruleIdx + 1), value, (Object)(outputIdx + 1), (Object)outputClause.getDiscreteValues()), Msg.DTANALYSIS_ERROR_RULE_OUTPUT_OUTSIDE_LOV.getType()));
            }
        }
    }

    public void setMCDCSelectedBlocks(List<MCDCAnalyser.PosNegBlock> selectedBlocks) {
        this.selectedBlocks = selectedBlocks;
    }

    public List<MCDCAnalyser.PosNegBlock> getMCDCSelectedBlocks() {
        return Collections.unmodifiableList(this.selectedBlocks);
    }

    public class ComparingRulesWithMultipleInputEntries
    extends Exception {
        public ComparingRulesWithMultipleInputEntries(String message) {
            super(message);
        }
    }
}

