/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.classloader;

import java.io.Reader;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.dmn.validation.ValidatorUtil;
import org.kie.internal.utils.ChainedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorClassloaderTest
extends AbstractValidatorTest {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorClassloaderTest.class);

    @Test
    public void test() {
        String JAVA_SOURCE = "package com.acme.functions;\npublic class Dummy {\n    public static String hello() {\n        return \"Hello World\";\n    }\n}";
        KieServices ks = KieServices.Factory.get();
        ReleaseId kjarReleaseId = ks.newReleaseId("org.kie.dmn.validation", "testValidatorClassloaderTest", UUID.randomUUID().toString());
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/java/com/acme/functions/Dummy.java", JAVA_SOURCE);
        kfs.write(ks.getResources().newClassPathResource("DummyInvocation.dmn", this.getClass()));
        kfs.generateAndWritePomXML(kjarReleaseId);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        ((ListAssert)Assertions.assertThat((List)kieBuilder.getResults().getMessages()).as(kieBuilder.getResults().getMessages().toString(), new Object[0])).isEmpty();
        KieContainer container = ks.newKieContainer(kjarReleaseId);
        DMNRuntime runtime = (DMNRuntime)KieRuntimeFactory.of((KieBase)container.getKieBase()).get(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("https://kiegroup.org/dmn/_69EA2E1A-F706-4CFB-8026-9E41397F6301", "DummyInvocation");
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, runtime.newContext());
        LOG.debug("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("Decision-1").getResult()).isEqualTo((Object)"Hello World");
        ClassLoader kieProjectCL = container.getClassLoader();
        List defaultDMNProfiles = DMNAssemblerService.getDefaultDMNProfiles((ChainedProperties)ChainedProperties.getChainedProperties((ClassLoader)kieProjectCL));
        DMNValidator validatorWithCustomCL = DMNValidatorFactory.newValidator((ClassLoader)kieProjectCL, (List)defaultDMNProfiles);
        List validate = validatorWithCustomCL.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("DummyInvocation.dmn")});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }
}

