/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;

public class Check1stNFViolationTest
extends AbstractDTAnalysisTest {
    @Test
    public void testCheck1stNFViolation() {
        List validate = validator.validate(this.getReader("DT1stNFViolation.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysisDuplicate = Check1stNFViolationTest.getAnalysis(validate, "_053034d5-0e1f-4c4a-8513-ab3c6ba538db");
        Assertions.assertThat((boolean)analysisDuplicate.is1stNFViolation()).isTrue();
        Assertions.assertThat((Collection)analysisDuplicate.getDuplicateRulesTuples()).hasSize(1);
        Assertions.assertThat((Collection)analysisDuplicate.getDuplicateRulesTuples()).containsAll(Collections.singletonList(Arrays.asList(1, 2)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_053034d5-0e1f-4c4a-8513-ab3c6ba538db") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION))).as("It should contain at DMNMessage for the 1st NF Violation", new Object[0])).isTrue();
        DTAnalysis analysisFIRST = Check1stNFViolationTest.getAnalysis(validate, "_1ca6acde-c1d4-4c50-8e21-f3b11e106f3d");
        Assertions.assertThat((boolean)analysisFIRST.is1stNFViolation()).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_1ca6acde-c1d4-4c50-8e21-f3b11e106f3d") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION))).as("It should contain at DMNMessage for the 1st NF Violation", new Object[0])).isTrue();
        DTAnalysis analysisRULE_ORDER = Check1stNFViolationTest.getAnalysis(validate, "_03522945-b520-4b45-ac5e-ef3cbd7f1eaf");
        Assertions.assertThat((boolean)analysisRULE_ORDER.is1stNFViolation()).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_03522945-b520-4b45-ac5e-ef3cbd7f1eaf") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION))).as("It should contain at DMNMessage for the 1st NF Violation", new Object[0])).isTrue();
    }

    @Test
    public void testCheck1stNFViolationB() {
        List validate = validator.validate(this.getReader("DT1stNFViolationB.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysisDuplicate = Check1stNFViolationTest.getAnalysis(validate, "_053034d5-0e1f-4c4a-8513-ab3c6ba538db");
        Assertions.assertThat((boolean)analysisDuplicate.is1stNFViolation()).isTrue();
        Assertions.assertThat((Collection)analysisDuplicate.getDuplicateRulesTuples()).hasSize(1);
        Assertions.assertThat((Collection)analysisDuplicate.getDuplicateRulesTuples()).containsAll(Collections.singletonList(Arrays.asList(1, 2)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_053034d5-0e1f-4c4a-8513-ab3c6ba538db") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION))).as("It should contain at DMNMessage for the 1st NF Violation", new Object[0])).isTrue();
    }

    @Test
    public void testCheck1stNFViolationDuplicateNoSubsumption() {
        List validate = validator.validate(this.getReader("DT1stNFViolationDuplicateNoSubsumption.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = Check1stNFViolationTest.getAnalysis(validate, "_221BF4A4-F8D4-466C-96E4-311FE3C9867B");
        Assertions.assertThat((boolean)analysis.is1stNFViolation()).isTrue();
        Assertions.assertThat((Collection)analysis.getDuplicateRulesTuples()).hasSize(1);
        Assertions.assertThat((Collection)analysis.getDuplicateRulesTuples()).containsAll(Collections.singletonList(Arrays.asList(1, 2)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION))).as("It should contain at DMNMessage for the 1st NF Violation", new Object[0])).isTrue();
        Assertions.assertThat((List)analysis.getSubsumptions()).isNotEmpty();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().noneMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_SUBSUMPTION_RULE))).as("No message about subsumption", new Object[0])).isTrue();
    }

    @Test
    public void testCheck1stNFViolationCollect() {
        List validate = validator.validate(this.getReader("DT1stNFViolationCollect.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysisDuplicate = Check1stNFViolationTest.getAnalysis(validate, "_4237d55b-2589-48a5-8183-f9f4e0e00c07");
        Assertions.assertThat((boolean)analysisDuplicate.is1stNFViolation()).isTrue();
        Assertions.assertThat((Collection)analysisDuplicate.getDuplicateRulesTuples()).hasSize(2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_4237d55b-2589-48a5-8183-f9f4e0e00c07") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION))).as("It should contain DMNMessage(s) for the 1st NF Violation", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().filter(p -> p.getSourceId().equals("_4237d55b-2589-48a5-8183-f9f4e0e00c07") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION)).allMatch(p -> p.getLevel() == Message.Level.WARNING)).as("Being a C table, DMNMessage(s) for the 1st NF Violation are of type Warning", new Object[0])).isTrue();
    }
}

