/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;

public class FailingOutputConstraintsTest
extends AbstractDTAnalysisTest {
    @Test
    public void testFailingOutputConstraints() {
        List validate = validator.validate(this.getReader("FailingOutputConstraints.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_ANALYSIS_ERROR))).as("It should contain DMNMessage for output outside of LoV", new Object[0])).isTrue();
        FailingOutputConstraintsTest.debugValidatorMsg(validate);
        DTAnalysis analysis = FailingOutputConstraintsTest.getAnalysis(validate, "_E72BD036-C550-4992-AA6D-A8AD4666C63A");
        Assertions.assertThat((boolean)analysis.isError()).isFalse();
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
    }

    @Test
    public void testFailingOutputConstraintsWhenOutputIsSymbol() {
        List validate = validator.validate(this.getReader("FailingOutputConstraints2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        FailingOutputConstraintsTest.debugValidatorMsg(validate);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().noneMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_ANALYSIS_ERROR))).as("It should NOT contain DMNMessage for output outside of LoV (using a symbol in output)", new Object[0])).isTrue();
        DTAnalysis analysis = FailingOutputConstraintsTest.getAnalysis(validate, "_E72BD036-C550-4992-AA6D-A8AD4666C63A");
        Assertions.assertThat((boolean)analysis.isError()).isFalse();
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
    }
}

