/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class GapsOverlapsBooleanTest
extends AbstractDTAnalysisTest {
    @Test
    public void test() {
        List validate = validator.validate(this.getReader("GapsOverlapsBoolean.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = GapsOverlapsBooleanTest.getAnalysis(validate, "_EE34FD37-00D1-47A7-B2F6-CC9BCEF30005");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.CLOSED, null)))));
        Assertions.assertThat(gaps).hasSize(1);
        Assertions.assertThat((Collection)analysis.getGaps()).containsAll(gaps);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(1);
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(1, 2), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)Boolean.valueOf(false), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.OPEN, null)), Interval.newFromBounds((Bound)new Bound((Comparable)Boolean.valueOf(false), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.OPEN, null))))));
        Assertions.assertThat(overlaps).hasSize(1);
        Assertions.assertThat((List)analysis.getOverlaps()).containsAll(overlaps);
    }
}

