/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;

public class SymbolInDTTest
extends AbstractDTAnalysisTest {
    @Test
    public void testSymbolMyThreshold() {
        List validate = validator.validate(this.getReader("SymbolInDT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(this.messageForSymbol("my threshold"))).as("It should contain DMNMessage for symbol not supported in input", new Object[0])).isTrue();
        DTAnalysis analysis1 = SymbolInDTTest.getAnalysis(validate, "_50D70081-079A-40DA-BA9C-B1173F0D2831");
        Assertions.assertThat((boolean)analysis1.isError()).isTrue();
    }

    private Predicate<? super DMNMessage> messageForSymbol(String symbolName) {
        return p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_ANALYSIS_ERROR) && p.getText().contains("symbol reference: '" + symbolName + "'.");
    }

    @Test
    public void testSymbolLastDateOfWork() {
        List validate = validator.validate(this.getReader("SymbolInDT2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(this.messageForSymbol("Last Date of Work"))).as("It should contain DMNMessage for symbol not supported in input", new Object[0])).isTrue();
        DTAnalysis analysis1 = SymbolInDTTest.getAnalysis(validate, "_50D70081-079A-40DA-BA9C-B1173F0D2831");
        Assertions.assertThat((boolean)analysis1.isError()).isTrue();
    }
}

