/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kie.dmn.feel.util.Generated;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DDTATable;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class Overlap {
    private final List<Integer> rules = new ArrayList<Integer>();
    private final Hyperrectangle overlap;

    public Overlap(Collection<Integer> rules, Hyperrectangle overlap) {
        this.rules.addAll(rules);
        this.overlap = overlap;
    }

    public List<Integer> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public Hyperrectangle getOverlap() {
        return this.overlap;
    }

    public String toString() {
        return "Overlap values " + this.overlap + " for rules: " + this.rules;
    }

    public int contigousOnDimension(Overlap other) {
        if (!this.rules.equals(other.rules)) {
            return 0;
        }
        for (int d = 0; d < this.overlap.getDimensions(); ++d) {
            Interval thisDEdge = this.overlap.getEdges().get(d);
            Interval otherDEdge = other.overlap.getEdges().get(d);
            if (!Bound.adOrOver(thisDEdge.getUpperBound(), otherDEdge.getLowerBound()) && !Bound.adOrOver(otherDEdge.getUpperBound(), thisDEdge.getLowerBound())) continue;
            boolean otherDimensionsSame = true;
            for (int o = 0; o < this.overlap.getDimensions(); ++o) {
                if (o == d) continue;
                otherDimensionsSame &= this.overlap.getEdges().get(o).equals(other.overlap.getEdges().get(o));
            }
            if (!otherDimensionsSame) continue;
            return d + 1;
        }
        return 0;
    }

    public static Overlap newByMergeOnDimension(Overlap o1, Overlap o2, int dimension) {
        int d = dimension - 1;
        List<Integer> rules = o1.rules;
        Interval[] newOverlapHR = new Interval[o1.getOverlap().getDimensions()];
        for (int o = 0; o < o1.overlap.getDimensions(); ++o) {
            Interval newFromBounds;
            if (o != d) {
                newOverlapHR[o] = o1.overlap.getEdges().get(o);
                continue;
            }
            Interval o1MergeEdge = o1.overlap.getEdges().get(o);
            Interval o2MergeEdge = o2.overlap.getEdges().get(o);
            if (Bound.adOrOver(o1MergeEdge.getUpperBound(), o2MergeEdge.getLowerBound())) {
                newOverlapHR[o] = newFromBounds = Interval.newFromBounds(o1MergeEdge.getLowerBound(), o2MergeEdge.getUpperBound());
                continue;
            }
            if (Bound.adOrOver(o2MergeEdge.getUpperBound(), o1MergeEdge.getLowerBound())) {
                newOverlapHR[o] = newFromBounds = Interval.newFromBounds(o2MergeEdge.getLowerBound(), o1MergeEdge.getUpperBound());
                continue;
            }
            throw new IllegalStateException();
        }
        Hyperrectangle hr = new Hyperrectangle(o1.overlap.getDimensions(), Arrays.asList(newOverlapHR));
        return new Overlap(rules, hr);
    }

    @Generated(value={"org.eclipse.jdt.internal.corext.codemanipulation"})
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.overlap == null ? 0 : this.overlap.hashCode());
        result = 31 * result + this.rules.hashCode();
        return result;
    }

    @Generated(value={"org.eclipse.jdt.internal.corext.codemanipulation"})
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Overlap other = (Overlap)obj;
        if (this.overlap == null ? other.overlap != null : !this.overlap.equals(other.overlap)) {
            return false;
        }
        return this.rules.equals(other.rules);
    }

    public String asHumanFriendly(DDTATable ddtaTable) {
        StringBuilder builder = new StringBuilder();
        builder.append("Overlap values: ");
        builder.append(this.overlap.asHumanFriendly(ddtaTable));
        builder.append(" for rules: ");
        builder.append(this.rules);
        return builder.toString();
    }
}

