/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.compilation;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.drl.engine.compilation.model.DrlCompilationContext;
import org.kie.drl.engine.compilation.model.DrlFileSetResource;
import org.kie.drl.engine.compilation.service.KieCompilerServiceDrl;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.KieCompilerService;

class KieCompilerServiceDrlTest {
    private static KieCompilerService kieCompilerService;
    private static DrlCompilationContext context;

    KieCompilerServiceDrlTest() {
    }

    @BeforeAll
    static void setUp() {
        kieCompilerService = new KieCompilerServiceDrl();
        context = DrlCompilationContext.buildWithParentClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    @Test
    void canManageResource() throws IOException {
        Set files = Files.list(Paths.get("src/test/resources", new String[0])).map(Path::toFile).filter(File::isFile).collect(Collectors.toSet());
        DrlFileSetResource toProcess = new DrlFileSetResource(files, "BasePath");
        Assertions.assertThat((boolean)kieCompilerService.canManageResource((EfestoResource)toProcess)).isTrue();
        EfestoResource toProcess2 = () -> "EfestoRedirectOutput";
        Assertions.assertThat((boolean)kieCompilerService.canManageResource(toProcess2)).isFalse();
    }

    @Test
    void processResource() throws IOException {
        Set files = Files.walk(Paths.get("src/test/resources", new String[0]), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).collect(Collectors.toSet());
        DrlFileSetResource toProcess = new DrlFileSetResource(files, "BasePath");
        List retrieved = kieCompilerService.processResource((EfestoResource)toProcess, (EfestoCompilationContext)context);
        ((ListAssert)Assertions.assertThat((List)retrieved).isNotNull()).hasSize(1);
    }
}

