/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.testingmodule.runtime;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.KieSession;
import org.kie.drl.engine.compilation.model.DrlFileSetResource;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoInputDrlKieSessionLocal;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoOutputDrlKieSessionLocal;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.CompilationManager;
import org.kie.efesto.compilationmanager.core.service.CompilationManagerImpl;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoOutput;
import org.kie.efesto.runtimemanager.api.service.RuntimeManager;
import org.kie.efesto.runtimemanager.core.service.RuntimeManagerImpl;
import org.kie.memorycompiler.KieMemoryCompiler;

class RuntimeDrlTest {
    private static RuntimeManager runtimeManager;
    private static CompilationManager compilationManager;
    private static KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader;
    private static final String basePath = "TestingRule";

    RuntimeDrlTest() {
    }

    @BeforeAll
    static void setUp() {
        runtimeManager = new RuntimeManagerImpl();
        compilationManager = new CompilationManagerImpl();
        memoryCompilerClassLoader = new KieMemoryCompiler.MemoryCompilerClassLoader(Thread.currentThread().getContextClassLoader());
    }

    @Test
    void evaluateWithKieSessionLocalStaticCompilation() {
        EfestoInputDrlKieSessionLocal toEvaluate = new EfestoInputDrlKieSessionLocal(new FRI(basePath, "drl"), "");
        Collection darOutput = runtimeManager.evaluateInput(memoryCompilerClassLoader, new EfestoInput[]{toEvaluate});
        ((IterableAssert)Assertions.assertThat((Iterable)darOutput).isNotNull()).hasSize(1);
        EfestoOutput retrievedRaw = (EfestoOutput)darOutput.iterator().next();
        Assertions.assertThat((Object)retrievedRaw).isInstanceOf(EfestoOutputDrlKieSessionLocal.class);
        EfestoOutputDrlKieSessionLocal retrieved = (EfestoOutputDrlKieSessionLocal)retrievedRaw;
        ((ObjectAssert)Assertions.assertThat((Object)((KieSession)retrieved.getOutputData())).isNotNull()).isInstanceOf(KieSession.class);
    }

    @Test
    void evaluateWithKieSessionLocalCompilationOnTheFly() throws IOException {
        String onTheFlyPath = "OnTheFlyPath";
        EfestoInputDrlKieSessionLocal toEvaluate = new EfestoInputDrlKieSessionLocal(new FRI(onTheFlyPath, "drl"), "");
        Collection darOutput = runtimeManager.evaluateInput(memoryCompilerClassLoader, new EfestoInput[]{toEvaluate});
        ((IterableAssert)Assertions.assertThat((Iterable)darOutput).isNotNull()).isEmpty();
        Set files = Files.walk(Paths.get("src/test/resources", new String[0]), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).collect(Collectors.toSet());
        DrlFileSetResource toProcess = new DrlFileSetResource(files, onTheFlyPath);
        compilationManager.processResource(memoryCompilerClassLoader, new EfestoResource[]{toProcess});
        darOutput = runtimeManager.evaluateInput(memoryCompilerClassLoader, new EfestoInput[]{toEvaluate});
        ((IterableAssert)Assertions.assertThat((Iterable)darOutput).isNotNull()).hasSize(1);
        EfestoOutput retrievedRaw = (EfestoOutput)darOutput.iterator().next();
        Assertions.assertThat((Object)retrievedRaw).isInstanceOf(EfestoOutputDrlKieSessionLocal.class);
        EfestoOutputDrlKieSessionLocal retrieved = (EfestoOutputDrlKieSessionLocal)retrievedRaw;
        ((ObjectAssert)Assertions.assertThat((Object)((KieSession)retrieved.getOutputData())).isNotNull()).isInstanceOf(KieSession.class);
    }
}

