/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.drools.client.docks;

import java.util.HashSet;
import java.util.Set;
import org.guvnor.common.services.shared.security.KieWorkbenchACL;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.client.context.DataModelerWorkbenchContext;
import org.kie.workbench.drools.client.docks.AuthoringWorkbenchDocks;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDockReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthoringWorkbenchDocksTest {
    @Mock
    private UberfireDocks uberfireDocks;
    @Mock
    private DataModelerWorkbenchContext dataModelerWBContext;
    @Mock
    private KieWorkbenchACL kieACL;
    @Mock
    private SessionInfo sessionInfo;
    @InjectMocks
    private AuthoringWorkbenchDocks authoringDocks;
    @Mock
    private PlaceRequest placeRequest;
    @Mock
    User user;
    UberfireDock plannerDock;
    private static final String PLANNER_ROLE = "plannermgmt";
    private Set<String> featureRoles = new HashSet<String>();

    @Before
    public void initTest() {
        MockitoAnnotations.initMocks((Object)this);
        this.authoringDocks.setup("authoring", this.placeRequest);
        this.featureRoles.add(PLANNER_ROLE);
        this.plannerDock = new UberfireDock(UberfireDockPosition.EAST, "CALCULATOR", (PlaceRequest)new DefaultPlaceRequest("PlannerDomainScreen"), "authoring").withSize(450.0).withLabel("OptaPlanner");
    }

    @Test
    public void plannerRoleGrantedTest() {
        HashSet<1> userRoles = new HashSet<1>();
        userRoles.add(new Role(){

            public String getName() {
                return AuthoringWorkbenchDocksTest.PLANNER_ROLE;
            }
        });
        Mockito.when((Object)this.kieACL.getGrantedRoles("wb_optaplanner_domain")).thenReturn(this.featureRoles);
        Mockito.when((Object)this.sessionInfo.getId()).thenReturn((Object)"logged_user");
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getRoles()).thenReturn(userRoles);
        UberfireDockReadyEvent event = new UberfireDockReadyEvent("authoring");
        this.authoringDocks.perspectiveChangeEvent(event);
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.times((int)1))).add(new UberfireDock[]{this.plannerDock});
    }

    @Test
    public void plannerRoleNotGrantedNeverVisitedTest() {
        this.testPlannerNotGranted(false);
    }

    @Test
    public void plannerRoleNotGrantedVisitedTest() {
        this.testPlannerNotGranted(true);
    }

    private void testPlannerNotGranted(boolean visited) {
        if (visited) {
            this.plannerRoleGrantedTest();
        }
        HashSet userRoles = new HashSet();
        Mockito.when((Object)this.kieACL.getGrantedRoles("wb_optaplanner_domain")).thenReturn(this.featureRoles);
        Mockito.when((Object)this.sessionInfo.getId()).thenReturn((Object)"logged_user");
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getRoles()).thenReturn(userRoles);
        UberfireDockReadyEvent event = new UberfireDockReadyEvent("authoring");
        this.authoringDocks.perspectiveChangeEvent(event);
        if (visited) {
            ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.times((int)1))).remove(new UberfireDock[]{this.plannerDock});
        }
    }
}

