/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.drools.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.social.hp.config.SocialConfigurationService;
import org.kie.workbench.common.services.shared.service.PlaceManagerActivityService;
import org.kie.workbench.common.workbench.client.authz.PermissionTreeSetup;
import org.kie.workbench.common.workbench.client.menu.DefaultWorkbenchFeaturesMenusHelper;
import org.kie.workbench.drools.client.KieDroolsWorkbenchEntryPoint;
import org.kie.workbench.drools.client.home.HomeProducer;
import org.kie.workbench.drools.client.resources.i18n.AppConstants;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.ConstantsAnswerMock;
import org.uberfire.mocks.IocTestingUtils;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class KieDroolsWorkbenchEntryPointTest {
    @Mock
    private AppConfigService appConfigService;
    private CallerMock<AppConfigService> appConfigServiceCallerMock;
    @Mock
    private PlaceManagerActivityService pmas;
    private CallerMock<PlaceManagerActivityService> pmasCallerMock;
    @Mock
    private ActivityBeansCache activityBeansCache;
    @Mock
    private HomeProducer homeProducer;
    @Mock
    private SocialConfigurationService socialConfigurationService;
    private CallerMock<SocialConfigurationService> socialConfigurationServiceCallerMock;
    @Mock
    private DefaultWorkbenchFeaturesMenusHelper menusHelper;
    @Mock
    protected ClientUserSystemManager userSystemManager;
    @Mock
    protected WorkbenchMenuBarPresenter menuBar;
    @Mock
    protected SyncBeanManager iocManager;
    @Mock
    protected Workbench workbench;
    @Mock
    protected PermissionTreeSetup permissionTreeSetup;
    private KieDroolsWorkbenchEntryPoint kieDroolsWorkbenchEntryPoint;

    @Before
    public void setup() {
        ((PlaceManagerActivityService)Mockito.doNothing().when((Object)this.pmas)).initActivities(Mockito.anyList());
        ((SocialConfigurationService)Mockito.doReturn((Object)Boolean.TRUE).when((Object)this.socialConfigurationService)).isSocialEnable();
        ((ClientUserSystemManager)Mockito.doAnswer(invocationOnMock -> {
            ((Command)invocationOnMock.getArguments()[0]).execute();
            return null;
        }).when((Object)this.userSystemManager)).waitForInitialization((Command)Mockito.any(Command.class));
        this.appConfigServiceCallerMock = new CallerMock((Object)this.appConfigService);
        this.socialConfigurationServiceCallerMock = new CallerMock((Object)this.socialConfigurationService);
        this.pmasCallerMock = new CallerMock((Object)this.pmas);
        this.kieDroolsWorkbenchEntryPoint = (KieDroolsWorkbenchEntryPoint)Mockito.spy((Object)new KieDroolsWorkbenchEntryPoint(this.appConfigServiceCallerMock, this.pmasCallerMock, this.activityBeansCache, this.homeProducer, this.socialConfigurationServiceCallerMock, this.menusHelper, this.userSystemManager, this.menuBar, this.iocManager, this.workbench, this.permissionTreeSetup));
        this.mockMenuHelper();
        this.mockConstants();
        IocTestingUtils.mockIocManager((SyncBeanManager)this.iocManager);
        ((KieDroolsWorkbenchEntryPoint)Mockito.doNothing().when((Object)this.kieDroolsWorkbenchEntryPoint)).hideLoadingPopup();
    }

    @Test
    public void initTest() {
        this.kieDroolsWorkbenchEntryPoint.init();
        ((Workbench)Mockito.verify((Object)this.workbench)).addStartupBlocker(KieDroolsWorkbenchEntryPoint.class);
        ((HomeProducer)Mockito.verify((Object)this.homeProducer)).init();
    }

    @Test
    public void setupMenuTest() {
        this.kieDroolsWorkbenchEntryPoint.setupMenu();
        ArgumentCaptor menusCaptor = ArgumentCaptor.forClass(Menus.class);
        ((WorkbenchMenuBarPresenter)Mockito.verify((Object)this.menuBar)).addMenus((Menus)menusCaptor.capture());
        Menus menus = (Menus)menusCaptor.getValue();
        Assert.assertEquals((long)6L, (long)menus.getItems().size());
        Assert.assertEquals((Object)this.kieDroolsWorkbenchEntryPoint.constants.home(), (Object)((MenuItem)menus.getItems().get(0)).getCaption());
        Assert.assertEquals((Object)this.kieDroolsWorkbenchEntryPoint.constants.authoring(), (Object)((MenuItem)menus.getItems().get(1)).getCaption());
        Assert.assertEquals((Object)this.kieDroolsWorkbenchEntryPoint.constants.deploy(), (Object)((MenuItem)menus.getItems().get(2)).getCaption());
        Assert.assertEquals((Object)this.kieDroolsWorkbenchEntryPoint.constants.tasks(), (Object)((MenuItem)menus.getItems().get(3)).getCaption());
        Assert.assertEquals((Object)this.kieDroolsWorkbenchEntryPoint.constants.extensions(), (Object)((MenuItem)menus.getItems().get(4)).getCaption());
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addRolesMenuItems();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addWorkbenchViewModeSwitcherMenuItem();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addWorkbenchConfigurationMenuItem();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addUtilitiesMenuItems();
        ((Workbench)Mockito.verify((Object)this.workbench)).removeStartupBlocker(KieDroolsWorkbenchEntryPoint.class);
    }

    @Test
    public void getDeploymentViewsTest() {
        List deploymentMenuItems = this.kieDroolsWorkbenchEntryPoint.getDeploymentViews();
        Assert.assertEquals((long)1L, (long)deploymentMenuItems.size());
        Assert.assertEquals((Object)this.kieDroolsWorkbenchEntryPoint.constants.ExecutionServers(), (Object)((MenuItem)deploymentMenuItems.get(0)).getCaption());
    }

    private void mockMenuHelper() {
        ArrayList<Object> menuItems = new ArrayList<Object>();
        menuItems.add(Mockito.mock(MenuItem.class));
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doReturn(menuItems).when((Object)this.menusHelper)).getHomeViews(Mockito.anyBoolean());
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doReturn(menuItems).when((Object)this.menusHelper)).getAuthoringViews();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doReturn(menuItems).when((Object)this.menusHelper)).getExtensionsViews();
    }

    private void mockConstants() {
        this.kieDroolsWorkbenchEntryPoint.constants = (AppConstants)Mockito.mock(AppConstants.class, (Answer)new ConstantsAnswerMock());
    }
}

