/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.drools.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.cms.screen.explorer.ContentExplorerScreen;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.impl.NavigationManagerImpl;
import org.dashbuilder.client.navigation.widget.NavTreeEditor;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.service.NavigationServices;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.workbench.client.admin.DefaultAdminPageHelper;
import org.kie.workbench.common.workbench.client.authz.PermissionTreeSetup;
import org.kie.workbench.common.workbench.client.menu.DefaultWorkbenchFeaturesMenusHelper;
import org.kie.workbench.drools.client.KieDroolsWorkbenchEntryPoint;
import org.kie.workbench.drools.client.navigation.NavTreeDefinitions;
import org.kie.workbench.drools.client.resources.i18n.NavigationConstants;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class KieDroolsWorkbenchEntryPointTest {
    @Mock
    private AppConfigService appConfigService;
    @Mock
    private ActivityBeansCache activityBeansCache;
    @Mock
    private DefaultWorkbenchFeaturesMenusHelper menusHelper;
    @Mock
    protected ClientUserSystemManager userSystemManager;
    @Mock
    protected WorkbenchMegaMenuPresenter menuBar;
    @Mock
    protected Workbench workbench;
    @Mock
    protected PermissionTreeSetup permissionTreeSetup;
    @Mock
    private DefaultAdminPageHelper adminPageHelper;
    private NavTreeDefinitions navTreeDefinitions;
    private NavigationManager navigationManager;
    @Mock
    protected ContentExplorerScreen contentExplorerScreen;
    @Mock
    protected NavigationConstants navigationConstants;
    @Mock
    protected NavigationServices navigationServices;
    @Mock
    protected NavTreeEditor navTreeEditor;
    private KieDroolsWorkbenchEntryPoint kieWorkbenchEntryPoint;

    @Before
    public void setup() {
        this.navTreeDefinitions = new NavTreeDefinitions();
        this.navigationManager = new NavigationManagerImpl((Caller)new CallerMock((Object)this.navigationServices), null, null, null);
        ((ClientUserSystemManager)Mockito.doAnswer(invocationOnMock -> {
            ((Command)invocationOnMock.getArguments()[0]).execute();
            return null;
        }).when((Object)this.userSystemManager)).waitForInitialization((Command)Mockito.any(Command.class));
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doReturn((Object)Mockito.mock(MenuFactory.TopLevelMenusBuilder.class)).when((Object)this.menusHelper)).buildMenusFromNavTree((NavTree)Mockito.any());
        CallerMock appConfigServiceCallerMock = new CallerMock((Object)this.appConfigService);
        this.kieWorkbenchEntryPoint = (KieDroolsWorkbenchEntryPoint)Mockito.spy((Object)new KieDroolsWorkbenchEntryPoint((Caller)appConfigServiceCallerMock, this.activityBeansCache, this.menusHelper, this.userSystemManager, this.menuBar, this.workbench, this.permissionTreeSetup, this.adminPageHelper, this.navTreeDefinitions, this.navigationManager, this.contentExplorerScreen));
        ((KieDroolsWorkbenchEntryPoint)Mockito.doNothing().when((Object)this.kieWorkbenchEntryPoint)).hideLoadingPopup();
        Mockito.when((Object)this.contentExplorerScreen.getNavTreeEditor()).thenReturn((Object)this.navTreeEditor);
    }

    @Test
    public void initTest() {
        this.kieWorkbenchEntryPoint.init();
        ((Workbench)Mockito.verify((Object)this.workbench)).addStartupBlocker(KieDroolsWorkbenchEntryPoint.class);
        ((PermissionTreeSetup)Mockito.verify((Object)this.permissionTreeSetup)).configureTree();
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setMaxLevels("wb_group", 2);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setNewDividerEnabled(false);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setNewPerspectiveEnabled("wb_group", false);
    }

    @Test
    public void setupMenuTest() {
        this.kieWorkbenchEntryPoint.setupMenu();
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.menuBar)).addMenus((Menus)Mockito.any());
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addUtilitiesMenuItems();
        ((Workbench)Mockito.verify((Object)this.workbench)).removeStartupBlocker(KieDroolsWorkbenchEntryPoint.class);
    }

    @Test
    public void defaultNavTreeTest() {
        this.kieWorkbenchEntryPoint.setupMenu();
        NavTree navTree = this.navigationManager.getNavTree();
        NavGroup workbench = (NavGroup)navTree.getItemById("wb_group");
        NavGroup design = (NavGroup)navTree.getItemById("wb_group_design");
        NavItem projects = navTree.getItemById("wb_entry_projects");
        NavItem dashboard = navTree.getItemById("wb_entry_dashboards");
        NavGroup devops = (NavGroup)navTree.getItemById("wb_group_devops");
        NavItem execServers = navTree.getItemById("wb_entry_execution_servers");
        Assert.assertNotNull((Object)workbench);
        Assert.assertNotNull((Object)design);
        Assert.assertNotNull((Object)devops);
        Assert.assertEquals((Object)design.getParent(), (Object)workbench);
        Assert.assertEquals((Object)devops.getParent(), (Object)workbench);
        Assert.assertNotNull((Object)projects);
        Assert.assertNotNull((Object)dashboard);
        Assert.assertEquals((Object)projects.getParent(), (Object)design);
        Assert.assertEquals((Object)dashboard.getParent(), (Object)design);
        Assert.assertNotNull((Object)execServers);
        Assert.assertEquals((Object)execServers.getParent(), (Object)devops);
    }
}

