/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.drools.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.cms.screen.explorer.NavigationExplorerScreen;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.NavTreeLoadedEvent;
import org.dashbuilder.client.navigation.impl.NavigationManagerImpl;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditor;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditorView;
import org.dashbuilder.client.navigation.widget.editor.TargetPerspectiveEditor;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.service.NavigationServices;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.workbench.client.admin.DefaultAdminPageHelper;
import org.kie.workbench.common.workbench.client.authz.PermissionTreeSetup;
import org.kie.workbench.common.workbench.client.menu.DefaultWorkbenchFeaturesMenusHelper;
import org.kie.workbench.drools.client.KieDroolsWorkbenchEntryPoint;
import org.kie.workbench.drools.client.navigation.NavTreeDefinitions;
import org.kie.workbench.drools.client.resources.i18n.NavigationConstants;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class KieDroolsWorkbenchEntryPointTest {
    @Mock
    private AppConfigService appConfigService;
    @Mock
    private ActivityBeansCache activityBeansCache;
    @Mock
    private DefaultWorkbenchFeaturesMenusHelper menusHelper;
    @Mock
    protected ClientUserSystemManager userSystemManager;
    @Mock
    protected WorkbenchMegaMenuPresenter menuBar;
    @Mock
    protected Workbench workbench;
    @Mock
    protected PermissionTreeSetup permissionTreeSetup;
    @Mock
    private PerspectiveTreeProvider perspectiveTreeProvider;
    @Mock
    private SyncBeanManager syncBeanManager;
    @Mock
    private DefaultAdminPageHelper adminPageHelper;
    private NavTreeDefinitions navTreeDefinitions;
    private NavigationManager navigationManager;
    @Mock
    protected NavigationExplorerScreen navigationExplorerScreen;
    @Mock
    protected NavigationConstants navigationConstants;
    @Mock
    protected NavigationServices navigationServices;
    @Mock
    protected NavTreeEditor navTreeEditor;
    @Mock
    protected TargetPerspectiveEditor targetPerspectiveEditor;
    @Mock
    protected EventSourceMock<NavTreeLoadedEvent> navTreeLoadedEvent;
    private KieDroolsWorkbenchEntryPoint kieWorkbenchEntryPoint;

    @Before
    public void setup() {
        this.navTreeDefinitions = new NavTreeDefinitions();
        this.navigationManager = new NavigationManagerImpl((Caller)new CallerMock((Object)this.navigationServices), null, this.navTreeLoadedEvent, null, null);
        ((ClientUserSystemManager)Mockito.doAnswer(invocationOnMock -> {
            ((Command)invocationOnMock.getArguments()[0]).execute();
            return null;
        }).when((Object)this.userSystemManager)).waitForInitialization((Command)Mockito.any(Command.class));
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doReturn((Object)Mockito.mock(MenuFactory.TopLevelMenusBuilder.class)).when((Object)this.menusHelper)).buildMenusFromNavTree((NavTree)Mockito.any());
        CallerMock appConfigServiceCallerMock = new CallerMock((Object)this.appConfigService);
        this.kieWorkbenchEntryPoint = (KieDroolsWorkbenchEntryPoint)Mockito.spy((Object)new KieDroolsWorkbenchEntryPoint((Caller)appConfigServiceCallerMock, this.activityBeansCache, this.menusHelper, this.userSystemManager, this.menuBar, this.workbench, this.permissionTreeSetup, this.perspectiveTreeProvider, this.adminPageHelper, this.navTreeDefinitions, this.navigationManager, this.navigationExplorerScreen));
        ((KieDroolsWorkbenchEntryPoint)Mockito.doNothing().when((Object)this.kieWorkbenchEntryPoint)).hideLoadingPopup();
        this.navTreeEditor = (NavTreeEditor)Mockito.spy((Object)new NavTreeEditor((NavTreeEditorView)Mockito.mock(NavTreeEditorView.class), null, this.syncBeanManager, null, this.perspectiveTreeProvider, this.targetPerspectiveEditor, null, null, null, null));
        Mockito.when((Object)this.navigationExplorerScreen.getNavTreeEditor()).thenReturn((Object)this.navTreeEditor);
    }

    @Test
    public void initTest() {
        this.kieWorkbenchEntryPoint.init();
        ((Workbench)Mockito.verify((Object)this.workbench)).addStartupBlocker(KieDroolsWorkbenchEntryPoint.class);
        ((PermissionTreeSetup)Mockito.verify((Object)this.permissionTreeSetup)).configureTree();
        ((PerspectiveTreeProvider)Mockito.verify((Object)this.perspectiveTreeProvider)).excludePerspectiveId("ContentManagerPerspective");
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setMaxLevels("wb_group", 2);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setNewDividerEnabled("wb_group", false);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setNewPerspectiveEnabled("wb_group", false);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setOnlyRuntimePerspectives("wb_group", false);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setPerspectiveContextEnabled("wb_group", false);
    }

    @Test
    public void setupMenuTest() {
        this.kieWorkbenchEntryPoint.setupMenu();
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.menuBar)).addMenus((Menus)Mockito.any());
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addUtilitiesMenuItems();
        ((Workbench)Mockito.verify((Object)this.workbench)).removeStartupBlocker(KieDroolsWorkbenchEntryPoint.class);
    }

    @Test
    public void defaultNavTreeTest() {
        this.kieWorkbenchEntryPoint.setupMenu();
        NavTree navTree = this.navigationManager.getNavTree();
        NavGroup workbench = (NavGroup)navTree.getItemById("wb_group");
        NavGroup design = (NavGroup)navTree.getItemById("wb_group_design");
        NavItem projects = navTree.getItemById("wb_entry_projects");
        NavGroup deploy = (NavGroup)navTree.getItemById("wb_group_deploy");
        NavItem execServers = navTree.getItemById("wb_entry_execution_servers");
        Assert.assertNotNull((Object)workbench);
        Assert.assertNotNull((Object)design);
        Assert.assertNotNull((Object)deploy);
        Assert.assertEquals((Object)design.getParent(), (Object)workbench);
        Assert.assertEquals((Object)deploy.getParent(), (Object)workbench);
        Assert.assertNotNull((Object)projects);
        Assert.assertEquals((Object)projects.getParent(), (Object)design);
        Assert.assertNotNull((Object)execServers);
        Assert.assertEquals((Object)execServers.getParent(), (Object)deploy);
    }
}

