/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import java.util.List;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.def.DataSetPreprocessor;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jbpm.kie.services.impl.security.DeploymentRolesManager;
import org.kie.internal.identity.IdentityProvider;

public class DeploymentIdsPreprocessor
implements DataSetPreprocessor {
    private DeploymentRolesManager deploymentRolesManager;
    private IdentityProvider identityProvider;

    public DeploymentIdsPreprocessor(DeploymentRolesManager deploymentRolesManager, IdentityProvider identityProvider) {
        this.deploymentRolesManager = deploymentRolesManager;
        this.identityProvider = identityProvider;
    }

    public void preprocess(DataSetLookup lookup) {
        if (this.identityProvider == null) {
            return;
        }
        List<String> deploymentIds = this.deploymentRolesManager.getDeploymentsForUser(this.identityProvider);
        if (lookup.getFirstFilterOp() != null) {
            lookup.getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.in((String)"EXTERNALID", deploymentIds)});
        } else {
            DataSetFilter filter = new DataSetFilter();
            filter.addFilterColumn(new ColumnFilter[]{FilterFactory.in((String)"EXTERNALID", deploymentIds)});
            lookup.addOperation(new DataSetOp[]{filter});
        }
    }
}

