/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands;

import org.jbpm.executor.commands.PrintOutCommand;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedPrintOutCommand
extends PrintOutCommand {
    private static final Logger logger = LoggerFactory.getLogger(DelayedPrintOutCommand.class);

    @Override
    public ExecutionResults execute(CommandContext ctx) {
        Long delay = (Long)ctx.getData("delay");
        if (delay == null) {
            delay = 10000L;
        }
        logger.info("Delaying execution of command for {}", (Object)delay);
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return super.execute(ctx);
    }
}

