/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.Arrays;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.model.InternalPeopleAssignments;

public class AddPeopleAssignmentsCommand
extends UserGroupCallbackTaskCommand<Void> {
    private static final long serialVersionUID = -1856489382099976731L;
    private int type;
    private OrganizationalEntity[] entities;
    private boolean removeExisting;

    public AddPeopleAssignmentsCommand(String userId, long taskId, int type, OrganizationalEntity[] entities, boolean removeExisting) {
        this.setUserId(userId);
        this.setTaskId(taskId);
        this.type = type;
        this.entities = entities;
        this.removeExisting = removeExisting;
    }

    public Void execute(Context cntxt) {
        org.jbpm.services.task.commands.TaskContext context = (org.jbpm.services.task.commands.TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId.longValue());
        if (!this.isBusinessAdmin(this.userId, task.getPeopleAssignments().getBusinessAdministrators(), (TaskContext)context)) {
            throw new PermissionDeniedException("User " + this.userId + " is not business admin of task " + this.taskId);
        }
        switch (this.type) {
            case 0: {
                if (this.removeExisting) {
                    task.getPeopleAssignments().getPotentialOwners().clear();
                }
                task.getPeopleAssignments().getPotentialOwners().addAll(Arrays.asList(this.entities));
                break;
            }
            case 1: {
                if (this.removeExisting) {
                    ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners().clear();
                }
                ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners().addAll(Arrays.asList(this.entities));
                break;
            }
            case 2: {
                if (this.removeExisting) {
                    task.getPeopleAssignments().getBusinessAdministrators().clear();
                }
                task.getPeopleAssignments().getBusinessAdministrators().addAll(Arrays.asList(this.entities));
                break;
            }
        }
        this.doCallbackOperationForPeopleAssignments((InternalPeopleAssignments)task.getPeopleAssignments(), (TaskContext)context);
        return null;
    }
}

