/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.List;
import java.util.stream.Collectors;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.kie.services.impl.admin.ProcessNodeImpl;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.admin.ProcessNode;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.Context;
import org.kie.internal.command.ProcessInstanceIdCommand;

public class ListNodesCommand
implements ExecutableCommand<List<ProcessNode>>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = -8252686458877022330L;
    private long processInstanceId;

    public ListNodesCommand(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public List<ProcessNode> execute(Context context) {
        List<ProcessNode> nodes = null;
        KieSession kieSession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        RuleFlowProcessInstance wfp = (RuleFlowProcessInstance)kieSession.getProcessInstance(this.processInstanceId, true);
        if (wfp == null) {
            throw new ProcessInstanceNotFoundException("No process instance can be found for id " + this.processInstanceId);
        }
        String processId = wfp.getProcessId();
        nodes = wfp.getRuleFlowProcess().getNodesRecursively().stream().map(n -> new ProcessNodeImpl(n.getName(), n.getId(), n.getClass().getSimpleName(), processId)).collect(Collectors.toList());
        return nodes;
    }

    public void setProcessInstanceId(Long procInstId) {
        this.processInstanceId = procInstId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }
}

