/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.jbpm.services.task.impl.model.xml.AbstractJaxbTaskObject;
import org.jbpm.services.task.impl.model.xml.InternalJaxbWrapper;
import org.jbpm.services.task.impl.model.xml.JaxbAttachment;
import org.jbpm.services.task.impl.model.xml.JaxbComment;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.model.AccessType;
import org.kie.internal.task.api.model.InternalTaskData;

@XmlType(name="task-data")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={JaxbComment.class, JaxbAttachment.class})
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class JaxbTaskData
extends AbstractJaxbTaskObject<TaskData>
implements TaskData {
    @XmlElement
    private Status status;
    @XmlElement
    private Status previousStatus;
    @XmlElement(name="actual-owner")
    private String actualOwner;
    @XmlElement(name="created-by")
    private String createdBy;
    @XmlElement(name="created-on")
    @XmlSchemaType(name="dateTime")
    private Date createdOn;
    @XmlElement(name="activation-time")
    @XmlSchemaType(name="dateTime")
    private Date activationTime;
    @XmlElement(name="expiration-time")
    @XmlSchemaType(name="dateTime")
    private Date expirationTime;
    @XmlElement
    @XmlSchemaType(name="boolean")
    private Boolean skipable;
    @XmlElement(name="work-item-id")
    @XmlSchemaType(name="long")
    private Long workItemId;
    @XmlElement(name="process-instance-id")
    @XmlSchemaType(name="long")
    private Long processInstanceId;
    @XmlElement(name="document-type")
    @XmlSchemaType(name="string")
    private String documentType;
    @XmlElement(name="document-access-type")
    private AccessType documentAccessType;
    @XmlElement(name="document-content-id")
    @XmlSchemaType(name="long")
    private Long documentContentId;
    @XmlElement(name="output-type")
    @XmlSchemaType(name="string")
    private String outputType;
    @XmlElement(name="output-access-type")
    private AccessType outputAccessType;
    @XmlElement(name="output-content-id")
    @XmlSchemaType(name="long")
    private Long outputContentId;
    @XmlElement(name="fault-name")
    @XmlSchemaType(name="string")
    private String faultName;
    @XmlElement(name="fault-access-type")
    private AccessType faultAccessType;
    @XmlElement(name="fault-type")
    @XmlSchemaType(name="string")
    private String faultType;
    @XmlElement(name="fault-content-id")
    @XmlSchemaType(name="long")
    private Long faultContentId;
    @XmlElement(name="parent-id")
    @XmlSchemaType(name="long")
    private Long parentId;
    @XmlElement(name="process-id")
    @XmlSchemaType(name="string")
    private String processId;
    @XmlElement(name="process-session-id")
    @XmlSchemaType(name="long")
    private Long processSessionId;
    @XmlElement
    private List<JaxbComment> comments;
    @XmlElement
    private List<JaxbAttachment> attachments;
    @XmlElement(name="deployment-id")
    @XmlSchemaType(name="string")
    private String deploymentId;

    public JaxbTaskData() {
        super(TaskData.class);
    }

    public JaxbTaskData(TaskData taskData) {
        super(TaskData.class);
        User createdByUser;
        this.status = taskData.getStatus();
        this.previousStatus = taskData.getPreviousStatus();
        User actualOwnerUser = taskData.getActualOwner();
        if (actualOwnerUser != null) {
            this.actualOwner = actualOwnerUser.getId();
        }
        if ((createdByUser = taskData.getCreatedBy()) != null) {
            this.createdBy = createdByUser.getId();
        }
        this.createdOn = taskData.getCreatedOn();
        this.activationTime = taskData.getActivationTime();
        this.expirationTime = taskData.getExpirationTime();
        this.skipable = taskData.isSkipable();
        this.workItemId = taskData.getWorkItemId();
        this.processInstanceId = taskData.getProcessInstanceId();
        this.documentType = taskData.getDocumentType();
        if (taskData instanceof JaxbTaskData) {
            JaxbTaskData jaxbTaskData = (JaxbTaskData)taskData;
            this.documentAccessType = jaxbTaskData.getDocumentAccessType();
            this.outputAccessType = jaxbTaskData.getOutputAccessType();
            this.faultAccessType = jaxbTaskData.getFaultAccessType();
        } else if (taskData instanceof InternalTaskData) {
            InternalTaskData internalTaskData = (InternalTaskData)taskData;
            this.documentAccessType = internalTaskData.getDocumentAccessType();
            this.outputAccessType = internalTaskData.getOutputAccessType();
            this.faultAccessType = internalTaskData.getFaultAccessType();
        }
        this.documentContentId = taskData.getDocumentContentId();
        this.outputType = taskData.getOutputType();
        this.outputContentId = taskData.getOutputContentId();
        this.faultName = taskData.getFaultName();
        this.faultType = taskData.getFaultType();
        this.faultContentId = taskData.getFaultContentId();
        this.parentId = taskData.getParentId();
        this.processId = taskData.getProcessId();
        this.processSessionId = taskData.getProcessSessionId();
        if (taskData.getComments() != null) {
            ArrayList<JaxbComment> commentList = new ArrayList<JaxbComment>();
            for (Object comment : taskData.getComments()) {
                commentList.add(new JaxbComment((Comment)comment));
            }
            this.comments = commentList;
        }
        ArrayList<JaxbAttachment> attachList = new ArrayList<JaxbAttachment>();
        for (Object attach : taskData.getAttachments()) {
            attachList.add(new JaxbAttachment((Attachment)attach));
        }
        this.attachments = attachList;
        this.deploymentId = taskData.getDeploymentId();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getPreviousStatus() {
        return this.previousStatus;
    }

    public void setPreviousStatus(Status previousStatus) {
        this.previousStatus = previousStatus;
    }

    public User getActualOwner() {
        return new InternalJaxbWrapper.GetterUser(this.actualOwner);
    }

    public String getActualOwnerId() {
        return this.actualOwner;
    }

    public void setActualOwnerId(String actualOwnerId) {
        this.actualOwner = actualOwnerId;
    }

    public User getCreatedBy() {
        return new InternalJaxbWrapper.GetterUser(this.createdBy);
    }

    public String getCreatedById() {
        return this.createdBy;
    }

    public void setCreatedById(String createdById) {
        this.createdBy = createdById;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public boolean isSkipable() {
        return this.skipable;
    }

    public void setSkipable(Boolean skipable) {
        this.skipable = skipable;
    }

    public long getWorkItemId() {
        return JaxbTaskData.whenNull(this.workItemId, -1L);
    }

    public void setWorkItemId(Long workItemId) {
        this.workItemId = workItemId;
    }

    public long getProcessInstanceId() {
        return JaxbTaskData.whenNull(this.processInstanceId, -1L);
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public AccessType getDocumentAccessType() {
        return this.documentAccessType;
    }

    public void setDocumentAccessType(AccessType documentAccessType) {
        this.documentAccessType = documentAccessType;
    }

    public long getDocumentContentId() {
        return JaxbTaskData.whenNull(this.documentContentId, -1L);
    }

    public void setDocumentContentId(Long documentContentId) {
        this.documentContentId = documentContentId;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public AccessType getOutputAccessType() {
        return this.outputAccessType;
    }

    public void setOutputAccessType(AccessType outputAccessType) {
        this.outputAccessType = outputAccessType;
    }

    public Long getOutputContentId() {
        return JaxbTaskData.whenNull(this.outputContentId, -1L);
    }

    public void setOutputContentId(Long outputContentId) {
        this.outputContentId = outputContentId;
    }

    public String getFaultName() {
        return this.faultName;
    }

    public void setFaultName(String faultName) {
        this.faultName = faultName;
    }

    public AccessType getFaultAccessType() {
        return this.faultAccessType;
    }

    public void setFaultAccessType(AccessType faultAccessType) {
        this.faultAccessType = faultAccessType;
    }

    public String getFaultType() {
        return this.faultType;
    }

    public void setFaultType(String faultType) {
        this.faultType = faultType;
    }

    public long getFaultContentId() {
        return JaxbTaskData.whenNull(this.faultContentId, -1L);
    }

    public void setFaultContentId(Long faultContentId) {
        this.faultContentId = faultContentId;
    }

    public long getParentId() {
        return JaxbTaskData.whenNull(this.parentId, -1L);
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public long getProcessSessionId() {
        return JaxbTaskData.whenNull(this.processSessionId, -1L);
    }

    public void setProcessSessionId(Long processSessionId) {
        this.processSessionId = processSessionId;
    }

    public List<Comment> getComments() {
        ArrayList<JaxbComment> commentList = new ArrayList<JaxbComment>();
        if (this.comments != null) {
            for (JaxbComment jaxbComment : this.comments) {
                commentList.add(jaxbComment);
            }
        }
        return Collections.unmodifiableList(commentList);
    }

    public void setJaxbComments(List<JaxbComment> comments) {
        this.comments = comments;
    }

    public List<Attachment> getAttachments() {
        ArrayList<JaxbAttachment> attachmentList = new ArrayList<JaxbAttachment>();
        if (this.attachments != null) {
            for (JaxbAttachment jaxbAttachment : this.attachments) {
                attachmentList.add(jaxbAttachment);
            }
        }
        return Collections.unmodifiableList(attachmentList);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public Map<String, Object> getTaskInputVariables() {
        return new HashMap<String, Object>();
    }

    public Map<String, Object> getTaskOutputVariables() {
        return new HashMap<String, Object>();
    }
}

