/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin;

import java.util.Collection;
import org.jbpm.kie.services.impl.admin.commands.CancelNodeInstanceCommand;
import org.jbpm.kie.services.impl.admin.commands.ListNodesCommand;
import org.jbpm.kie.services.impl.admin.commands.ListTimersCommand;
import org.jbpm.kie.services.impl.admin.commands.RetriggerNodeInstanceCommand;
import org.jbpm.kie.services.impl.admin.commands.TriggerNodeCommand;
import org.jbpm.process.instance.command.RelativeUpdateTimerCommand;
import org.jbpm.process.instance.command.UpdateTimerCommand;
import org.jbpm.services.api.NodeInstanceNotFoundException;
import org.jbpm.services.api.NodeNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.admin.ProcessInstanceAdminService;
import org.jbpm.services.api.admin.ProcessNode;
import org.jbpm.services.api.admin.TimerInstance;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.kie.api.command.Command;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class ProcessInstanceAdminServiceImpl
implements ProcessInstanceAdminService {
    private ProcessService processService;
    private RuntimeDataService runtimeDataService;

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public Collection<ProcessNode> getProcessNodes(long processInstanceId) throws ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        Collection nodes = (Collection)this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new ListNodesCommand(processInstanceId));
        return nodes;
    }

    public void cancelNodeInstance(long processInstanceId, long nodeInstanceId) throws NodeInstanceNotFoundException, ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new CancelNodeInstanceCommand(processInstanceId, nodeInstanceId));
    }

    public void retriggerNodeInstance(long processInstanceId, long nodeInstanceId) throws NodeInstanceNotFoundException, ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new RetriggerNodeInstanceCommand(processInstanceId, nodeInstanceId));
    }

    public void updateTimer(long processInstanceId, long timerId, long delay, long period, int repeatLimit) throws NodeInstanceNotFoundException, ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new UpdateTimerCommand(processInstanceId, timerId, delay, period, repeatLimit));
    }

    public void updateTimerRelative(long processInstanceId, long timerId, long delay, long period, int repeatLimit) throws NodeInstanceNotFoundException, ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new RelativeUpdateTimerCommand(processInstanceId, timerId, delay, period, repeatLimit));
    }

    public Collection<TimerInstance> getTimerInstances(long processInstanceId) throws ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        Collection timers = (Collection)this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new ListTimersCommand(processInstanceId));
        return timers;
    }

    public void triggerNode(long processInstanceId, long nodeId) throws NodeNotFoundException, ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (pi == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " not found");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new TriggerNodeCommand(processInstanceId, nodeId));
    }

    public Collection<NodeInstanceDesc> getActiveNodeInstances(long processInstanceId) throws ProcessInstanceNotFoundException {
        return this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext(Integer.valueOf(0), Integer.valueOf(1000)));
    }
}

