/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.time.TimerService;
import org.drools.persistence.api.OrderedTransactionSynchronization;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.drools.persistence.api.TransactionManagerHelper;
import org.drools.persistence.api.TransactionSynchronization;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.runtime.manager.api.SchedulerProvider;
import org.jbpm.runtime.manager.impl.CacheManagerImpl;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.wih.ExternalTaskEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.manager.CacheManager;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.DisposeListener;
import org.kie.internal.runtime.manager.InternalRegisterableItemsFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.SecurityManager;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.InternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuntimeManager
implements InternalRuntimeManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRuntimeManager.class);
    protected RuntimeManagerRegistry registry = RuntimeManagerRegistry.get();
    protected org.kie.api.runtime.manager.RuntimeEnvironment environment;
    protected DeploymentDescriptor deploymentDescriptor;
    protected KieContainer kieContainer;
    protected CacheManager cacheManager = new CacheManagerImpl();
    protected boolean engineInitEager = Boolean.parseBoolean(System.getProperty("org.jbpm.rm.engine.eager", "false"));
    protected String identifier;
    protected boolean closed = false;
    protected SecurityManager securityManager = null;
    protected ConcurrentMap<Long, ReentrantLock> engineLocks = new ConcurrentHashMap<Long, ReentrantLock>();

    public AbstractRuntimeManager(org.kie.api.runtime.manager.RuntimeEnvironment environment, String identifier) {
        this.environment = environment;
        this.identifier = identifier;
        if (this.registry.isRegistered(identifier)) {
            throw new IllegalStateException("RuntimeManager with id " + identifier + " is already active");
        }
        this.internalSetDeploymentDescriptor();
        this.internalSetKieContainer();
        ((InternalRegisterableItemsFactory)environment.getRegisterableItemsFactory()).setRuntimeManager((InternalRuntimeManager)this);
        String eagerInit = (String)((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().get("RuntimeEngineEagerInit");
        if (eagerInit != null) {
            this.engineInitEager = Boolean.parseBoolean(eagerInit);
        }
    }

    private void internalSetDeploymentDescriptor() {
        this.deploymentDescriptor = (DeploymentDescriptor)((SimpleRuntimeEnvironment)this.environment).getEnvironmentTemplate().get("KieDeploymentDescriptor");
        if (this.deploymentDescriptor == null) {
            this.deploymentDescriptor = new DeploymentDescriptorManager().getDefaultDescriptor();
        }
    }

    private void internalSetKieContainer() {
        this.kieContainer = (KieContainer)((SimpleRuntimeEnvironment)this.environment).getEnvironmentTemplate().get("KieContainer");
    }

    public abstract void init();

    protected void registerItems(RuntimeEngine runtime) {
        RegisterableItemsFactory factory = this.environment.getRegisterableItemsFactory();
        Map handlers = factory.getWorkItemHandlers(runtime);
        for (Map.Entry entry : handlers.entrySet()) {
            runtime.getKieSession().getWorkItemManager().registerWorkItemHandler((String)entry.getKey(), (WorkItemHandler)entry.getValue());
        }
        Map globals = factory.getGlobals(runtime);
        for (Map.Entry entry : globals.entrySet()) {
            runtime.getKieSession().setGlobal((String)entry.getKey(), entry.getValue());
        }
        List list = factory.getProcessEventListeners(runtime);
        for (Object listener : list) {
            runtime.getKieSession().addEventListener((ProcessEventListener)listener);
        }
        List list2 = factory.getAgendaEventListeners(runtime);
        for (AgendaEventListener listener : list2) {
            runtime.getKieSession().addEventListener(listener);
        }
        List wmListeners = factory.getRuleRuntimeEventListeners(runtime);
        for (RuleRuntimeEventListener listener : wmListeners) {
            runtime.getKieSession().addEventListener(listener);
        }
    }

    protected void registerDisposeCallback(RuntimeEngine runtime, TransactionSynchronization sync) {
        if (this.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
            return;
        }
        TransactionManager tm = this.getTransactionManager(runtime.getKieSession().getEnvironment());
        if (tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
            TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)tm, (OrderedTransactionSynchronization)((OrderedTransactionSynchronization)sync));
        }
    }

    protected boolean canDispose(RuntimeEngine runtime) {
        if (((RuntimeEngineImpl)runtime).isDisposed()) {
            return false;
        }
        if (((RuntimeEngineImpl)runtime).isAfterCompletion() || this.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
            return true;
        }
        try {
            TransactionManager tm = this.getTransactionManager(runtime.getKieSession().getEnvironment());
            if (tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
                return false;
            }
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
        return true;
    }

    protected void attachManager(RuntimeEngine runtime) {
        runtime.getKieSession().getEnvironment().set("RuntimeManager", (Object)this);
        runtime.getKieSession().getEnvironment().set("deploymentId", (Object)this.getIdentifier());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean removeJobs) {
        this.cacheManager.dispose();
        this.environment.close();
        this.registry.remove(this.identifier);
        TimerService timerService = TimerServiceRegistry.getInstance().remove(this.getIdentifier() + "-timerServiceId");
        if (timerService != null) {
            if (removeJobs && timerService instanceof GlobalTimerService) {
                ((GlobalTimerService)timerService).destroy();
            }
            timerService.shutdown();
            GlobalSchedulerService schedulerService = ((SchedulerProvider)this.environment).getSchedulerService();
            if (schedulerService != null) {
                schedulerService.shutdown();
            }
        }
        this.closed = true;
    }

    public RuntimeEnvironment getEnvironment() {
        return (RuntimeEnvironment)this.environment;
    }

    public void setEnvironment(org.kie.api.runtime.manager.RuntimeEnvironment environment) {
        this.environment = environment;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    protected void configureRuntimeOnTaskService(InternalTaskService internalTaskService, RuntimeEngine engine) {
        if (internalTaskService != null) {
            ExternalTaskEventListener listener = new ExternalTaskEventListener();
            if (internalTaskService instanceof EventService) {
                ((EventService)internalTaskService).registerTaskEventListener((Object)listener);
            }
            RegisterableItemsFactory factory = this.environment.getRegisterableItemsFactory();
            for (TaskLifeCycleEventListener taskListener : factory.getTaskListeners()) {
                ((EventService)internalTaskService).registerTaskEventListener((Object)taskListener);
            }
            if (engine != null && engine instanceof Disposable) {
                ((Disposable)engine).addDisposeListener(new DisposeListener(){

                    public void onDispose(RuntimeEngine runtime) {
                        if (runtime.getTaskService() instanceof EventService) {
                            ((EventService)runtime.getTaskService()).clearTaskEventListeners();
                        }
                    }
                });
            }
        }
    }

    protected void removeRuntimeFromTaskService() {
        TaskContentRegistry.get().removeMarshallerContext(this.getIdentifier());
    }

    public void softDispose(RuntimeEngine runtimeEngine) {
    }

    protected boolean canDestroy(RuntimeEngine runtime) {
        if (this.hasEnvironmentEntry("IS_JTA_TRANSACTION", false) || ((RuntimeEngineImpl)runtime).isAfterCompletion()) {
            return false;
        }
        TransactionManager tm = this.getTransactionManager(runtime.getKieSession().getEnvironment());
        return tm.getStatus() == 3 || tm.getStatus() == 4;
    }

    protected boolean hasEnvironmentEntry(String name, Object value) {
        Object envEntry = this.environment.getEnvironment().get(name);
        if (value == null) {
            return envEntry == null;
        }
        return value.equals(envEntry);
    }

    protected TransactionManager getTransactionManager(Environment env) {
        Object txm;
        if (env == null) {
            env = this.environment.getEnvironment();
        }
        if ((txm = env.get("org.kie.transaction.TransactionManager")) != null && txm instanceof TransactionManager) {
            return (TransactionManager)txm;
        }
        return TransactionManagerFactory.get().newTransactionManager(env);
    }

    protected TransactionManager getTransactionManagerInternal(Environment env) {
        try {
            return this.getTransactionManager(env);
        }
        catch (Exception e) {
            return new TransactionManager(){

                public void rollback(boolean transactionOwner) {
                }

                public void registerTransactionSynchronization(TransactionSynchronization ts) {
                }

                public void putResource(Object key, Object resource) {
                }

                public int getStatus() {
                    return 3;
                }

                public Object getResource(Object key) {
                    return null;
                }

                public void commit(boolean transactionOwner) {
                }

                public boolean begin() {
                    return false;
                }
            };
        }
    }

    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptor(DeploymentDescriptor deploymentDescriptor) {
        this.deploymentDescriptor = deploymentDescriptor;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        if (this.securityManager != null) {
            throw new IllegalStateException("Security Manager for " + this.identifier + " manager is already set");
        }
        this.securityManager = securityManager;
    }

    protected void checkPermission() {
        if (this.securityManager != null) {
            this.securityManager.checkPermission();
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        if (cacheManager != null) {
            this.cacheManager = cacheManager;
        }
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }

    public void setKieContainer(KieContainer kieContainer) {
        this.kieContainer = kieContainer;
    }

    protected boolean isUseLocking() {
        return false;
    }

    protected void createLockOnGetEngine(Context<?> context, RuntimeEngine runtime) {
        if (!this.isUseLocking()) {
            logger.debug("Locking on runtime manager disabled");
            return;
        }
        if (context instanceof ProcessInstanceIdContext) {
            Long piId = ((ProcessInstanceIdContext)context).getContextId();
            this.createLockOnGetEngine(piId, runtime);
        }
    }

    protected void createLockOnGetEngine(Long id, RuntimeEngine runtime) {
        if (!this.isUseLocking()) {
            logger.debug("Locking on runtime manager disabled");
            return;
        }
        if (id != null) {
            ReentrantLock newLock = new ReentrantLock();
            ReentrantLock lock = this.engineLocks.putIfAbsent(id, newLock);
            if (lock == null) {
                lock = newLock;
                logger.debug("New lock created as it did not exist before");
            } else {
                logger.debug("Lock exists with {} waiting threads", (Object)lock.getQueueLength());
            }
            logger.debug("Trying to get a lock {} for {} by {}", new Object[]{lock, id, runtime});
            lock.lock();
            logger.debug("Lock {} taken for {} by {} for waiting threads by {}", new Object[]{lock, id, runtime, lock.hasQueuedThreads()});
        }
    }

    protected void createLockOnNewProcessInstance(Long id, RuntimeEngine runtime) {
        if (!this.isUseLocking()) {
            logger.debug("Locking on runtime manager disabled");
            return;
        }
        ReentrantLock newLock = new ReentrantLock();
        ReentrantLock lock = this.engineLocks.putIfAbsent(id, newLock);
        if (lock == null) {
            lock = newLock;
        }
        lock.lock();
        logger.debug("[on new process instance] Lock {} created and stored in list by {}", (Object)lock, (Object)runtime);
    }

    protected void releaseAndCleanLock(RuntimeEngine runtime) {
        Long piId;
        if (!this.isUseLocking()) {
            logger.debug("Locking on runtime manager disabled");
            return;
        }
        if (((RuntimeEngineImpl)runtime).getContext() instanceof ProcessInstanceIdContext && (piId = ((ProcessInstanceIdContext)((RuntimeEngineImpl)runtime).getContext()).getContextId()) != null) {
            this.releaseAndCleanLock(piId, runtime);
        }
    }

    protected void releaseAndCleanLock(Long id, RuntimeEngine runtime) {
        ReentrantLock lock;
        if (id != null && (lock = (ReentrantLock)this.engineLocks.get(id)) != null) {
            if (!lock.hasQueuedThreads()) {
                logger.debug("Removing lock {} from list as non is waiting for it by {}", (Object)lock, (Object)runtime);
                this.engineLocks.remove(id);
            }
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
                logger.debug("{} unlocked by {}", (Object)lock, (Object)runtime);
            }
        }
    }

    protected boolean isActive() {
        return !this.hasEnvironmentEntry("Active", false);
    }

    public void activate() {
        ((SimpleRuntimeEnvironment)this.environment).addToEnvironment("Active", true);
    }

    public void deactivate() {
        ((SimpleRuntimeEnvironment)this.environment).addToEnvironment("Active", false);
    }
}

