/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.common.DisconnectedFactHandle;
import org.drools.core.util.MVELSafeHelper;
import org.kie.api.command.Setter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
public class ModifyCommand
implements GenericCommand<Object> {
    public static boolean ALLOW_MODIFY_EXPRESSIONS = true;
    private DisconnectedFactHandle handle;
    @XmlJavaTypeAdapter(value=JaxbSetterAdapter.class)
    @XmlElement
    private List<Setter> setters;

    public ModifyCommand() {
    }

    public ModifyCommand(FactHandle handle, List<Setter> setters) {
        this.handle = DisconnectedFactHandle.newFrom(handle);
        this.setters = setters;
    }

    @Override
    public Object execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        EntryPoint wmep = ksession.getEntryPoint(this.handle.getEntryPointId());
        Object object = wmep.getObject((FactHandle)this.handle);
        MVELSafeHelper.getEvaluator().eval(this.getMvelExpr(), object);
        wmep.update((FactHandle)this.handle, object);
        return object;
    }

    public FactHandle getFactHandle() {
        return this.handle;
    }

    @XmlAttribute(name="fact-handle", required=true)
    public void setFactHandleFromString(String factHandleId) {
        this.handle = new DisconnectedFactHandle(factHandleId);
    }

    public String getFactHandleFromString() {
        return this.handle.toExternalForm();
    }

    public List<Setter> getSetters() {
        if (this.setters == null) {
            this.setters = new ArrayList<Setter>();
        }
        return this.setters;
    }

    public void setSetters(List<Setter> setters) {
        this.setters = setters;
    }

    private String getMvelExpr() {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("with (this) {\n");
        int i = 0;
        for (Setter setter : this.setters) {
            if (i++ > 0) {
                sbuilder.append(",");
            }
            if (ALLOW_MODIFY_EXPRESSIONS) {
                sbuilder.append(setter.getAccessor() + " = '" + setter.getValue() + "'\n");
                continue;
            }
            sbuilder.append(setter.getAccessor() + " = '" + setter.getValue().replace("\"", "") + "'\n");
        }
        sbuilder.append("}");
        return sbuilder.toString();
    }

    public String toString() {
        return "modify() " + this.getMvelExpr();
    }

    public static class JaxbSetterAdapter
    extends XmlAdapter<SetterImpl[], List<SetterImpl>> {
        public SetterImpl[] marshal(List<SetterImpl> v) throws Exception {
            return v.toArray(new SetterImpl[v.size()]);
        }

        public List<SetterImpl> unmarshal(SetterImpl[] v) throws Exception {
            return Arrays.asList(v);
        }
    }

    @XmlRootElement(name="set")
    public static class SetterImpl
    implements Setter {
        @XmlAttribute
        private String accessor;
        @XmlAttribute
        private String value;

        public SetterImpl() {
        }

        public SetterImpl(String accessor, String value) {
            this.accessor = accessor;
            this.value = value;
        }

        public String getAccessor() {
            return this.accessor;
        }

        public String getValue() {
            return this.value;
        }
    }
}

