/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.List;
import java.util.Map;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.TaskContentService;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.InternalContent;
import org.kie.internal.task.api.model.InternalTaskData;

public class TaskContentServiceImpl
implements TaskContentService {
    private TaskPersistenceContext persistenceContext;

    public TaskContentServiceImpl() {
    }

    public TaskContentServiceImpl(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setPersistenceContext(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public long addContent(long taskId, Map<String, Object> params) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        long outputContentId = task.getTaskData().getOutputContentId();
        Content outputContent = this.persistenceContext.findContent(Long.valueOf(outputContentId));
        long contentId = -1L;
        if (outputContent == null) {
            ContentData outputContentData = ContentMarshallerHelper.marshal(params, null);
            Content content = TaskModelProvider.getFactory().newContent();
            ((InternalContent)content).setContent(outputContentData.getContent());
            this.persistenceContext.persistContent(content);
            ((InternalTaskData)task.getTaskData()).setOutput(content.getId(), outputContentData);
            contentId = content.getId();
        } else {
            ContentMarshallerContext context = this.getMarshallerContext(task);
            Object unmarshalledObject = ContentMarshallerHelper.unmarshall(outputContent.getContent(), context.getEnvironment(), context.getClassloader());
            if (unmarshalledObject != null && unmarshalledObject instanceof Map) {
                ((Map)unmarshalledObject).putAll(params);
            }
            ContentData outputContentData = ContentMarshallerHelper.marshal(unmarshalledObject, context.getEnvironment());
            ((InternalContent)outputContent).setContent(outputContentData.getContent());
            this.persistenceContext.persistContent(outputContent);
            contentId = outputContentId;
        }
        return contentId;
    }

    public long addContent(long taskId, Content content) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        this.persistenceContext.persistContent(content);
        ((InternalTaskData)task.getTaskData()).setDocumentContentId(content.getId());
        return content.getId();
    }

    public void deleteContent(long taskId, long contentId) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        ((InternalTaskData)task.getTaskData()).setDocumentContentId(-1L);
        Content content = this.persistenceContext.findContent(Long.valueOf(contentId));
        this.persistenceContext.removeContent(content);
    }

    public List<Content> getAllContentByTaskId(long taskId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Content getContentById(long contentId) {
        return this.persistenceContext.findContent(Long.valueOf(contentId));
    }

    public void addMarshallerContext(String ownerId, ContentMarshallerContext context) {
        TaskContentRegistry.get().addMarshallerContext(ownerId, context);
    }

    public void removeMarshallerContext(String ownerId) {
        TaskContentRegistry.get().removeMarshallerContext(ownerId);
    }

    public ContentMarshallerContext getMarshallerContext(Task task) {
        return TaskContentRegistry.get().getMarshallerContext(task);
    }
}

