/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.form.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlRootElement;
import org.jbpm.kie.services.impl.form.model.SettingsEntry;

@Entity
@XmlRootElement(name="settings")
public class Settings
implements Serializable {
    @Id
    @GeneratedValue
    private Long id;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<SettingsEntry> entries = new ArrayList<SettingsEntry>();
    private String userId;

    public Settings() {
    }

    public Settings(String userId) {
        this.userId = userId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<SettingsEntry> getEntries() {
        return this.entries;
    }

    public SettingsEntry getEntry(String key) {
        for (SettingsEntry entry : this.entries) {
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    public void setEntries(List<SettingsEntry> entries) {
        this.entries = entries;
    }

    public void addEntry(SettingsEntry entry) {
        this.entries.add(entry);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String toString() {
        return "Settings{id=" + this.id + ", userId=" + this.userId + ", entries=" + this.entries + '}';
    }

    public Map<String, Object> getDataMap() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("org.jbpm.form.builder.services.model.Settings.userId", this.userId);
        dataMap.put("org.jbpm.form.builder.services.model.Settings.id", this.id == null ? null : String.valueOf(this.id));
        for (SettingsEntry entry : this.entries) {
            dataMap.put(entry.getKey(), entry.getValue());
            dataMap.put(entry.getKey() + "@org.jbpm.form.builder.services.model.SettingsEntry.id", entry.getId() == null ? null : String.valueOf(entry.getId()));
        }
        return dataMap;
    }

    public void setDataMap(Map<String, Object> settingsDto) {
        Object objUserId = settingsDto.remove("org.jbpm.form.builder.services.model.Settings.userId");
        this.userId = objUserId == null ? null : String.valueOf(objUserId);
        Object objId = settingsDto.remove("org.jbpm.form.builder.services.model.Settings.id");
        this.id = objId == null ? null : Long.valueOf(String.valueOf(objId));
        this.entries.clear();
        for (Map.Entry<String, Object> entry : settingsDto.entrySet()) {
            if (entry.getKey().endsWith("@org.jbpm.form.builder.services.model.SettingsEntry.id")) continue;
            String value = entry.getValue() == null ? null : String.valueOf(entry.getValue());
            Object objEntryId = settingsDto.get(entry.getKey() + "@org.jbpm.form.builder.services.model.SettingsEntry.id");
            Long entryId = objEntryId == null ? null : Long.valueOf(String.valueOf(objEntryId));
            SettingsEntry settingsEntry = new SettingsEntry(entry.getKey(), value);
            settingsEntry.setId(entryId);
            this.entries.add(settingsEntry);
        }
    }
}

