/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.impl;

import javax.persistence.EntityManagerFactory;
import org.drools.core.command.CommandService;
import org.drools.core.command.impl.GenericCommand;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.kie.api.command.Command;
import org.kie.internal.command.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalCommandService
implements CommandService {
    private static final Logger logger = LoggerFactory.getLogger(TransactionalCommandService.class);
    private EntityManagerFactory emf;
    private Context context;
    private JtaTransactionManager txm;

    public TransactionalCommandService(EntityManagerFactory emf) {
        this.emf = emf;
        this.txm = new JtaTransactionManager(null, null, null);
    }

    public Context getContext() {
        return this.context;
    }

    public <T> T execute(Command<T> command) {
        boolean transactionOwner = false;
        Object result = null;
        try {
            transactionOwner = this.txm.begin();
            JpaPersistenceContext context = new JpaPersistenceContext(this.emf.createEntityManager());
            context.joinTransaction();
            result = ((GenericCommand)command).execute((Context)context);
            this.txm.commit(transactionOwner);
            context.close();
            return (T)result;
        }
        catch (RuntimeException re) {
            this.rollbackTransaction(re, transactionOwner);
            throw re;
        }
        catch (Exception t1) {
            this.rollbackTransaction(t1, transactionOwner);
            throw new RuntimeException("Wrapped exception see cause", t1);
        }
    }

    private void rollbackTransaction(Exception t1, boolean transactionOwner) {
        try {
            logger.warn("Could not commit session", (Throwable)t1);
            this.txm.rollback(transactionOwner);
        }
        catch (Exception t2) {
            logger.error("Could not rollback", (Throwable)t2);
            throw new RuntimeException("Could not commit session or rollback", t2);
        }
    }
}

