/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model.xml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jbpm.services.task.impl.model.xml.AbstractJaxbTaskObject;
import org.jbpm.services.task.impl.model.xml.JaxbDeadlines;
import org.jbpm.services.task.impl.model.xml.JaxbI18NText;
import org.jbpm.services.task.impl.model.xml.JaxbPeopleAssignments;
import org.jbpm.services.task.impl.model.xml.JaxbTaskData;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.Delegation;
import org.kie.internal.task.api.model.InternalI18NText;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.SubTasksStrategy;

@XmlRootElement(name="task")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(value={"archived", "descriptions", "names", "subjects", "peopleAssignments"})
public class JaxbTask
implements InternalTask {
    @XmlElement
    @XmlSchemaType(name="long")
    private Long id;
    @XmlElement
    @XmlSchemaType(name="long")
    private Integer priority;
    @XmlElement(name="task-type")
    @XmlSchemaType(name="int")
    private String taskType;
    @XmlElement(name="name")
    @XmlSchemaType(name="String")
    private String name;
    @XmlElement(name="subject")
    @XmlSchemaType(name="String")
    private String subject;
    @XmlElement(name="description")
    @XmlSchemaType(name="String")
    private String description;
    @XmlElement(name="names")
    private List<JaxbI18NText> jaxbNames;
    @XmlElement(name="subjects")
    private List<JaxbI18NText> jaxbSubjects;
    @XmlElement(name="descriptions")
    private List<JaxbI18NText> jaxbDescriptions;
    @XmlElement(name="people-assignments")
    private JaxbPeopleAssignments jaxbPeopleAssignments;
    @XmlElement
    private JaxbTaskData jaxbTaskData;
    @XmlElement
    @JsonIgnore
    private JaxbDeadlines deadlines = new JaxbDeadlines();
    @XmlElement(name="form-name")
    @XmlSchemaType(name="String")
    private String formName;

    public JaxbTask() {
    }

    public JaxbTask(Task task) {
        this.initialize(task);
    }

    public void initialize(Task task) {
        if (task == null) {
            return;
        }
        this.id = task.getId();
        this.priority = task.getPriority();
        this.jaxbPeopleAssignments = new JaxbPeopleAssignments(task.getPeopleAssignments());
        this.jaxbNames = JaxbI18NText.convertListFromInterfaceToJaxbImpl(task.getNames());
        this.jaxbSubjects = JaxbI18NText.convertListFromInterfaceToJaxbImpl(task.getSubjects());
        this.jaxbDescriptions = JaxbI18NText.convertListFromInterfaceToJaxbImpl(task.getDescriptions());
        this.jaxbTaskData = new JaxbTaskData(task.getTaskData());
        this.taskType = task.getTaskType();
        this.formName = ((InternalTask)task).getFormName();
        this.name = ((InternalTask)task).getName();
        this.description = ((InternalTask)task).getDescription();
        this.subject = ((InternalTask)task).getSubject();
    }

    @JsonProperty
    public Long getId() {
        return this.id;
    }

    @JsonProperty
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(long id) {
        this.id = id;
    }

    @JsonProperty
    public int getPriority() {
        return this.priority;
    }

    @JsonProperty
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @JsonIgnore
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public List<JaxbI18NText> getJaxbNames() {
        return this.jaxbNames;
    }

    public void setJaxbNames(List<JaxbI18NText> names) {
        this.jaxbNames = names;
    }

    @JsonIgnore
    public List<I18NText> getNames() {
        if (this.jaxbNames == null) {
            this.jaxbNames = Collections.emptyList();
        }
        return Collections.unmodifiableList(JaxbI18NText.convertListFromJaxbImplToInterface(this.jaxbNames));
    }

    public void setNames(List<I18NText> names) {
        this.jaxbNames = JaxbI18NText.convertListFromInterfaceToJaxbImpl(names);
    }

    public List<JaxbI18NText> getJaxbSubjects() {
        return this.jaxbSubjects;
    }

    public void setJaxbSubjects(List<JaxbI18NText> subjects) {
        this.jaxbSubjects = subjects;
    }

    public List<I18NText> getSubjects() {
        if (this.jaxbSubjects == null) {
            this.jaxbSubjects = Collections.emptyList();
        }
        return Collections.unmodifiableList(JaxbI18NText.convertListFromJaxbImplToInterface(this.jaxbSubjects));
    }

    public void setSubjects(List<I18NText> subjects) {
        this.jaxbSubjects = JaxbI18NText.convertListFromInterfaceToJaxbImpl(subjects);
    }

    public List<JaxbI18NText> getJaxbDescriptions() {
        return this.jaxbDescriptions;
    }

    public void setJaxbDescriptions(List<JaxbI18NText> descriptions) {
        this.jaxbDescriptions = descriptions;
    }

    public List<I18NText> getDescriptions() {
        if (this.jaxbDescriptions == null) {
            this.jaxbDescriptions = Collections.emptyList();
        }
        return Collections.unmodifiableList(JaxbI18NText.convertListFromJaxbImplToInterface(this.jaxbDescriptions));
    }

    public void setDescriptions(List<I18NText> descriptions) {
        this.jaxbDescriptions = JaxbI18NText.convertListFromInterfaceToJaxbImpl(descriptions);
    }

    public JaxbPeopleAssignments getJaxbPeopleAssignments() {
        return this.jaxbPeopleAssignments;
    }

    public void setJaxbPeopleAssignments(JaxbPeopleAssignments jaxbPeopleAssignments) {
        this.jaxbPeopleAssignments = jaxbPeopleAssignments;
    }

    @JsonIgnore
    public PeopleAssignments getPeopleAssignments() {
        return this.jaxbPeopleAssignments;
    }

    public void setPeopleAssignments(PeopleAssignments peopleAssignments) {
        this.jaxbPeopleAssignments = peopleAssignments instanceof JaxbPeopleAssignments ? (JaxbPeopleAssignments)peopleAssignments : new JaxbPeopleAssignments(peopleAssignments);
    }

    @JsonIgnore
    public TaskData getTaskData() {
        return this.jaxbTaskData;
    }

    public void setTaskData(TaskData taskData) {
        this.jaxbTaskData = taskData instanceof JaxbTaskData ? (JaxbTaskData)taskData : new JaxbTaskData(taskData);
    }

    public JaxbTaskData getJaxbTaskData() {
        return this.jaxbTaskData;
    }

    public void setJaxbTaskData(JaxbTaskData jaxbTaskData) {
        this.jaxbTaskData = jaxbTaskData;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    @JsonIgnore
    public Deadlines getDeadlines() {
        return this.deadlines;
    }

    public void setDeadlines(Deadlines deadlines) {
    }

    @JsonIgnore
    public Task getTask() {
        Task taskImpl = TaskModelProvider.getFactory().newTask();
        ArrayList<I18NText> names = new ArrayList<I18NText>();
        for (I18NText n : this.getNames()) {
            I18NText text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            names.add(text);
        }
        ((InternalTask)taskImpl).setNames(names);
        ArrayList descriptions = new ArrayList();
        for (I18NText n : this.getDescriptions()) {
            I18NText text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            names.add(text);
        }
        ((InternalTask)taskImpl).setDescriptions(descriptions);
        ArrayList subjects = new ArrayList();
        for (I18NText n : this.getSubjects()) {
            I18NText text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            names.add(text);
        }
        ((InternalTask)taskImpl).setSubjects(subjects);
        ((InternalTask)taskImpl).setPriority(this.getPriority());
        InternalTaskData taskData = (InternalTaskData)TaskModelProvider.getFactory().newTaskData();
        taskData.setWorkItemId(this.getTaskData().getWorkItemId());
        taskData.setProcessInstanceId(this.getTaskData().getProcessInstanceId());
        taskData.setProcessId(this.getTaskData().getProcessId());
        taskData.setProcessSessionId(this.getTaskData().getProcessSessionId());
        taskData.setSkipable(this.getTaskData().isSkipable());
        PeopleAssignments peopleAssignments = TaskModelProvider.getFactory().newPeopleAssignments();
        ArrayList<Object> potentialOwners = new ArrayList<Object>();
        for (OrganizationalEntity e : this.getPeopleAssignments().getPotentialOwners()) {
            if (e instanceof User) {
                User user = TaskModelProvider.getFactory().newUser();
                ((InternalOrganizationalEntity)user).setId(e.getId());
                potentialOwners.add(user);
                continue;
            }
            if (!(e instanceof Group)) continue;
            Group group = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)group).setId(e.getId());
            potentialOwners.add(group);
        }
        ((InternalPeopleAssignments)peopleAssignments).setPotentialOwners(potentialOwners);
        ArrayList<Object> businessAdmins = new ArrayList<Object>();
        for (OrganizationalEntity e : this.getPeopleAssignments().getBusinessAdministrators()) {
            if (e instanceof User) {
                User user = TaskModelProvider.getFactory().newUser();
                ((InternalOrganizationalEntity)user).setId(e.getId());
                businessAdmins.add(user);
                continue;
            }
            if (!(e instanceof Group)) continue;
            Group group = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)group).setId(e.getId());
            businessAdmins.add(group);
        }
        if (this.getPeopleAssignments().getTaskInitiator() != null) {
            User user = TaskModelProvider.getFactory().newUser();
            ((InternalOrganizationalEntity)user).setId(this.getPeopleAssignments().getTaskInitiator().getId());
            ((InternalPeopleAssignments)peopleAssignments).setTaskInitiator(user);
        }
        ((InternalPeopleAssignments)peopleAssignments).setBusinessAdministrators(businessAdmins);
        ((InternalPeopleAssignments)peopleAssignments).setExcludedOwners(new ArrayList());
        ((InternalPeopleAssignments)peopleAssignments).setRecipients(new ArrayList());
        ((InternalPeopleAssignments)peopleAssignments).setTaskStakeholders(new ArrayList());
        ((InternalTask)taskImpl).setPeopleAssignments(peopleAssignments);
        ((InternalTask)taskImpl).setTaskData((TaskData)taskData);
        return taskImpl;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @JsonIgnore
    public String getFormName() {
        return this.formName;
    }

    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void writeExternal(ObjectOutput arg0) throws IOException {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    @JsonIgnore
    public Boolean isArchived() {
        return (Boolean)AbstractJaxbTaskObject.unsupported(Task.class);
    }

    @JsonIgnore
    public void setArchived(Boolean archived) {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void setVersion(Integer version) {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    @JsonIgnore
    public int getVersion() {
        return (Integer)AbstractJaxbTaskObject.unsupported(Task.class);
    }

    @JsonIgnore
    public Delegation getDelegation() {
        return (Delegation)AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void setDelegation(Delegation delegation) {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    @JsonIgnore
    public SubTasksStrategy getSubTaskStrategy() {
        return (SubTasksStrategy)AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void setSubTaskStrategy(SubTasksStrategy subTaskStrategy) {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public String getName() {
        return this.name;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

