/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.config.xml.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.solder.config.xml.model.AnnotationXmlItem;
import org.jboss.solder.config.xml.util.XmlConfigurationException;
import org.jboss.solder.config.xml.util.XmlObjectConverter;
import org.jboss.solder.reflection.AnnotationInstanceProvider;

class AnnotationUtils {
    private static final AnnotationInstanceProvider annotationInstanceProvider = new AnnotationInstanceProvider();

    AnnotationUtils() {
    }

    static Annotation createAnnotation(AnnotationXmlItem item) {
        HashMap<String, Object> typedVars = new HashMap<String, Object>();
        Class<?> anClass = item.getJavaClass();
        for (Map.Entry<String, String> e : item.getAttributes().entrySet()) {
            Method m;
            String mname = e.getKey();
            try {
                m = anClass.getDeclaredMethod(mname, new Class[0]);
            }
            catch (Exception e1) {
                throw new XmlConfigurationException("Annotation " + item.getJavaClass().getName() + " does not have a member named " + mname + " ,error in XML", item.getDocument(), item.getLineno());
            }
            Class<?> returnType = m.getReturnType();
            typedVars.put(mname, XmlObjectConverter.convert(returnType, e.getValue()));
        }
        return annotationInstanceProvider.get(item.getJavaClass(), typedVars);
    }
}

