/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.servlet.resource;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.servlet.resource.WebResourceLocationProvider;

public class DirectoryNameResourceProvider
implements WebResourceLocationProvider {
    private final Logger log = Logger.getLogger(DirectoryNameResourceProvider.class);

    public int getPrecedence() {
        return 50;
    }

    public URL getWebResource(String path, ClassLoader classLoader) {
        block8: {
            String relativeResourceName = this.getClass().getName().replace('.', '/') + ".class";
            URL knownResource = classLoader.getResource(relativeResourceName);
            if (knownResource == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Could not find resource: " + relativeResourceName));
                }
                return null;
            }
            String url = knownResource.toString();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Found known resource: " + url));
            }
            if (url.startsWith("jar:") && url.contains("!")) {
                url = url.substring(4, url.lastIndexOf("!"));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Location of JAR file containing the resource: " + url));
                }
            }
            try {
                int i = url.lastIndexOf("/WEB-INF/lib/");
                if (i >= 0) {
                    return new URL(url.substring(0, i) + path);
                }
            }
            catch (MalformedURLException e) {
                if (!this.log.isDebugEnabled()) break block8;
                this.log.debug((Object)"Failed to create URL instance!", (Throwable)e);
            }
        }
        return null;
    }
}

