/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.dmg.pmml.pmml_4_1.descr.COMPAREFUNCTION;
import org.dmg.pmml.pmml_4_1.descr.DATATYPE;
import org.dmg.pmml.pmml_4_1.descr.DataField;
import org.dmg.pmml.pmml_4_1.descr.REGRESSIONNORMALIZATIONMETHOD;
import org.dmg.pmml.pmml_4_1.descr.RESULTFEATURE;
import org.dmg.pmml.pmml_4_1.descr.Value;
import org.drools.pmml.pmml_4_1.extensions.AggregationStrategy;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;

public class PMML4Helper {
    private static final String innerFieldPrefix = "__$Inner";
    private static int counter = 0;
    private Set<String> definedModelBeans = new HashSet<String>();
    private ClassLoader resolver;
    private String context = null;
    private String pack;

    public int nextCount() {
        return counter++;
    }

    public String nextInnerFieldName() {
        return innerFieldPrefix + this.nextCount();
    }

    public boolean isInnerFieldName(String name) {
        return name != null && name.startsWith(innerFieldPrefix);
    }

    public static String pmmlDefaultPackageName() {
        return "org.drools.pmml.pmml_4_1";
    }

    public String getPmmlPackageName() {
        return PMML4Helper.pmmlDefaultPackageName();
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void addModelBeanDefinition(String beanType) {
        this.definedModelBeans.add(beanType);
    }

    public ClassLoader getResolver() {
        return this.resolver;
    }

    public void setResolver(ClassLoader resolver) {
        this.resolver = resolver;
    }

    public boolean isModelBeanDefined(String beanType) {
        boolean flag = this.definedModelBeans.contains(beanType);
        if (this.resolver == null) {
            try {
                Class.forName(this.pack + "." + beanType);
                return true;
            }
            catch (ClassNotFoundException cnfe) {
                this.definedModelBeans.remove(beanType);
                return false;
            }
        }
        if (flag) {
            try {
                Class.forName(this.pack + "." + beanType, false, this.resolver);
                return true;
            }
            catch (ClassNotFoundException cnfe) {
                this.definedModelBeans.remove(beanType);
                return false;
            }
        }
        return false;
    }

    public void applyTemplate(String templateName, Object context, TemplateRegistry registry, Map vars, StringBuilder builder) {
        CompiledTemplate template = registry.getNamedTemplate(templateName);
        String result = (String)TemplateRuntime.execute((CompiledTemplate)template, (Object)context, (Map)vars);
        builder.append(result);
    }

    public String getPack() {
        return this.pack;
    }

    public void setPack(String packageName) {
        this.pack = packageName;
    }

    public Object copy(Object orig) {
        Object obj = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            obj = in.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return obj;
    }

    public String box(String s) {
        if ("int".equalsIgnoreCase(s)) {
            return Integer.class.getName();
        }
        if ("float".equalsIgnoreCase(s)) {
            return Float.class.getName();
        }
        if ("double".equalsIgnoreCase(s)) {
            return Double.class.getName();
        }
        if ("boolean".equalsIgnoreCase(s)) {
            return Boolean.class.getName();
        }
        if ("short".equalsIgnoreCase(s)) {
            return Short.class.getName();
        }
        if ("long".equalsIgnoreCase(s)) {
            return Long.class.getName();
        }
        return s;
    }

    public String streamInputType(String s) {
        if ("int".equalsIgnoreCase(s)) {
            return Number.class.getName();
        }
        if ("float".equalsIgnoreCase(s)) {
            return Number.class.getName();
        }
        if ("double".equalsIgnoreCase(s)) {
            return Number.class.getName();
        }
        if ("boolean".equalsIgnoreCase(s)) {
            return Boolean.class.getName();
        }
        if ("short".equalsIgnoreCase(s)) {
            return Number.class.getName();
        }
        if ("long".equalsIgnoreCase(s)) {
            return Number.class.getName();
        }
        return s;
    }

    public String mapDatatype(DATATYPE datatype) {
        return this.mapDatatype(datatype, false);
    }

    public String mapDatatype(DATATYPE datatype, boolean box) {
        String s;
        String string = s = datatype != null ? datatype.value() : null;
        if (s == null) {
            return Object.class.getName();
        }
        if ("Integer".equalsIgnoreCase(s)) {
            return box ? "Integer" : "int";
        }
        if ("Float".equalsIgnoreCase(s)) {
            return box ? "Float" : "float";
        }
        if ("Double".equalsIgnoreCase(s)) {
            return box ? "Double" : "double";
        }
        if ("Boolean".equalsIgnoreCase(s)) {
            return box ? "Boolean" : "boolean";
        }
        if ("String".equalsIgnoreCase(s)) {
            return String.class.getName();
        }
        if ("Date".equalsIgnoreCase(s)) {
            return Date.class.getName();
        }
        if ("Time".equalsIgnoreCase(s)) {
            return Date.class.getName();
        }
        if ("DateTime".equalsIgnoreCase(s)) {
            return Date.class.getName();
        }
        if ("DateDaysSince[0]".equalsIgnoreCase(s)) {
            return Long.class.getName();
        }
        if ("DateDaysSince[1960]".equalsIgnoreCase(s)) {
            return Long.class.getName();
        }
        if ("DateDaysSince[1970]".equalsIgnoreCase(s)) {
            return Long.class.getName();
        }
        if ("DateDaysSince[1980]".equalsIgnoreCase(s)) {
            return Long.class.getName();
        }
        if ("TimeSeconds".equalsIgnoreCase(s)) {
            return Long.class.getName();
        }
        if ("DateTimeSecondsSince[0]".equalsIgnoreCase(s)) {
            return Long.class.getName();
        }
        if ("DateTimeSecondsSince[1960]".equalsIgnoreCase(s)) {
            return Long.class.getName();
        }
        if ("DateTimeSecondsSince[1970]".equalsIgnoreCase(s)) {
            return Long.class.getName();
        }
        if ("DateTimeSecondsSince[1980]".equalsIgnoreCase(s)) {
            return Long.class.getName();
        }
        if ("collection".equalsIgnoreCase(s)) {
            return Collection.class.getName();
        }
        return Object.class.getName();
    }

    public String format(DataField fld, Value val) {
        if (val == null) {
            return "null";
        }
        String s = fld.getDataType().value();
        return this.format(s, val);
    }

    public String format(String type, Value val) {
        if (val == null) {
            return "null";
        }
        return this.format(type, val.getValue());
    }

    public String format(DataField fld, String val) {
        if (val == null) {
            return "null";
        }
        String s = fld.getDataType().value();
        return this.format(s, val);
    }

    public String format(DATATYPE type, String val) {
        if (val == null) {
            return "null";
        }
        return this.format(type != null ? type.value() : null, val);
    }

    public String format(String type, String val) {
        if (type == null) {
            return val;
        }
        if (val == null) {
            return "null";
        }
        if (Integer.class.getName().equals(type) || "Integer".equalsIgnoreCase(type) || "int".equalsIgnoreCase(type)) {
            return val;
        }
        if (Float.class.getName().equals(type) || "Float".equalsIgnoreCase(type) || "float".equalsIgnoreCase(type)) {
            return val;
        }
        if (Double.class.getName().equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type) || "double".equalsIgnoreCase(type)) {
            return val;
        }
        if (Long.class.getName().equalsIgnoreCase(type) || "Long".equalsIgnoreCase(type) || "long".equalsIgnoreCase(type)) {
            return val;
        }
        if (Short.class.getName().equalsIgnoreCase(type) || "Short".equalsIgnoreCase(type) || "short".equalsIgnoreCase(type)) {
            return val;
        }
        if (Byte.class.getName().equalsIgnoreCase(type) || "Byte".equalsIgnoreCase(type) || "byte".equalsIgnoreCase(type)) {
            return val;
        }
        if (Boolean.class.getName().equalsIgnoreCase(type) || "Boolean".equalsIgnoreCase(type) || "boolean".equalsIgnoreCase(type)) {
            return val.toLowerCase();
        }
        if (String.class.getName().equalsIgnoreCase(type) || "String".equalsIgnoreCase(type)) {
            return "\"" + val + "\"";
        }
        if ("Date".equalsIgnoreCase(type)) {
            return "\"" + val + "\"";
        }
        if ("Time".equalsIgnoreCase(type)) {
            return "\"" + val + "\"";
        }
        if ("DateTime".equalsIgnoreCase(type)) {
            return "\"" + val + "\"";
        }
        if ("DateDaysSince[0]".equalsIgnoreCase(type)) {
            return val;
        }
        if ("DateDaysSince[1960]".equalsIgnoreCase(type)) {
            return val;
        }
        if ("DateDaysSince[1970]".equalsIgnoreCase(type)) {
            return val;
        }
        if ("DateDaysSince[1980]".equalsIgnoreCase(type)) {
            return val;
        }
        if ("TimeSeconds".equalsIgnoreCase(type)) {
            return val;
        }
        if ("DateTimeSecondsSince[0]".equalsIgnoreCase(type)) {
            return val;
        }
        if ("DateTimeSecondsSince[1960]".equalsIgnoreCase(type)) {
            return val;
        }
        if ("DateTimeSecondsSince[1970]".equalsIgnoreCase(type)) {
            return val;
        }
        if ("DateTimeSecondsSince[1980]".equalsIgnoreCase(type)) {
            return val;
        }
        return val;
    }

    public String format(String type, Number val) {
        if (type == null) {
            return val.toString();
        }
        if (val == null) {
            return null;
        }
        if ("Integer".endsWith(type) || "int".equalsIgnoreCase(type)) {
            return "" + val.intValue();
        }
        if ("Float".endsWith(type) || "float".equalsIgnoreCase(type)) {
            return "" + val.floatValue();
        }
        if ("Double".endsWith(type) || "double".equalsIgnoreCase(type)) {
            return "" + val.doubleValue();
        }
        if ("Boolean".endsWith(type) || "boolean".equalsIgnoreCase(type)) {
            if (val.doubleValue() == 1.0) {
                return "true";
            }
            if (val.doubleValue() == 0.0) {
                return "false";
            }
            throw new NumberFormatException("Boolean expected, found " + val);
        }
        if ("String".endsWith(type)) {
            return "\"" + val.toString() + "\"";
        }
        if ("Date".endsWith(type)) {
            return "\"" + new SimpleDateFormat().format(new Date(val.longValue())) + "\"";
        }
        if ("Time".endsWith(type)) {
            return "\"" + val.toString() + "\"";
        }
        if ("DateTime".endsWith(type)) {
            return "\"" + new SimpleDateFormat().format(new Date(val.longValue())) + "\"";
        }
        if ("DateDaysSince[0]".equalsIgnoreCase(type)) {
            throw new UnsupportedOperationException("TODO");
        }
        if ("DateDaysSince[1960]".equalsIgnoreCase(type)) {
            throw new UnsupportedOperationException("TODO");
        }
        if ("DateDaysSince[1970]".equalsIgnoreCase(type)) {
            throw new UnsupportedOperationException("TODO");
        }
        if ("DateDaysSince[1980]".equalsIgnoreCase(type)) {
            throw new UnsupportedOperationException("TODO");
        }
        if ("TimeSeconds".equalsIgnoreCase(type)) {
            throw new UnsupportedOperationException("TODO");
        }
        if ("DateTimeSecondsSince[0]".equalsIgnoreCase(type)) {
            throw new UnsupportedOperationException("TODO");
        }
        if ("DateTimeSecondsSince[1960]".equalsIgnoreCase(type)) {
            throw new UnsupportedOperationException("TODO");
        }
        if ("DateTimeSecondsSince[1970]".equalsIgnoreCase(type)) {
            throw new UnsupportedOperationException("TODO");
        }
        if ("DateTimeSecondsSince[1980]".equalsIgnoreCase(type)) {
            throw new UnsupportedOperationException("TODO");
        }
        return val.toString();
    }

    public String zeroForDatatype(DATATYPE type) {
        return this.zeroForDatatype(type != null ? type.value() : null);
    }

    public String zeroForDatatype(String type) {
        if (type == null) {
            return "null";
        }
        if (Integer.class.getName().equals(type) || "Integer".equalsIgnoreCase(type) || "int".equalsIgnoreCase(type)) {
            return "0";
        }
        if (Float.class.getName().equals(type) || "Float".equalsIgnoreCase(type) || "float".equalsIgnoreCase(type)) {
            return "0.0f";
        }
        if (Double.class.getName().equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type) || "double".equalsIgnoreCase(type)) {
            return "0.0";
        }
        if (Long.class.getName().equalsIgnoreCase(type) || "Long".equalsIgnoreCase(type) || "long".equalsIgnoreCase(type)) {
            return "0L";
        }
        if (Short.class.getName().equalsIgnoreCase(type) || "Short".equalsIgnoreCase(type) || "short".equalsIgnoreCase(type)) {
            return "0";
        }
        if (Byte.class.getName().equalsIgnoreCase(type) || "Byte".equalsIgnoreCase(type) || "byte".equalsIgnoreCase(type)) {
            return "0";
        }
        if (Boolean.class.getName().equalsIgnoreCase(type) || "Boolean".equalsIgnoreCase(type) || "boolean".equalsIgnoreCase(type)) {
            return "false";
        }
        if (String.class.getName().equalsIgnoreCase(type) || "String".equalsIgnoreCase(type)) {
            return "null";
        }
        return "null";
    }

    public String numberFromNumber(String obj, String datatype) {
        if (Integer.class.getSimpleName().equalsIgnoreCase(datatype) || Integer.class.getName().equalsIgnoreCase(datatype)) {
            return obj + ".intValue()";
        }
        if (Float.class.getSimpleName().equalsIgnoreCase(datatype) || Float.class.getName().equalsIgnoreCase(datatype)) {
            return obj + ".floatValue()";
        }
        if (Double.class.getSimpleName().equalsIgnoreCase(datatype) || Double.class.getName().equalsIgnoreCase(datatype)) {
            return obj + ".doubleValue()";
        }
        return obj;
    }

    public String mapFunctionAsQuery(String functor, List args) {
        String[] argz = new String[args.size()];
        for (int j = 0; j < args.size(); ++j) {
            argz[j] = args.get(j).toString();
        }
        return this.mapFunction(functor, true, argz);
    }

    public String mapFunctionAsQuery(String functor, String ... args) {
        return this.mapFunction(functor, true, args);
    }

    public String mapFunction(String functor, List args) {
        String[] argz = new String[args.size()];
        for (int j = 0; j < args.size(); ++j) {
            argz[j] = args.get(j).toString();
        }
        return this.mapFunction(functor, false, argz);
    }

    public String mapFunction(String functor, String ... args) {
        return this.mapFunction(functor, false, args);
    }

    public String mapFunction(String functor, boolean asQuery, String ... args) {
        String ans = "(";
        if ("+".equals(functor)) {
            ans = ans + args[0];
            for (int j = 1; j < args.length; ++j) {
                ans = ans + " + " + args[j];
            }
        } else if ("-".equals(functor)) {
            ans = ans + args[0];
            for (int j = 1; j < args.length; ++j) {
                ans = ans + " - " + args[j];
            }
        } else if ("*".equals(functor)) {
            ans = ans + args[0];
            for (int j = 1; j < args.length; ++j) {
                ans = ans + " * " + args[j];
            }
        } else if ("/".equals(functor)) {
            if ((ans = ans + args[0]).length() > 1) {
                ans = ans + " / " + args[1];
            }
        } else if ("identity".equals(functor)) {
            ans = ans + args[0];
        } else if ("min".equals(functor)) {
            ans = ans + this.associativeNaryToBinary("Math.min", 0, args);
        } else if ("max".equals(functor)) {
            ans = ans + this.associativeNaryToBinary("Math.max", 0, args);
        } else if ("sum".equals(functor)) {
            ans = ans + args[0];
            for (int j = 1; j < args.length; ++j) {
                ans = ans + " + " + args[j];
            }
        } else if ("median".equals(functor)) {
            ans = args.length % 2 == 0 ? ans + " 0.5 * " + args[args.length / 2 - 1] + " + 0.5 * " + args[args.length / 2] + " " : ans + args[args.length / 2];
        } else if ("product".equals(functor)) {
            ans = ans + args[0];
            for (int j = 1; j < args.length; ++j) {
                ans = ans + " * " + args[j];
            }
        } else if ("avg".equals(functor)) {
            ans = ans + "(" + args[0];
            for (int j = 1; j < args.length; ++j) {
                ans = ans + " + " + args[j];
            }
            ans = ans + ") / " + args.length;
        } else if ("log10".equals(functor)) {
            ans = ans + "Math.log10(" + args[0] + ")";
        } else if ("ln".equals(functor)) {
            ans = ans + "Math.log(" + args[0] + ")";
        } else if ("sqrt".equals(functor)) {
            ans = ans + "Math.sqrt(" + args[0] + ")";
        } else if ("abs".equals(functor)) {
            ans = ans + "Math.abs(" + args[0] + ")";
        } else if ("exp".equals(functor)) {
            ans = ans + "Math.exp(" + args[0] + ")";
        } else if ("pow".equals(functor)) {
            ans = "0".equals(args[0]) && "0".equals(args[1]) ? ans + "1" : ans + "Math.pow(" + args[0] + "," + args[1] + ")";
        } else if ("threshold".equals(functor)) {
            ans = ans + args[0] + " > " + args[1] + " ? 1 : 0";
        } else if ("floor".equals(functor)) {
            ans = ans + "Math.floor(" + args[0] + ")";
        } else if ("round".equals(functor)) {
            ans = ans + "Math.round(" + args[0] + ")";
        } else if ("ceil".equals(functor)) {
            ans = ans + "Math.ceil(" + args[0] + ")";
        } else if ("uppercase".equals(functor)) {
            ans = ans + args[0] + ".toString().toUpperCase()";
        } else if ("substring".equals(functor)) {
            int start = Integer.valueOf(args[1]) - 1;
            int len = Integer.valueOf(args[2]);
            ans = ans + args[0] + ".toString().substring(" + start + "," + (start + len) + ")";
        } else if ("trimBlanks".equals(functor)) {
            ans = ans + args[0] + ".toString().trim()";
        } else if ("formatNumber".equals(functor)) {
            ans = ans + "new java.util.Formatter(new StringBuilder(),java.util.Locale.getDefault()).format(" + args[0] + "," + Double.valueOf(args[1]) + ")";
        } else if ("formatDatetime".equals(functor)) {
            ans = ans + "new java.text.SimpleDateFormat(" + this.posix2Java(args[1]) + ").format(new SimpleDateFormat().parse(" + args[0] + "))";
        } else if ("dateDaysSinceYear".equals(functor)) {
            ans = ans + "( (new java.text.SimpleDateFormat()).parse(" + args[0] + ").getTime()" + " - (new java.text.SimpleDateFormat()).parse(\"01/01/" + args[1] + "\").getTime() ) / (1000*60*60*24)";
        } else if ("dateSecondsSinceYear".equals(functor)) {
            ans = ans + "( (new java.text.SimpleDateFormat()).parse(" + args[0] + ").getTime()" + " - (new java.text.SimpleDateFormat()).parse(\"01/01/" + args[1] + "\").getTime() ) / 1000";
        } else if ("dateSecondsSinceMidnight".equals(functor)) {
            ans = ans + "(new java.text.SimpleDateFormat()).parse(" + args[0] + ").getTime() % 1000";
        } else if ("equal".equals(functor)) {
            ans = ans + args[0] + " == " + args[1];
        } else if ("notEqual".equals(functor)) {
            ans = ans + args[0] + " != " + args[1];
        } else if ("lessThan".equals(functor)) {
            ans = ans + args[0] + " < " + args[1];
        } else if ("lessOrEqual".equals(functor)) {
            ans = ans + args[0] + " <= " + args[1];
        } else if ("greaterThan".equals(functor)) {
            ans = ans + args[0] + " > " + args[1];
        } else if ("greaterOrEqual".equals(functor)) {
            ans = ans + args[0] + " >= " + args[1];
        } else if ("isIn".equals(functor)) {
            ans = ans + args[0] + ".contains(" + args[1] + ")";
        } else if ("isNotIn".equals(functor)) {
            ans = ans + "(! " + args[0] + ".contains(" + args[1] + "))";
        } else if ("not".equals(functor)) {
            ans = ans + "( ! " + args[0] + " )";
        } else if ("and".equals(functor)) {
            ans = ans + args[0];
            for (int j = 1; j < args.length; ++j) {
                ans = ans + " && " + args[j];
            }
        } else if ("or".equals(functor)) {
            ans = ans + args[0];
            for (int j = 1; j < args.length; ++j) {
                ans = ans + " || " + args[j];
            }
        } else if ("if".equals(functor)) {
            ans = ans + args[0] + " ? " + args[1] + " : " + (args.length > 2 ? args[2] : "null");
        } else {
            if (args.length == 0) {
                if (asQuery) {
                    return functor + "( $" + functor + "_return ; )";
                }
                return functor + "( )";
            }
            String tmp = args[0];
            for (int j = 1; j < args.length; ++j) {
                tmp = tmp + ", " + args[j];
            }
            if (asQuery) {
                tmp = tmp + ", $ctx, $" + functor + "_return ; ";
            }
            return functor + "( " + tmp + " )";
        }
        if (asQuery) {
            ans = ans + ", $ctx, $" + functor + "_return ; ";
        }
        ans = ans + ")";
        return ans;
    }

    public boolean isBuiltIn(String functor) {
        if ("+".equals(functor)) {
            return true;
        }
        if ("-".equals(functor)) {
            return true;
        }
        if ("*".equals(functor)) {
            return true;
        }
        if ("/".equals(functor)) {
            return true;
        }
        if ("identity".equals(functor)) {
            return true;
        }
        if ("min".equals(functor)) {
            return true;
        }
        if ("max".equals(functor)) {
            return true;
        }
        if ("sum".equals(functor)) {
            return true;
        }
        if ("median".equals(functor)) {
            return true;
        }
        if ("product".equals(functor)) {
            return true;
        }
        if ("avg".equals(functor)) {
            return true;
        }
        if ("log10".equals(functor)) {
            return true;
        }
        if ("ln".equals(functor)) {
            return true;
        }
        if ("sqrt".equals(functor)) {
            return true;
        }
        if ("abs".equals(functor)) {
            return true;
        }
        if ("exp".equals(functor)) {
            return true;
        }
        if ("pow".equals(functor)) {
            return true;
        }
        if ("threshold".equals(functor)) {
            return true;
        }
        if ("floor".equals(functor)) {
            return true;
        }
        if ("round".equals(functor)) {
            return true;
        }
        if ("ceil".equals(functor)) {
            return true;
        }
        if ("uppercase".equals(functor)) {
            return true;
        }
        if ("substring".equals(functor)) {
            return true;
        }
        if ("trimBlanks".equals(functor)) {
            return true;
        }
        if ("formatNumber".equals(functor)) {
            return true;
        }
        if ("formatDatetime".equals(functor)) {
            return true;
        }
        if ("dateDaysSinceYear".equals(functor)) {
            return true;
        }
        if ("dateSecondsSinceYear".equals(functor)) {
            return true;
        }
        if ("dateSecondsSinceMidnight".equals(functor)) {
            return true;
        }
        if ("equal".equals(functor)) {
            return true;
        }
        if ("notEqual".equals(functor)) {
            return true;
        }
        if ("lessThan".equals(functor)) {
            return true;
        }
        if ("lessOrEqual".equals(functor)) {
            return true;
        }
        if ("greaterThan".equals(functor)) {
            return true;
        }
        if ("greaterOrEqual".equals(functor)) {
            return true;
        }
        if ("isIn".equals(functor)) {
            return true;
        }
        if ("isNotIn".equals(functor)) {
            return true;
        }
        if ("not".equals(functor)) {
            return true;
        }
        if ("and".equals(functor)) {
            return true;
        }
        if ("or".equals(functor)) {
            return true;
        }
        return "if".equals(functor);
    }

    private String posix2Java(String posixFormat) {
        return posixFormat;
    }

    private String associativeNaryToBinary(String f, int j, Object ... args) {
        if (j < args.length - 1) {
            return f + "(" + args[j] + "," + this.associativeNaryToBinary(f, j + 1, args) + ")";
        }
        return args[j].toString();
    }

    public String mapNeuralActivation(String functor, double threshold) {
        if ("threshold".equals(functor)) {
            return " x > " + threshold + " ? 1 : 0";
        }
        if ("logistic".equals(functor)) {
            return "1.0/(1+Math.exp(-x))";
        }
        if ("tanh".equals(functor)) {
            return "(1.0-Math.exp(-2*x))/(1.0+Math.exp(2*x))";
        }
        if ("identity".equals(functor)) {
            return "x";
        }
        if ("exponential".equals(functor)) {
            return "Math.exp(x)";
        }
        if ("reciprocal".equals(functor)) {
            return "1.0/x";
        }
        if ("square".equals(functor)) {
            return "x*x";
        }
        if ("Gauss".equals(functor)) {
            return "Math.exp(-x*x)";
        }
        if ("sine".equals(functor)) {
            return "Math.sin(x)";
        }
        if ("cosine".equals(functor)) {
            return "Math.cos(x)";
        }
        if ("Elliott".equals(functor)) {
            return "x/(1.0+Math.abs(x))";
        }
        if ("arctan".equals(functor)) {
            return "2.0*Math.atan(x)/Math.PI";
        }
        return "x";
    }

    public String mapRegModelRegressionNormalization(String method, String arg) {
        if (method == null || REGRESSIONNORMALIZATIONMETHOD.NONE.value().equals(method)) {
            return arg;
        }
        if (REGRESSIONNORMALIZATIONMETHOD.EXP.value().equals(method)) {
            return "Math.exp( " + arg + " )";
        }
        if (REGRESSIONNORMALIZATIONMETHOD.SOFTMAX.value().equals(method) || REGRESSIONNORMALIZATIONMETHOD.LOGIT.value().equals(method)) {
            return "1.0 / ( 1.0 + Math.exp( -" + arg + " ) ) ";
        }
        throw new UnsupportedOperationException("Regression models can't support " + method + ", check that a classification model was not required instead. ");
    }

    public String mapRegModelClassificationNormalization(String method, String arg) {
        if (method == null || REGRESSIONNORMALIZATIONMETHOD.NONE.value().equals(method)) {
            return arg;
        }
        if (REGRESSIONNORMALIZATIONMETHOD.EXP.value().equals(method)) {
            return "Math.exp( " + arg + " )";
        }
        if (REGRESSIONNORMALIZATIONMETHOD.SOFTMAX.value().equals(method)) {
            return "Math.exp( " + arg + " )";
        }
        if (REGRESSIONNORMALIZATIONMETHOD.LOGIT.value().equals(method)) {
            return "1.0 / ( 1.0 + Math.exp( -" + arg + " ) )";
        }
        if (REGRESSIONNORMALIZATIONMETHOD.PROBIT.value().equals(method)) {
            return "probitPhi( " + arg + " )";
        }
        if (REGRESSIONNORMALIZATIONMETHOD.CLOGLOG.value().equals(method)) {
            return "1.0 - Math.exp( - Math.exp( " + arg + " ) )";
        }
        if (REGRESSIONNORMALIZATIONMETHOD.LOGLOG.value().equals(method)) {
            return "Math.exp( - Math.exp( -" + arg + " ) )";
        }
        if (REGRESSIONNORMALIZATIONMETHOD.CAUCHIT.value().equals(method)) {
            return "0.5 + Math.atan( " + arg + " ) / Math.PI";
        }
        throw new UnsupportedOperationException("Unknown normalization method :" + method);
    }

    public String compactUpperCase(String s) {
        StringTokenizer tok = new StringTokenizer(s);
        StringBuilder sb = new StringBuilder();
        while (tok.hasMoreTokens()) {
            sb.append(this.capitalize(tok.nextToken()));
        }
        String out = sb.toString();
        if (out.matches("\\d.*")) {
            out = "DF_" + out;
        }
        return out;
    }

    public String compact(String s) {
        StringTokenizer tok = new StringTokenizer(s);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (tok.hasMoreTokens()) {
            sb.append(first ? this.lowerCase(tok.nextToken()) : this.capitalize(tok.nextToken()));
            first = false;
        }
        String out = sb.toString();
        if (out.matches("\\d.*")) {
            out = "DF_" + out;
        }
        return out;
    }

    public String lowerCase(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public String getToken(String s, int j) {
        StringTokenizer tok = new StringTokenizer(s);
        for (int i = 0; i < j; ++i) {
            tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            return null;
        }
        return tok.nextToken();
    }

    public String[] tokenize(String s, String delimiters) {
        StringTokenizer tok = new StringTokenizer(s, delimiters);
        return this.tokenize(tok);
    }

    public String[] tokenize(String s) {
        StringTokenizer tok = new StringTokenizer(s);
        return this.tokenize(tok);
    }

    private String[] tokenize(StringTokenizer tok) {
        int num = tok.countTokens();
        String[] toks = new String[num];
        for (int j = 0; j < num; ++j) {
            toks[j] = tok.nextToken();
        }
        return toks;
    }

    public String[] ones(Integer num) {
        Object[] ones = new String[num.intValue()];
        Arrays.fill(ones, "1.0");
        return ones;
    }

    public String mapComparisonFunction(COMPAREFUNCTION fun, String arg1, String arg2, String scope, String local) {
        switch (fun) {
            case ABS_DIFF: {
                return "Math.abs( " + arg1 + " - " + arg2 + ")";
            }
            case DELTA: {
                return " ( " + arg1 + " == " + arg2 + " ) ? 0.0 : 1.0";
            }
            case EQUAL: {
                return " ( " + arg1 + " == " + arg2 + " ) ? 1.0 : 0.0";
            }
            case GAUSS_SIM: {
                return "Math.exp( - Math.log( 2.0 ) * ( " + arg1 + " - " + arg2 + " ) * ( " + arg1 + " - " + arg2 + " ) / ( " + scope + " * " + scope + " ) )";
            }
            case TABLE: {
                return local;
            }
        }
        throw new IllegalStateException("Unrecognized PMML CompareFunction " + (Object)((Object)fun));
    }

    public String mapOperator(String op) {
        if ("equal".equals(op)) {
            return "==";
        }
        if ("notEqual".equals(op)) {
            return "!=";
        }
        if ("lessThan".equals(op)) {
            return "<";
        }
        if ("lessOrEqual".equals(op)) {
            return "<=";
        }
        if ("greaterThan".equals(op)) {
            return ">";
        }
        if ("greaterOrEqual".equals(op)) {
            return ">=";
        }
        if ("and".equals(op)) {
            return "&&";
        }
        if ("or".equals(op)) {
            return "||";
        }
        if ("xor".equals(op)) {
            return "^^";
        }
        throw new IllegalStateException("Unrecognized PMML Operator " + op);
    }

    public String mapDatatypeToQuestion(DATATYPE datatype) {
        String s;
        String string = s = datatype != null ? datatype.value() : null;
        if (s == null) {
            return Object.class.getName();
        }
        if ("Integer".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_NUMBER";
        }
        if ("Float".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_DECIMAL";
        }
        if ("Double".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_DECIMAL";
        }
        if ("Boolean".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_BOOLEAN";
        }
        if ("String".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_TEXT";
        }
        if ("Date".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_DATE";
        }
        if ("Time".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_DATE";
        }
        if ("DateTime".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_DATE";
        }
        if ("DateDaysSince[0]".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_NUMBER";
        }
        if ("DateDaysSince[1960]".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_NUMBER";
        }
        if ("DateDaysSince[1970]".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_NUMBER";
        }
        if ("DateDaysSince[1980]".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_NUMBER";
        }
        if ("TimeSeconds".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_NUMBER";
        }
        if ("DateTimeSecondsSince[0]".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_NUMBER";
        }
        if ("DateTimeSecondsSince[1960]".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_NUMBER";
        }
        if ("DateTimeSecondsSince[1970]".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_NUMBER";
        }
        if ("DateTimeSecondsSince[1980]".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_NUMBER";
        }
        if ("collection".equalsIgnoreCase(s)) {
            return "Question.QuestionType.TYPE_LIST";
        }
        return "Question.QuestionType.TYPE_TEXT";
    }

    public String mapTreeOp(String op) {
        if ("and".equals(op)) {
            return " && ";
        }
        if ("or".equals(op)) {
            return " || ";
        }
        if ("xor".equals(op)) {
            return " ^^ ";
        }
        if ("surrogate".equals(op)) {
            return " || ";
        }
        return " , ";
    }

    public DATATYPE mapFeatureType(DATATYPE srcType, RESULTFEATURE feat) {
        if (feat == null) {
            return srcType;
        }
        switch (feat) {
            case PREDICTED_VALUE: {
                return srcType;
            }
            case PREDICTED_DISPLAY_VALUE: {
                return DATATYPE.STRING;
            }
            case PROBABILITY: {
                return DATATYPE.DOUBLE;
            }
            case REASON_CODE: {
                return DATATYPE.STRING;
            }
        }
        return srcType;
    }

    public void reset() {
        this.definedModelBeans = new HashSet<String>();
    }

    public static AggregationStrategy resolveAggregationStrategy(String strat) {
        if (strat == null || strat.isEmpty()) {
            return AggregationStrategy.AGGREGATE_SCORE;
        }
        AggregationStrategy agg = AggregationStrategy.valueOf(strat);
        return agg != null ? agg : AggregationStrategy.AGGREGATE_SCORE;
    }

    public boolean isWeighted(String strat) {
        return PMML4Helper.resolveAggregationStrategy(strat).isWeighted();
    }

    public String mapWeightStrategy(String strat) {
        return PMML4Helper.resolveAggregationStrategy(strat).getAggregator();
    }
}

