/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity.adapter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jbpm.services.task.identity.adapter.UserGroupAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSphereUserGroupAdapter
implements UserGroupAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WebSphereUserGroupAdapter.class);
    private Object registry;

    public WebSphereUserGroupAdapter() {
        try {
            this.registry = InitialContext.doLookup("UserRegistry");
        }
        catch (NamingException e) {
            logger.warn("Unable to look up UserRegistry in JNDI under key 'UserRegistry', disabling websphere adapter");
        }
    }

    @Override
    public List<String> getGroupsForUser(String userId) {
        ArrayList<String> roles = new ArrayList<String>();
        if (this.registry == null || userId == null || !userId.isEmpty()) {
            return roles;
        }
        try {
            Method method = this.registry.getClass().getMethod("getGroupsForUser", String.class);
            List rolesIn = (List)method.invoke(this.registry, userId);
            if (rolesIn != null) {
                for (Object o : rolesIn) {
                    roles.add(o.toString());
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to get roles for user {} from registry due to {}", new Object[]{userId, e.getMessage(), e});
        }
        return roles;
    }
}

