/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.services.task.query.QueryFilterImpl;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.TaskQueryService;
import org.kie.internal.task.api.model.InternalTaskSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueryServiceImpl
implements TaskQueryService {
    private static final Logger logger = LoggerFactory.getLogger(TaskQueryServiceImpl.class);
    private TaskPersistenceContext persistenceContext;
    private static final List<Status> allActiveStatus = new ArrayList<Status>(){
        {
            this.add(Status.Created);
            this.add(Status.Ready);
            this.add(Status.Reserved);
            this.add(Status.InProgress);
            this.add(Status.Suspended);
        }
    };
    public static final String MAX_RESULTS = "maxResults";
    private static String VARIOUS_FIELDS_TASKSUM_QUERY = "select distinct  new org.jbpm.services.task.query.TaskSummaryImpl(t.id,\n                t.name,\n                t.description,\n                t.taskData.status,\n                t.priority,\n                t.taskData.actualOwner.id,\n                t.taskData.createdBy.id,\n                t.taskData.createdOn,\n                t.taskData.activationTime,\n                t.taskData.expirationTime,\n                t.taskData.processId,\n                t.taskData.processInstanceId,\n                t.taskData.parentId,\n                t.taskData.deploymentId              )from  TaskImpl t,   OrganizationalEntityImpl businessAdministrator,   OrganizationalEntityImpl potentialOwners where t.archived = 0";

    protected void applyQueryFilter(Map<String, Object> params, QueryFilter queryContext) {
        if (queryContext != null) {
            params.put("firstResult", queryContext.getOffset());
            params.put(MAX_RESULTS, queryContext.getCount());
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending().booleanValue()) {
                    params.put("asc", "true");
                } else {
                    params.put("desc", "true");
                }
            }
            if (queryContext.getFilterParams() != null && !queryContext.getFilterParams().isEmpty()) {
                params.put("filter", queryContext.getFilterParams());
                for (String key : queryContext.getParams().keySet()) {
                    params.put(key, queryContext.getParams().get(key));
                }
            }
        }
    }

    public TaskQueryServiceImpl() {
    }

    public TaskQueryServiceImpl(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setPersistenceContext(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsBusinessAdministrator", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsExcludedOwner", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwner", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return this.getTasksAssignedAsPotentialOwner(userId);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("groupIds", groupIds);
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerWithGroups", params, ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedByGroup(String groupId) {
        if (groupId == null || groupId.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroup", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupId", groupId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedByGroupsByExpirationDateOptional(List<String> groupIds, Date expirationDate) {
        if (groupIds == null || groupIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List tasksByGroups = (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroupsByExpirationDateOptional", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupIds", groupIds, "expirationDate", expirationDate}), ClassUtil.castClass(List.class));
        return this.collectTasksByPotentialOwners(tasksByGroups);
    }

    protected List<TaskSummary> collectTasksByPotentialOwners(List<Object[]> tasksByGroups) {
        Set<Long> tasksIds = Collections.synchronizedSet(new HashSet());
        Map potentialOwners = Collections.synchronizedMap(new HashMap());
        Iterator<Object[]> i$ = tasksByGroups.iterator();
        while (i$.hasNext()) {
            Object[] o;
            Object[] get = o = i$.next();
            tasksIds.add((Long)get[0]);
            if (potentialOwners.get((Long)get[0]) == null) {
                potentialOwners.put((Long)get[0], new ArrayList());
            }
            ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
        }
        if (!tasksIds.isEmpty()) {
            List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TaskSummariesByIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", tasksIds}), ClassUtil.castClass(List.class));
            for (TaskSummary ts : tasks) {
                ((InternalTaskSummary)ts).setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
            return tasks;
        }
        return new ArrayList<TaskSummary>();
    }

    public List<TaskSummary> getTasksAssignedByGroupsByExpirationDate(List<String> groupIds, Date expirationDate) {
        if (groupIds == null || groupIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List tasksByGroups = (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroupsByExpirationDate", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupIds", groupIds, "expirationDate", expirationDate}), ClassUtil.castClass(List.class));
        return this.collectTasksByPotentialOwners(tasksByGroups);
    }

    public List<TaskSummary> getTasksAssignedByGroups(List<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List tasksByGroups = (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroups", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupIds", groupIds}), ClassUtil.castClass(List.class));
        Set<Long> tasksIds = Collections.synchronizedSet(new HashSet());
        Map potentialOwners = Collections.synchronizedMap(new HashMap());
        Iterator i$ = tasksByGroups.iterator();
        while (i$.hasNext()) {
            Object[] o;
            Object[] get = o = (Object[])i$.next();
            tasksIds.add((Long)get[0]);
            if (potentialOwners.get((Long)get[0]) == null) {
                potentialOwners.put((Long)get[0], new ArrayList());
            }
            ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
        }
        if (!tasksIds.isEmpty()) {
            List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TaskSummariesByIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", tasksIds}), ClassUtil.castClass(List.class));
            for (TaskSummary ts : tasks) {
                ((InternalTaskSummary)ts).setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
            return tasks;
        }
        return new ArrayList<TaskSummary>();
    }

    public Map<Long, List<OrganizationalEntity>> getPotentialOwnersForTaskIds(List<Long> taskIds) {
        List potentialOwners = (List)this.persistenceContext.queryWithParametersInTransaction("GetPotentialOwnersForTaskIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", taskIds}), ClassUtil.castClass(List.class));
        HashMap<Long, List<OrganizationalEntity>> potentialOwnersMap = new HashMap<Long, List<OrganizationalEntity>>();
        Long currentTaskId = 0L;
        for (Object[] item : potentialOwners) {
            Long taskId = (Long)item[0];
            OrganizationalEntity potentialOwner = (OrganizationalEntity)item[1];
            if (currentTaskId != taskId) {
                currentTaskId = taskId;
            }
            if (potentialOwnersMap.get(currentTaskId) == null) {
                potentialOwnersMap.put(currentTaskId, new ArrayList());
            }
            ((List)potentialOwnersMap.get(currentTaskId)).add(potentialOwner);
        }
        return potentialOwnersMap;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, int firstResult, int maxResults) {
        if (groupIds == null || groupIds.isEmpty()) {
            return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwner", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "firstResult", firstResult, MAX_RESULTS, maxResults}), ClassUtil.castClass(List.class));
        }
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerWithGroups", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", groupIds, "firstResult", firstResult, MAX_RESULTS, maxResults}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsRecipient(String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsRecipient", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsTaskInitiator", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsTaskStakeholder", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksOwned(String userId) {
        return this.getTasksOwned(userId, null, null);
    }

    public List<TaskSummary> getTasksOwnedByStatus(String userId, List<Status> status) {
        List<TaskSummary> taskOwned = this.getTasksOwned(userId, null, null);
        if (!taskOwned.isEmpty()) {
            HashSet<Long> tasksIds = new HashSet<Long>();
            for (TaskSummary ts : taskOwned) {
                tasksIds.add(ts.getId());
            }
            List tasksPotentialOwners = (List)this.persistenceContext.queryWithParametersInTransaction("TasksOwnedPotentialOwnersByTaskIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", tasksIds}), ClassUtil.castClass(List.class));
            HashMap potentialOwners = new HashMap();
            Iterator<Object> i$ = tasksPotentialOwners.iterator();
            while (i$.hasNext()) {
                Object[] o;
                Object[] get = o = (Object[])i$.next();
                tasksIds.add((Long)get[0]);
                if (potentialOwners.get((Long)get[0]) == null) {
                    potentialOwners.put((Long)get[0], new ArrayList());
                }
                ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
            }
            for (TaskSummary ts : taskOwned) {
                ((InternalTaskSummary)ts).setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
        } else {
            return new ArrayList<TaskSummary>(0);
        }
        return taskOwned;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status) {
        return this.getTasksAssignedAsPotentialOwner(userId, null, status, null);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, List<Status> status, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("status", status);
        params.put("groupIds", groupIds);
        this.applyQueryFilter(params, filter);
        return (List)this.persistenceContext.queryWithParametersInTransaction("NewTasksAssignedAsPotentialOwner", params, ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksOwned(String userId, List<Status> status, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        if (status == null) {
            status = new ArrayList<Status>();
            status.add(Status.Reserved);
            status.add(Status.InProgress);
        }
        params.put("status", status);
        this.applyQueryFilter(params, filter);
        return (List)this.persistenceContext.queryWithParametersInTransaction("NewTasksOwned", params, ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("SubTasksAssignedAsPotentialOwner", (Map)this.persistenceContext.addParametersToMap(new Object[]{"parentId", parentId, "userId", userId}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getSubTasksByParent(long parentId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("GetSubTasksByParentTaskId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"parentId", parentId}), ClassUtil.castClass(List.class));
    }

    public int getPendingSubTasksByParent(long parentId) {
        return ((List)this.persistenceContext.queryWithParametersInTransaction("GetSubTasksByParentTaskId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"parentId", parentId}), ClassUtil.castClass(List.class))).size();
    }

    public Task getTaskInstanceById(long taskId) {
        Task taskInstance = this.persistenceContext.findTask(Long.valueOf(taskId));
        return taskInstance;
    }

    public Task getTaskByWorkItemId(long workItemId) {
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TaskByWorkItemId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"workItemId", workItemId, MAX_RESULTS, 1}), ClassUtil.castClass(List.class));
        if (tasks.isEmpty()) {
            return null;
        }
        return (Task)tasks.get(0);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDate(String userId, List<String> groupIds, List<Status> status, Date expirationDate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("expirationDate", expirationDate);
        return this.getTasksAssignedAsPotentialOwner(userId, groupIds, status, new QueryFilterImpl("t.taskData.expirationTime = :expirationDate", params, "order by t.id", false));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<String> groupIds, List<Status> status, Date expirationDate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("expirationDate", expirationDate);
        return this.getTasksAssignedAsPotentialOwner(userId, groupIds, status, new QueryFilterImpl("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "order by t.id", false));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDate(String userId, List<Status> status, Date expirationDate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("expirationDate", expirationDate);
        return this.getTasksOwned(userId, status, new QueryFilterImpl("t.taskData.expirationTime = :expirationDate", params, "order by t.id", false));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateOptional(String userId, List<Status> status, Date expirationDate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("expirationDate", expirationDate);
        return this.getTasksOwned(userId, status, new QueryFilterImpl("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "order by t.id", false));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateBeforeSpecifiedDate(String userId, List<Status> status, Date date) {
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksOwnedWithParticularStatusByExpirationDateBeforeSpecifiedDate", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "status", status, "date", date}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceId(long processInstanceId, List<Status> status) {
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TasksByStatusByProcessId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"processInstanceId", processInstanceId, "status", status}), ClassUtil.castClass(List.class));
        return tasks;
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceIdByTaskName(long processInstanceId, List<Status> status, String taskName) {
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TasksByStatusByProcessIdByTaskName", (Map)this.persistenceContext.addParametersToMap(new Object[]{"processInstanceId", processInstanceId, "status", status, "taskName", taskName}), ClassUtil.castClass(List.class));
        return tasks;
    }

    public List<Long> getTasksByProcessInstanceId(long processInstanceId) {
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TasksByProcessInstanceId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"processInstanceId", processInstanceId}), ClassUtil.castClass(List.class));
        return tasks;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDate(String userId, List<Status> status, Date expirationDate) {
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerStatusByExpirationDate", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", "", "status", status, "expirationDate", expirationDate}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<Status> status, Date expirationDate) {
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerStatusByExpirationDateOptional", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", "", "status", status, "expirationDate", expirationDate}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksByVariousFields(List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> status, boolean union) {
        HashMap params = new HashMap();
        params.put("Work item id list", workItemIds);
        params.put("task id list", taskIds);
        params.put("process instance id list", procInstIds);
        params.put("business admin id list", busAdmins);
        params.put("potential owner id list", potOwners);
        params.put("task owner id list", taskOwners);
        params.put("status list", status);
        return this.getTasksByVariousFields(params, union);
    }

    public List<TaskSummary> getTasksByVariousFields(List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> status, boolean union, Integer maxResults) {
        HashMap params = new HashMap();
        params.put("Work item id list", workItemIds);
        params.put("task id list", taskIds);
        params.put("process instance id list", procInstIds);
        params.put("business admin id list", busAdmins);
        params.put("potential owner id list", potOwners);
        params.put("task owner id list", taskOwners);
        if (status == null || status.isEmpty()) {
            status = allActiveStatus;
        }
        params.put("status list", status);
        if (maxResults != null) {
            if (maxResults <= 0) {
                return new ArrayList<TaskSummary>();
            }
            Integer[] maxResultsArr = new Integer[]{maxResults};
            params.put(MAX_RESULTS, Arrays.asList(maxResultsArr));
        }
        return this.getTasksByVariousFields(params, union);
    }

    public List<TaskSummary> getTasksByVariousFields(Map<String, List<?>> parameters, boolean union) {
        String query;
        String paramName;
        Object maxResults;
        StringBuilder queryBuilder = new StringBuilder(VARIOUS_FIELDS_TASKSUM_QUERY);
        HashMap<String, Object> params = new HashMap<String, Object>();
        WhereClauseWithListParamAppender longQueryAdder = new WhereClauseWithListParamAppender(Long.class, queryBuilder, params, union);
        WhereClauseWithListParamAppender stringQueryAdder = new WhereClauseWithListParamAppender(String.class, queryBuilder, params, union);
        WhereClauseWithListParamAppender statusQueryAdder = new WhereClauseWithListParamAppender(Status.class, queryBuilder, params, union);
        List workItemIds = longQueryAdder.checkNullAndInstanceOf(parameters, "Work item id list");
        List taskIds = longQueryAdder.checkNullAndInstanceOf(parameters, "task id list");
        List procInstIds = longQueryAdder.checkNullAndInstanceOf(parameters, "process instance id list");
        List busAdmins = stringQueryAdder.checkNullAndInstanceOf(parameters, "business admin id list");
        List potOwners = stringQueryAdder.checkNullAndInstanceOf(parameters, "potential owner id list");
        List taskOwners = stringQueryAdder.checkNullAndInstanceOf(parameters, "task owner id list");
        List status = statusQueryAdder.checkNullAndInstanceOf(parameters, "status list");
        List<?> maxResultsList = parameters.get(MAX_RESULTS);
        if (maxResultsList != null && !maxResultsList.isEmpty() && (maxResults = maxResultsList.get(0)) instanceof Integer) {
            params.put(MAX_RESULTS, maxResults);
        }
        if (workItemIds != null && workItemIds.size() > 0) {
            paramName = "workItemIds";
            longQueryAdder.addToQueryBuilder("( t.taskData.workItemId in ( :" + paramName + " ) ) ", paramName, workItemIds);
        }
        if (taskIds != null && taskIds.size() > 0) {
            paramName = "taskIds";
            longQueryAdder.addToQueryBuilder("( t.id in ( :" + paramName + " ) ) ", paramName, taskIds);
        }
        if (procInstIds != null && procInstIds.size() > 0) {
            paramName = "procInstIds";
            longQueryAdder.addToQueryBuilder("( t.taskData.processInstanceId in ( :" + paramName + " ) ) ", paramName, procInstIds);
        }
        stringQueryAdder.getQueryState(longQueryAdder);
        if (busAdmins != null && busAdmins.size() > 0) {
            paramName = "busAdminIds";
            query = "( businessAdministrator.id in ( :" + paramName + " ) and " + "businessAdministrator in elements ( t.peopleAssignments.businessAdministrators ) ) ";
            stringQueryAdder.addToQueryBuilder(query, paramName, busAdmins);
        }
        if (potOwners != null && potOwners.size() > 0) {
            paramName = "potOwnerIds";
            query = "( potentialOwners.id in ( :" + paramName + " ) and " + "potentialOwners in elements ( t.peopleAssignments.potentialOwners ) ) ";
            stringQueryAdder.addToQueryBuilder(query, paramName, potOwners);
        }
        if (taskOwners != null && taskOwners.size() > 0) {
            paramName = "taskOwnerIds";
            query = "( t.taskData.actualOwner.id in ( :" + paramName + " ) ) ";
            stringQueryAdder.addToQueryBuilder(query, paramName, taskOwners);
        }
        statusQueryAdder.getQueryState(stringQueryAdder);
        if (status != null && status.size() > 0) {
            paramName = "statuses";
            query = "( t.taskData.status in (:" + paramName + ") ) ";
            statusQueryAdder.addToQueryBuilder(query, paramName, status);
        }
        if (!statusQueryAdder.firstUse) {
            queryBuilder.append(")");
        }
        queryBuilder.append(" ORDER BY t.id");
        String query2 = queryBuilder.toString();
        logger.debug("QUERY: {}", (Object)query2);
        return (List)this.persistenceContext.queryStringWithParametersInTransaction(query2, params, ClassUtil.castClass(List.class));
    }

    public int getCompletedTaskByUserId(String userId) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Completed);
        List<TaskSummary> tasksCompleted = this.getTasksAssignedAsPotentialOwnerByStatus(userId, statuses);
        return tasksCompleted.size();
    }

    public int getPendingTaskByUserId(String userId) {
        List<TaskSummary> tasksAssigned = this.getTasksAssignedAsPotentialOwner(userId, null, null, null);
        return tasksAssigned.size();
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("groupIds", groupIds);
        params.put("status", status);
        return (List)this.persistenceContext.queryWithParametersInTransaction("QuickTasksAssignedAsPotentialOwnerWithGroupsByStatus", params, ClassUtil.castClass(List.class));
    }

    private class WhereClauseWithListParamAppender<T> {
        private final String andOr;
        private boolean firstUse = true;
        private boolean alreadyUsed = false;
        private final StringBuilder queryBuilder;
        private final Map<String, Object> queryParams;
        private final Class<?> clazz;

        public WhereClauseWithListParamAppender(Class<?> clazz, StringBuilder queryBuilder, Map<String, Object> params, boolean union) {
            this.andOr = union ? " OR " : " AND ";
            this.queryBuilder = queryBuilder;
            this.queryParams = params;
            this.clazz = clazz;
        }

        public void addToQueryBuilder(String query, String paramName, List<T> paramValList) {
            if (this.firstUse) {
                this.queryBuilder.append(" AND (");
                this.firstUse = false;
            } else if (this.alreadyUsed) {
                this.queryBuilder.append(this.andOr);
            }
            this.queryBuilder.append(query);
            HashSet<T> paramVals = new HashSet<T>();
            for (T val : paramValList) {
                if (val == null) continue;
                paramVals.add(val);
            }
            this.queryParams.put(paramName, paramVals);
            this.alreadyUsed = true;
        }

        public void getQueryState(WhereClauseWithListParamAppender<?> paramAppender) {
            this.alreadyUsed = paramAppender.alreadyUsed;
            this.firstUse = paramAppender.firstUse;
        }

        public List<T> checkNullAndInstanceOf(Map<String, List<?>> params, String field) {
            List<T> result = null;
            List<?> inputList = params.get(field);
            if (inputList != null && inputList.size() > 0) {
                Object inputObject = inputList.get(0);
                if (this.clazz.equals(inputObject.getClass())) {
                    return inputList;
                }
                throw new IllegalArgumentException(field + " parameter is an instance of " + "List<" + inputObject.getClass().getSimpleName() + "> instead of " + "List<" + this.clazz.getSimpleName() + ">");
            }
            return result;
        }
    }
}

