/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.core.util.StringUtils;
import org.jbpm.kie.services.impl.AbstractDeploymentService;
import org.jbpm.kie.services.impl.DeployedUnitImpl;
import org.jbpm.kie.services.impl.IdentityProviderAwareProcessListener;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.impl.KModuleRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorMerger;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.ObjectModelResolver;
import org.kie.internal.runtime.conf.ObjectModelResolverProvider;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.scanner.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KModuleDeploymentService
extends AbstractDeploymentService {
    private static Logger logger = LoggerFactory.getLogger(KModuleDeploymentService.class);
    private static final String DEFAULT_KBASE_NAME = "defaultKieBase";
    private DefinitionService bpmn2Service;
    private DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();

    public void onInit() {
        EntityManagerFactoryManager.get().addEntityManagerFactory("org.jbpm.domain", this.getEmf());
    }

    @Override
    public void deploy(DeploymentUnit unit) {
        try {
            InternalKieModule module;
            super.deploy(unit);
            if (!(unit instanceof KModuleDeploymentUnit)) {
                throw new IllegalArgumentException("Invalid deployment unit provided - " + unit.getClass().getName());
            }
            KModuleDeploymentUnit kmoduleUnit = (KModuleDeploymentUnit)unit;
            KieServices ks = KieServices.Factory.get();
            DeployedUnitImpl deployedUnit = new DeployedUnitImpl(unit);
            ReleaseId releaseId = ks.newReleaseId(kmoduleUnit.getGroupId(), kmoduleUnit.getArtifactId(), kmoduleUnit.getVersion());
            MavenRepository repository = MavenRepository.getMavenRepository();
            repository.resolveArtifact(releaseId.toExternalForm());
            KieContainer kieContainer = ks.newKieContainer(releaseId);
            String kbaseName = kmoduleUnit.getKbaseName();
            if (StringUtils.isEmpty((CharSequence)kbaseName)) {
                KieBaseModel defaultKBaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
                kbaseName = defaultKBaseModel != null ? defaultKBaseModel.getName() : DEFAULT_KBASE_NAME;
            }
            if ((module = (InternalKieModule)((KieContainerImpl)kieContainer).getKieModuleForKBase(kbaseName)) == null) {
                throw new IllegalStateException("Cannot find kbase, either it does not exist or there are multiple default kbases in kmodule.xml");
            }
            HashMap<String, String> formsData = new HashMap<String, String>();
            Collection files = module.getFileNames();
            this.processResources(module, formsData, files, kieContainer, kmoduleUnit, deployedUnit, releaseId);
            if (module.getKieDependencies() != null) {
                Collection dependencies = module.getKieDependencies().values();
                for (InternalKieModule depModule : dependencies) {
                    logger.debug("Processing dependency module " + depModule.getReleaseId());
                    files = depModule.getFileNames();
                    this.processResources(depModule, formsData, files, kieContainer, kmoduleUnit, deployedUnit, depModule.getReleaseId());
                }
            }
            KieBase kbase = kieContainer.getKieBase(kbaseName);
            AuditEventBuilder auditLoggerBuilder = this.setupAuditLogger(this.identityProvider, unit.getIdentifier());
            RuntimeEnvironmentBuilder builder = this.boostrapRuntimeEnvironmentBuilder(kmoduleUnit, deployedUnit, kieContainer, kmoduleUnit.getMergeMode()).knowledgeBase(kbase).classLoader(kieContainer.getClassLoader());
            builder.registerableItemsFactory(this.getRegisterableItemsFactory(auditLoggerBuilder, kieContainer, kmoduleUnit));
            this.commonDeploy(unit, deployedUnit, builder.get());
            kmoduleUnit.setDeployed(true);
        }
        catch (Throwable e) {
            logger.warn("Unexpected error while deploying unit {}", (Object)unit.getIdentifier(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    protected RegisterableItemsFactory getRegisterableItemsFactory(AuditEventBuilder auditLoggerBuilder, KieContainer kieContainer, KModuleDeploymentUnit unit) {
        KModuleRegisterableItemsFactory factory = new KModuleRegisterableItemsFactory(kieContainer, unit.getKsessionName());
        factory.setAuditBuilder(auditLoggerBuilder);
        factory.addProcessListener(IdentityProviderAwareProcessListener.class);
        return factory;
    }

    @Override
    public void undeploy(DeploymentUnit unit) {
        if (!(unit instanceof KModuleDeploymentUnit)) {
            throw new IllegalArgumentException("Invalid deployment unit provided - " + unit.getClass().getName());
        }
        KModuleDeploymentUnit kmoduleUnit = (KModuleDeploymentUnit)unit;
        super.undeploy(unit);
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(kmoduleUnit.getGroupId(), kmoduleUnit.getArtifactId(), kmoduleUnit.getVersion());
        ks.getRepository().removeKieModule(releaseId);
    }

    protected RuntimeEnvironmentBuilder boostrapRuntimeEnvironmentBuilder(KModuleDeploymentUnit deploymentUnit, DeployedUnit deployedUnit, KieContainer kieContainer, MergeMode mode) {
        Object entry;
        List descriptorHierarchy;
        DeploymentDescriptorManager descriptorManager;
        DeploymentDescriptor descriptor = deploymentUnit.getDeploymentDescriptor();
        if (descriptor == null) {
            descriptorManager = new DeploymentDescriptorManager("org.jbpm.domain");
            descriptorHierarchy = descriptorManager.getDeploymentDescriptorHierarchy(kieContainer);
            descriptor = this.merger.merge(descriptorHierarchy, mode);
            deploymentUnit.setDeploymentDescriptor(descriptor);
        } else if (descriptor != null && !deploymentUnit.isDeployed()) {
            descriptorManager = new DeploymentDescriptorManager("org.jbpm.domain");
            descriptorHierarchy = descriptorManager.getDeploymentDescriptorHierarchy(kieContainer);
            descriptorHierarchy.add(0, descriptor);
            descriptor = this.merger.merge(descriptorHierarchy, mode);
            deploymentUnit.setDeploymentDescriptor(descriptor);
        }
        deploymentUnit.setStrategy(descriptor.getRuntimeStrategy());
        RuntimeEnvironmentBuilder builder = null;
        builder = descriptor.getPersistenceMode() == PersistenceMode.NONE ? RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder() : RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder();
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(descriptor.getPersistenceUnit());
        builder.entityManagerFactory((Object)emf);
        HashMap<String, Object> contaxtParams = new HashMap<String, Object>();
        contaxtParams.put("entityManagerFactory", emf);
        contaxtParams.put("classLoader", kieContainer.getClassLoader());
        for (NamedObjectModel model : descriptor.getEnvironmentEntries()) {
            entry = this.getInstanceFromModel((ObjectModel)model, kieContainer, contaxtParams);
            builder.addEnvironmentEntry(model.getName(), entry);
        }
        for (NamedObjectModel model : descriptor.getConfiguration()) {
            entry = this.getInstanceFromModel((ObjectModel)model, kieContainer, contaxtParams);
            builder.addConfiguration(model.getName(), (String)entry);
        }
        ObjectMarshallingStrategy[] mStrategies = new ObjectMarshallingStrategy[descriptor.getMarshallingStrategies().size() + 1];
        int index = 0;
        for (ObjectModel model : descriptor.getMarshallingStrategies()) {
            Object strategy = this.getInstanceFromModel(model, kieContainer, contaxtParams);
            mStrategies[index] = (ObjectMarshallingStrategy)strategy;
            ++index;
        }
        mStrategies[index] = new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT);
        builder.addEnvironmentEntry("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)mStrategies);
        builder.addEnvironmentEntry("KieDeploymentDescriptor", (Object)descriptor);
        if (descriptor.getRequiredRoles() != null && !descriptor.getRequiredRoles().isEmpty()) {
            for (DeployedAsset desc : deployedUnit.getDeployedAssets()) {
                if (!(desc instanceof ProcessAssetDesc)) continue;
                ((ProcessAssetDesc)desc).setRoles(descriptor.getRequiredRoles());
            }
        }
        return builder;
    }

    protected Object getInstanceFromModel(ObjectModel model, KieContainer kieContainer, Map<String, Object> contaxtParams) {
        ObjectModelResolver resolver = ObjectModelResolverProvider.get((String)model.getResolver());
        if (resolver == null) {
            logger.warn("Unable to find ObjectModelResolver for {}", (Object)model.getResolver());
        }
        return resolver.getInstance(model, kieContainer.getClassLoader(), contaxtParams);
    }

    protected void processResources(InternalKieModule module, Map<String, String> formsData, Collection<String> files, KieContainer kieContainer, DeploymentUnit unit, DeployedUnitImpl deployedUnit, ReleaseId releaseId) {
        for (String fileName : files) {
            String key;
            Matcher m;
            Pattern regex;
            String formContent;
            if (fileName.matches(".+bpmn[2]?$")) {
                try {
                    String processString = new String(module.getBytes(fileName), "UTF-8");
                    ProcessAssetDesc process = (ProcessAssetDesc)this.bpmn2Service.buildProcessDefinition(unit.getIdentifier(), processString, kieContainer.getClassLoader(), true);
                    if (process == null) {
                        throw new IllegalArgumentException("Unable to read process " + fileName);
                    }
                    process.setEncodedProcessSource(Base64.encodeBase64String((byte[])processString.getBytes()));
                    process.setDeploymentId(unit.getIdentifier());
                    process.setForms(formsData);
                    deployedUnit.addAssetLocation(process.getId(), process);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Unsupported encoding while processing process " + fileName);
                }
            }
            if (fileName.matches(".+ftl$")) {
                try {
                    formContent = new String(module.getBytes(fileName), "UTF-8");
                    regex = Pattern.compile("(.{0}|.*/)([^/]*?)\\.ftl");
                    m = regex.matcher(fileName);
                    key = fileName;
                    while (m.find()) {
                        key = m.group(2);
                    }
                    formsData.put(key, formContent);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Unsupported encoding while processing form " + fileName);
                }
            }
            if (fileName.matches(".+form$")) {
                try {
                    formContent = new String(module.getBytes(fileName), "UTF-8");
                    regex = Pattern.compile("(.{0}|.*/)([^/]*?)\\.form");
                    m = regex.matcher(fileName);
                    key = fileName;
                    while (m.find()) {
                        key = m.group(2);
                    }
                    formsData.put(key + ".form", formContent);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Unsupported encoding while processing form " + fileName);
                }
            }
            if (!fileName.matches(".+class$")) continue;
            String className = fileName.replaceAll("/", ".");
            className = className.substring(0, fileName.length() - ".class".length());
            try {
                deployedUnit.addClass(kieContainer.getClassLoader().loadClass(className));
                logger.debug("Loaded {} into the classpath from deployment {}", (Object)className, (Object)releaseId.toExternalForm());
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Class " + className + " not found in the project");
            }
            catch (NoClassDefFoundError e) {
                throw new IllegalArgumentException("Class " + className + " not found in the project");
            }
        }
    }

    public void setBpmn2Service(DefinitionService bpmn2Service) {
        this.bpmn2Service = bpmn2Service;
    }

    public void setMerger(DeploymentDescriptorMerger merger) {
        this.merger = merger;
    }
}

