/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.security;

import java.util.List;
import org.jbpm.kie.services.api.IdentityProvider;
import org.kie.internal.runtime.manager.SecurityManager;

public class IdentityRolesSecurityManager
implements SecurityManager {
    private IdentityProvider identityProvider;
    private List<String> requiredRoles;

    public IdentityRolesSecurityManager(IdentityProvider identityProvider, List<String> requiredRoles) {
        this.identityProvider = identityProvider;
        this.requiredRoles = requiredRoles;
    }

    public void checkPermission() throws SecurityException {
        if (this.requiredRoles == null || this.requiredRoles.isEmpty()) {
            return;
        }
        List<String> contextRoles = null;
        try {
            contextRoles = this.identityProvider.getRoles();
        }
        catch (Exception e) {
            return;
        }
        if (contextRoles != null) {
            for (String requiredRole : this.requiredRoles) {
                if (!contextRoles.contains(requiredRole) && !this.identityProvider.hasRole(requiredRole)) continue;
                return;
            }
        }
        throw new SecurityException("User " + this.identityProvider.getName() + " does not have permission to access this asset");
    }
}

