/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.store;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.kie.services.impl.store.DeploymentStore;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ListenerSupport;
import org.jbpm.services.api.model.DeploymentUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentSynchronizer
implements DeploymentEventListener {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentSynchronizer.class);
    public static final String DEPLOY_SYNC_INTERVAL = System.getProperty("org.jbpm.deploy.sync.int", "3");
    public static final boolean DEPLOY_SYNC_ENABLED = Boolean.parseBoolean(System.getProperty("org.jbpm.deploy.sync.enabled", "true"));
    private final Map<String, DeploymentUnit> entries = new ConcurrentHashMap<String, DeploymentUnit>();
    private DeploymentStore deploymentStore;
    private DeploymentService deploymentService;
    private Date lastSync = null;

    public boolean isActive() {
        return true;
    }

    public void setDeploymentStore(DeploymentStore deploymentStore) {
        this.deploymentStore = deploymentStore;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
        ((ListenerSupport)this.deploymentService).addListener((DeploymentEventListener)this);
    }

    public synchronized void synchronize() {
        try {
            HashSet<DeploymentUnit> enabledSet = new HashSet();
            HashSet<DeploymentUnit> disabledSet = new HashSet<DeploymentUnit>();
            if (this.lastSync == null) {
                enabledSet = this.deploymentStore.getEnabledDeploymentUnits();
            } else {
                this.deploymentStore.getDeploymentUnitsByDate(this.lastSync, enabledSet, disabledSet);
            }
            logger.debug("About to synchronize deployment units, found new enabled {}, found new disabled {}", enabledSet, disabledSet);
            if (enabledSet != null) {
                for (DeploymentUnit unit : enabledSet) {
                    if (this.entries.containsKey(unit.getIdentifier())) continue;
                    try {
                        logger.debug("New deployment unit to be deployed {}", (Object)unit);
                        this.entries.put(unit.getIdentifier(), unit);
                        this.deploymentService.deploy(unit);
                    }
                    catch (Exception e) {
                        this.entries.remove(unit.getIdentifier());
                        logger.warn("Deployment unit {} failed to deploy due to {}", (Object)e.getMessage());
                    }
                }
            }
            if (disabledSet != null) {
                for (DeploymentUnit unit : disabledSet) {
                    if (!this.entries.containsKey(unit.getIdentifier())) continue;
                    try {
                        logger.debug("Existing deployment unit to be undeployed {}", (Object)unit);
                        this.entries.remove(unit.getIdentifier());
                        this.deploymentService.undeploy(unit);
                    }
                    catch (Exception e) {
                        logger.warn("Deployment unit {} failed to undeploy due to {}", (Object)e.getMessage(), (Object)e);
                        this.entries.put(unit.getIdentifier(), unit);
                        this.deploymentStore.markDeploymentUnitAsObsolete(unit);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.error("Error while synchronizing deployments {}", (Object)e.getMessage());
        }
        this.lastSync = new Date();
    }

    public void onDeploy(DeploymentEvent event) {
        if (event == null || event.getDeployedUnit() == null) {
            return;
        }
        DeploymentUnit unit = event.getDeployedUnit().getDeploymentUnit();
        if (!this.entries.containsKey(unit.getIdentifier())) {
            this.deploymentStore.enableDeploymentUnit(unit);
            this.entries.put(unit.getIdentifier(), unit);
            logger.info("Deployment unit {} stored successfully", (Object)unit);
        }
    }

    public void onUnDeploy(DeploymentEvent event) {
        if (event != null && event.getDeployedUnit() != null) {
            DeploymentUnit unit = event.getDeployedUnit().getDeploymentUnit();
            this.deploymentStore.disableDeploymentUnit(unit);
            this.entries.remove(unit.getIdentifier());
            logger.info("Deployment unit {} removed successfully", (Object)unit);
        }
    }
}

