/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.beans.IntrospectionException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DisabledPropertyReactiveWarning;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.EnumLiteralDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.QualifiedName;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.base.ClassFieldAccessor;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.TypeResolver;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.BuildUtils;
import org.drools.core.factmodel.ClassBuilder;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.EnumClassDefinition;
import org.drools.core.factmodel.EnumLiteralDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.GeneratedFact;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.Traitable;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.HierarchySorter;
import org.drools.core.util.StringUtils;
import org.drools.core.util.asm.ClassFieldInspector;
import org.kie.api.definition.type.ClassReactive;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.Key;
import org.kie.api.definition.type.Modifies;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.definition.type.Role;
import org.kie.api.io.Resource;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.builder.conf.PropertySpecificOption;

public class TypeDeclarationBuilder {
    private final KnowledgeBuilderImpl kbuilder;
    private final Map<String, TypeDeclaration> builtinTypes = new HashMap<String, TypeDeclaration>();
    private Map<String, TypeDeclaration> cacheTypes;
    private final Set<String> generatedTypes = new HashSet<String>();
    private TimeIntervalParser timeParser;

    TypeDeclarationBuilder(KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
        this.initBuiltinTypeDeclarations();
    }

    private void initBuiltinTypeDeclarations() {
        TypeDeclaration colType = new TypeDeclaration("Collection");
        colType.setTypesafe(false);
        colType.setTypeClass(Collection.class);
        this.builtinTypes.put("java.util.Collection", colType);
        TypeDeclaration mapType = new TypeDeclaration("Map");
        mapType.setTypesafe(false);
        mapType.setTypeClass(Map.class);
        this.builtinTypes.put("java.util.Map", mapType);
        TypeDeclaration activationType = new TypeDeclaration("Match");
        activationType.setTypesafe(false);
        activationType.setTypeClass(Match.class);
        this.builtinTypes.put(Match.class.getCanonicalName(), activationType);
        TypeDeclaration thingType = new TypeDeclaration(Thing.class.getSimpleName());
        thingType.setKind(TypeDeclaration.Kind.TRAIT);
        thingType.setTypeClass(Thing.class);
        this.builtinTypes.put(Thing.class.getCanonicalName(), thingType);
    }

    public TypeDeclaration getAndRegisterTypeDeclaration(Class<?> cls, String packageName) {
        if (cls.isPrimitive() || cls.isArray()) {
            return null;
        }
        TypeDeclaration typeDeclaration = this.getCachedTypeDeclaration(cls);
        if (typeDeclaration != null) {
            this.registerTypeDeclaration(packageName, typeDeclaration);
            return typeDeclaration;
        }
        typeDeclaration = this.getExistingTypeDeclaration(cls);
        if (typeDeclaration != null) {
            this.initTypeDeclaration(cls, typeDeclaration);
            return typeDeclaration;
        }
        typeDeclaration = this.createTypeDeclarationForBean(cls);
        this.initTypeDeclaration(cls, typeDeclaration);
        this.registerTypeDeclaration(packageName, typeDeclaration);
        return typeDeclaration;
    }

    private void registerTypeDeclaration(String packageName, TypeDeclaration typeDeclaration) {
        if (typeDeclaration.getNature() == TypeDeclaration.Nature.DECLARATION || packageName.equals(typeDeclaration.getTypeClass().getPackage().getName())) {
            PackageRegistry packageRegistry = this.kbuilder.getPackageRegistry(packageName);
            if (packageRegistry != null) {
                packageRegistry.getPackage().addTypeDeclaration(typeDeclaration);
            } else {
                this.kbuilder.newPackage(new PackageDescr(packageName, ""));
                this.kbuilder.getPackageRegistry(packageName).getPackage().addTypeDeclaration(typeDeclaration);
            }
        }
    }

    TypeDeclaration getTypeDeclaration(Class<?> cls) {
        if (cls.isPrimitive() || cls.isArray()) {
            return null;
        }
        TypeDeclaration tdecl = this.getCachedTypeDeclaration(cls);
        return tdecl != null ? tdecl : this.createTypeDeclaration(cls);
    }

    private TypeDeclaration createTypeDeclaration(Class<?> cls) {
        TypeDeclaration typeDeclaration = this.getExistingTypeDeclaration(cls);
        if (typeDeclaration == null) {
            typeDeclaration = this.createTypeDeclarationForBean(cls);
        }
        this.initTypeDeclaration(cls, typeDeclaration);
        return typeDeclaration;
    }

    private TypeDeclaration getCachedTypeDeclaration(Class<?> cls) {
        if (this.cacheTypes == null) {
            this.cacheTypes = new HashMap<String, TypeDeclaration>();
            return null;
        }
        return this.cacheTypes.get(cls.getName());
    }

    private TypeDeclaration getExistingTypeDeclaration(Class<?> cls) {
        PackageRegistry pkgReg;
        TypeDeclaration typeDeclaration = this.builtinTypes.get(cls.getName());
        if (typeDeclaration == null && (pkgReg = this.kbuilder.getPackageRegistry(ClassUtils.getPackage(cls))) != null) {
            String className = cls.getName();
            String typeName = className.substring(className.lastIndexOf(".") + 1);
            typeDeclaration = pkgReg.getPackage().getTypeDeclaration(typeName);
        }
        return typeDeclaration;
    }

    private void initTypeDeclaration(Class<?> cls, TypeDeclaration typeDeclaration) {
        ClassDefinition clsDef = typeDeclaration.getTypeClassDef();
        if (clsDef == null) {
            clsDef = new ClassDefinition();
            typeDeclaration.setTypeClassDef(clsDef);
        }
        if (typeDeclaration.isPropertyReactive()) {
            this.processModifiedProps(cls, clsDef);
        }
        this.processFieldsPosition(cls, clsDef, typeDeclaration);
        LinkedHashSet<TypeDeclaration> tdecls = new LinkedHashSet<TypeDeclaration>();
        tdecls.add(typeDeclaration);
        this.buildTypeDeclarations(cls, tdecls);
        TypeDeclaration[] tarray = tdecls.toArray(new TypeDeclaration[tdecls.size()]);
        for (int i = tarray.length - 1; i >= 0; --i) {
            TypeDeclaration currentTDecl = tarray[i];
            if (!BitMaskUtil.isSet((long)typeDeclaration.getSetMask(), (long)1L) && BitMaskUtil.isSet((long)currentTDecl.getSetMask(), (long)1L)) {
                typeDeclaration.setRole(currentTDecl.getRole());
            }
            if (!BitMaskUtil.isSet((long)typeDeclaration.getSetMask(), (long)4L) && BitMaskUtil.isSet((long)currentTDecl.getSetMask(), (long)4L)) {
                typeDeclaration.setFormat(currentTDecl.getFormat());
            }
            if (BitMaskUtil.isSet((long)typeDeclaration.getSetMask(), (long)2L) || !BitMaskUtil.isSet((long)currentTDecl.getSetMask(), (long)2L)) continue;
            typeDeclaration.setTypesafe(currentTDecl.isTypesafe());
        }
        this.cacheTypes.put(cls.getName(), typeDeclaration);
    }

    private void processFieldsPosition(Class<?> cls, ClassDefinition clsDef, TypeDeclaration typeDeclaration) {
        LinkedList fields = new LinkedList();
        for (Class<?> tempKlass = cls; tempKlass != null && tempKlass != Object.class; tempKlass = tempKlass.getSuperclass()) {
            Collections.addAll(fields, tempKlass.getDeclaredFields());
        }
        FieldDefinition[] orderedFields = new FieldDefinition[fields.size()];
        for (Field fld : fields) {
            Position pos = fld.getAnnotation(Position.class);
            if (pos == null) continue;
            if (pos.value() < 0 || pos.value() >= fields.size()) {
                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDeclaration, "Out of range position " + pos.value() + " for field '" + fld.getName() + "' on class " + cls.getName()));
                continue;
            }
            if (orderedFields[pos.value()] != null) {
                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDeclaration, "Duplicated position " + pos.value() + " for field '" + fld.getName() + "' on class " + cls.getName()));
                continue;
            }
            FieldDefinition fldDef = clsDef.getField(fld.getName());
            if (fldDef == null) {
                fldDef = new FieldDefinition(fld.getName(), fld.getType().getName());
            }
            fldDef.setIndex(pos.value());
            orderedFields[pos.value()] = fldDef;
        }
        for (FieldDefinition fld : orderedFields) {
            if (fld == null) continue;
            clsDef.addField(fld);
        }
    }

    private void processModifiedProps(Class<?> cls, ClassDefinition clsDef) {
        for (Method method : cls.getDeclaredMethods()) {
            Modifies modifies = method.getAnnotation(Modifies.class);
            if (modifies == null) continue;
            String[] props = modifies.value();
            ArrayList<String> properties = new ArrayList<String>(props.length);
            for (String prop : props) {
                properties.add(prop.trim());
            }
            clsDef.addModifiedPropsByMethod(method, properties);
        }
    }

    private TypeDeclaration createTypeDeclarationForBean(Class<?> cls) {
        TypeDeclaration typeDeclaration = new TypeDeclaration(cls);
        PropertySpecificOption propertySpecificOption = this.kbuilder.getBuilderConfiguration().getOption(PropertySpecificOption.class);
        boolean propertyReactive = propertySpecificOption.isPropSpecific(cls.isAnnotationPresent(PropertyReactive.class), cls.isAnnotationPresent(ClassReactive.class));
        this.setPropertyReactive(null, typeDeclaration, propertyReactive);
        Role role = cls.getAnnotation(Role.class);
        if (role != null && role.value() == Role.Type.EVENT) {
            typeDeclaration.setRole(TypeDeclaration.Role.EVENT);
        }
        return typeDeclaration;
    }

    private void buildTypeDeclarations(Class<?> cls, Set<TypeDeclaration> tdecls) {
        Class<?>[] intfs;
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            this.buildTypeDeclarationInterfaces(intf, tdecls);
        }
        for (cls = cls.getSuperclass(); cls != null && cls != Object.class && this.buildTypeDeclarationInterfaces(cls, tdecls); cls = cls.getSuperclass()) {
        }
    }

    private boolean buildTypeDeclarationInterfaces(Class cls, Set<TypeDeclaration> tdecls) {
        Class<?>[] intfs;
        PackageRegistry pkgReg;
        TypeDeclaration tdecl = this.builtinTypes.get(cls.getName());
        if (tdecl == null && (pkgReg = this.kbuilder.getPackageRegistry(ClassUtils.getPackage((Class)cls))) != null) {
            tdecl = pkgReg.getPackage().getTypeDeclaration(cls.getSimpleName());
        }
        if (tdecl != null && !tdecls.add(tdecl)) {
            return false;
        }
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            pkgReg = this.kbuilder.getPackageRegistry(ClassUtils.getPackage(intf));
            if (pkgReg != null) {
                tdecl = pkgReg.getPackage().getTypeDeclaration(intf.getSimpleName());
            }
            if (tdecl == null) continue;
            tdecls.add(tdecl);
        }
        for (Class<?> intf : intfs) {
            if (this.buildTypeDeclarationInterfaces(intf, tdecls)) continue;
            return false;
        }
        return true;
    }

    private String resolveType(String klass, PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        String arraySuffix = "";
        int arrayIndex = klass.indexOf("[");
        if (arrayIndex >= 0) {
            arraySuffix = klass.substring(arrayIndex);
            klass = klass.substring(0, arrayIndex);
        }
        for (ImportDescr id : packageDescr.getImports()) {
            String fqKlass = id.getTarget();
            if (!fqKlass.endsWith("." + klass)) continue;
            return arrayIndex < 0 ? fqKlass : fqKlass + arraySuffix;
        }
        if (pkgRegistry != null) {
            for (String declaredName : pkgRegistry.getPackage().getTypeDeclarations().keySet()) {
                if (!declaredName.equals(klass)) continue;
                klass = pkgRegistry.getPackage().getTypeDeclaration(declaredName).getTypeClass().getName();
            }
        }
        if (klass != null && !klass.contains(".") && packageDescr.getNamespace() != null && !packageDescr.getNamespace().isEmpty()) {
            for (AbstractClassTypeDeclarationDescr td : packageDescr.getClassAndEnumDeclarationDescrs()) {
                if (!klass.equals(td.getTypeName())) continue;
                if (td.getType().getFullName().contains(".")) {
                    klass = td.getType().getFullName();
                    continue;
                }
                klass = packageDescr.getNamespace() + "." + klass;
            }
        }
        return arrayIndex < 0 ? klass : klass + arraySuffix;
    }

    private void fillSuperType(TypeDeclarationDescr typeDescr, PackageDescr packageDescr) {
        for (QualifiedName qname : typeDescr.getSuperTypes()) {
            int separator;
            boolean qualified;
            String declaredSuperType = qname.getFullName();
            if (declaredSuperType == null || (qualified = (separator = declaredSuperType.lastIndexOf(".")) > 0)) continue;
            declaredSuperType = this.resolveType(declaredSuperType, packageDescr, this.kbuilder.getPackageRegistry(typeDescr.getNamespace()));
            separator = (declaredSuperType = this.typeName2ClassName(declaredSuperType)).lastIndexOf(".");
            if (separator < 0) {
                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Cannot resolve supertype '" + declaredSuperType + "'"));
                qname.setName(null);
                qname.setNamespace(null);
                continue;
            }
            qname.setName(declaredSuperType.substring(separator + 1));
            qname.setNamespace(declaredSuperType.substring(0, separator));
        }
    }

    private String typeName2ClassName(String type) {
        Class<?> cls = this.getClassForType(type);
        return cls != null ? cls.getName() : type;
    }

    private Class<?> getClassForType(String type) {
        Class<?> cls = null;
        String superType = type;
        while (true) {
            try {
                cls = Class.forName(superType, true, this.kbuilder.getRootClassLoader());
            }
            catch (ClassNotFoundException e) {
                int separator = superType.lastIndexOf(46);
                if (separator < 0) break;
                superType = superType.substring(0, separator) + "$" + superType.substring(separator + 1);
                continue;
            }
            break;
        }
        return cls;
    }

    public void fillFieldTypes(AbstractClassTypeDeclarationDescr typeDescr, PackageDescr packageDescr) {
        for (TypeFieldDescr field : typeDescr.getFields().values()) {
            int separator;
            boolean qualified;
            String declaredType = field.getPattern().getObjectType();
            if (declaredType == null || (qualified = (separator = declaredType.lastIndexOf(".")) > 0)) continue;
            declaredType = this.resolveType(declaredType, packageDescr, this.kbuilder.getPackageRegistry(typeDescr.getNamespace()));
            field.getPattern().setObjectType(declaredType);
        }
    }

    private boolean mergeInheritedFields(TypeDeclarationDescr typeDescr, List<TypeDefinition> unresolvedTypes, Map<String, TypeDeclarationDescr> unprocessableDescrs, TypeResolver typeResolver) {
        if (typeDescr.getSuperTypes().isEmpty()) {
            return false;
        }
        boolean merge = false;
        for (int j = typeDescr.getSuperTypes().size() - 1; j >= 0; --j) {
            String fullSuper;
            String superTypePackageName;
            QualifiedName qname = typeDescr.getSuperTypes().get(j);
            String simpleSuperTypeName = qname.getName();
            merge = this.mergeFields(simpleSuperTypeName, superTypePackageName = qname.getNamespace(), fullSuper = qname.getFullName(), typeDescr, unresolvedTypes, unprocessableDescrs, typeResolver) || merge;
        }
        return merge;
    }

    private boolean mergeFields(String simpleSuperTypeName, String superTypePackageName, String fullSuper, TypeDeclarationDescr typeDescr, List<TypeDefinition> unresolvedTypes, Map<String, TypeDeclarationDescr> unprocessableDescrs, TypeResolver resolver) {
        TypeFieldDescr inheritedFlDescr;
        LinkedHashMap<String, TypeFieldDescr> fieldMap = new LinkedHashMap<String, TypeFieldDescr>();
        boolean isNovel = this.isNovelClass(typeDescr);
        PackageRegistry registry = this.kbuilder.getPackageRegistry(superTypePackageName);
        InternalKnowledgePackage pack = null;
        if (registry != null) {
            pack = registry.getPackage();
        } else if (isNovel) {
            unprocessableDescrs.put(typeDescr.getType().getFullName(), typeDescr);
            return false;
        }
        if (unprocessableDescrs.containsKey(fullSuper)) {
            unprocessableDescrs.put(typeDescr.getType().getFullName(), typeDescr);
            return false;
        }
        boolean isSuperClassTagged = false;
        boolean isSuperClassDeclared = true;
        if (pack != null) {
            TypeDeclaration superTypeDeclaration = pack.getTypeDeclaration(simpleSuperTypeName);
            if (superTypeDeclaration != null && superTypeDeclaration.getTypeClassDef() != null) {
                ClassDefinition classDef = superTypeDeclaration.getTypeClassDef();
                for (FactField fld : classDef.getFields()) {
                    inheritedFlDescr = this.buildInheritedFieldDescrFromDefinition(fld, typeDescr);
                    fieldMap.put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
                }
                isSuperClassTagged = !superTypeDeclaration.isNovel();
            } else {
                for (TypeDefinition def : unresolvedTypes) {
                    if (def.getTypeClassName().equals(fullSuper)) {
                        TypeDeclarationDescr td = (TypeDeclarationDescr)def.typeDescr;
                        for (TypeFieldDescr tf : td.getFields().values()) {
                            fieldMap.put(tf.getFieldName(), tf.cloneAsInherited());
                        }
                        isSuperClassDeclared = def.type.isNovel();
                        break;
                    }
                    isSuperClassDeclared = false;
                }
            }
        } else {
            isSuperClassDeclared = false;
        }
        if (!isSuperClassDeclared || isSuperClassTagged) {
            try {
                Class superKlass = registry != null ? registry.getTypeResolver().resolveType(fullSuper) : resolver.resolveType(fullSuper);
                ClassFieldInspector inspector = new ClassFieldInspector(superKlass);
                for (String name : inspector.getGetterMethods().keySet()) {
                    if (!inspector.getSetterMethods().containsKey(name) || inspector.isNonGetter(name) || "class".equals(name)) continue;
                    inheritedFlDescr = new TypeFieldDescr(name, new PatternDescr(((Class)inspector.getFieldTypes().get(name)).getName()));
                    inheritedFlDescr.setInherited(!Modifier.isAbstract(((Method)inspector.getGetterMethods().get(name)).getModifiers()));
                    if (fieldMap.containsKey(inheritedFlDescr.getFieldName())) continue;
                    fieldMap.put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Unable to resolve Type Declaration superclass '" + fullSuper + "'");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        for (String fieldName : typeDescr.getFields().keySet()) {
            if (fieldMap.containsKey(fieldName)) {
                String type1 = ((TypeFieldDescr)fieldMap.get(fieldName)).getPattern().getObjectType();
                String type2 = typeDescr.getFields().get(fieldName).getPattern().getObjectType();
                if (type2.lastIndexOf(".") < 0) {
                    try {
                        TypeResolver typeResolver = this.kbuilder.getPackageRegistry(pack.getName()).getTypeResolver();
                        type1 = typeResolver.resolveType(type1).getName();
                        type2 = typeResolver.resolveType(type2).getName();
                        ((TypeFieldDescr)fieldMap.get(fieldName)).getPattern().setObjectType(type1);
                        typeDescr.getFields().get(fieldName).getPattern().setObjectType(type2);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                if (!type1.equals(type2)) {
                    this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Cannot redeclare field '" + fieldName + " from " + type1 + " to " + type2));
                    typeDescr.setType(null, null);
                    return false;
                }
                String initVal = ((TypeFieldDescr)fieldMap.get(fieldName)).getInitExpr();
                if (typeDescr.getFields().get(fieldName).getInitExpr() == null) {
                    typeDescr.getFields().get(fieldName).setInitExpr(initVal);
                }
                typeDescr.getFields().get(fieldName).setInherited(((TypeFieldDescr)fieldMap.get(fieldName)).isInherited());
                for (String key : ((TypeFieldDescr)fieldMap.get(fieldName)).getAnnotationNames()) {
                    if (typeDescr.getFields().get(fieldName).getAnnotation(key) != null) continue;
                    typeDescr.getFields().get(fieldName).addAnnotation(((TypeFieldDescr)fieldMap.get(fieldName)).getAnnotation(key));
                }
                if (typeDescr.getFields().get(fieldName).getIndex() < 0) {
                    typeDescr.getFields().get(fieldName).setIndex(((TypeFieldDescr)fieldMap.get(fieldName)).getIndex());
                }
            }
            fieldMap.put(fieldName, typeDescr.getFields().get(fieldName));
        }
        typeDescr.setFields(fieldMap);
        return true;
    }

    protected TypeFieldDescr buildInheritedFieldDescrFromDefinition(FactField fld, TypeDeclarationDescr typeDescr) {
        PatternDescr fldType = new PatternDescr();
        TypeFieldDescr inheritedFldDescr = new TypeFieldDescr();
        inheritedFldDescr.setFieldName(fld.getName());
        if (((FieldDefinition)fld).getFieldAccessor() != null) {
            fldType.setObjectType(((FieldDefinition)fld).getFieldAccessor().getExtractToClassName());
        }
        inheritedFldDescr.setPattern(fldType);
        if (fld.isKey()) {
            inheritedFldDescr.getAnnotations().put("key", new AnnotationDescr("key"));
        }
        inheritedFldDescr.setIndex(((FieldDefinition)fld).getDeclIndex());
        inheritedFldDescr.setInherited(true);
        String initExprOverride = ((FieldDefinition)fld).getInitExpr();
        int overrideCount = 0;
        for (TypeFieldDescr localField : typeDescr.getFields().values()) {
            AnnotationDescr ann = localField.getAnnotation("Alias");
            if (ann == null || !fld.getName().equals(ann.getSingleValue().replaceAll("\"", "")) || localField.getInitExpr() == null) continue;
            ++overrideCount;
            initExprOverride = localField.getInitExpr();
        }
        if (overrideCount > 1) {
            initExprOverride = null;
        }
        inheritedFldDescr.setInitExpr(initExprOverride);
        return inheritedFldDescr;
    }

    void processTypes(PackageRegistry pkgRegistry, PackageDescr packageDescr, Map<String, TypeDeclarationDescr> unprocessableDescrs) {
        this.processUnresolvedTypes(pkgRegistry, this.processTypeDeclarations(pkgRegistry, packageDescr, new ArrayList<TypeDefinition>(), unprocessableDescrs));
    }

    void processUnresolvedTypes(PackageRegistry pkgRegistry, List<TypeDefinition> unresolvedTypeDefinitions) {
        if (unresolvedTypeDefinitions != null) {
            for (TypeDefinition typeDef : unresolvedTypeDefinitions) {
                this.processUnresolvedType(pkgRegistry, typeDef);
            }
        }
    }

    void processUnresolvedType(PackageRegistry pkgRegistry, TypeDefinition unresolvedTypeDefinition) {
        this.processTypeFields(pkgRegistry, unresolvedTypeDefinition.typeDescr, unresolvedTypeDefinition.type, false);
    }

    private boolean processTypeFields(PackageRegistry pkgRegistry, AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, boolean firstAttempt) {
        String expiration;
        String duration;
        AnnotationDescr annotationDescr;
        String timestamp;
        if (type.getTypeClassDef() != null) {
            try {
                this.buildFieldAccessors(type, pkgRegistry);
            }
            catch (Throwable e) {
                if (!firstAttempt) {
                    this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Error creating field accessors for TypeDeclaration '" + type.getTypeName() + "' for type '" + type.getTypeName() + " : " + e.getMessage() + "'"));
                }
                return false;
            }
        }
        String string = timestamp = (annotationDescr = typeDescr.getAnnotation("timestamp")) != null ? annotationDescr.getSingleValue() : null;
        if (timestamp != null) {
            MVELAnalysisResult results;
            type.setTimestampAttribute(timestamp);
            InternalKnowledgePackage pkg = pkgRegistry.getPackage();
            MVELDialect dialect = (MVELDialect)pkgRegistry.getDialectCompiletimeRegistry().getDialect("mvel");
            PackageBuildContext context = new PackageBuildContext();
            context.init(this.kbuilder, pkg, typeDescr, pkgRegistry.getDialectCompiletimeRegistry(), dialect, null);
            if (!type.isTypesafe()) {
                context.setTypesafe(false);
            }
            if ((results = (MVELAnalysisResult)context.getDialect().analyzeExpression(context, typeDescr, timestamp, new BoundIdentifiers(Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, type.getTypeClass()))) != null) {
                InternalReadAccessor reader = pkg.getClassFieldAccessorStore().getMVELReader(ClassUtils.getPackage((Class)type.getTypeClass()), type.getTypeClass().getName(), timestamp, type.isTypesafe(), results.getReturnType());
                MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("mvel");
                data.addCompileable((MVELCompileable)reader);
                ((MVELCompileable)reader).compile(data);
                type.setTimestampExtractor(reader);
            } else {
                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Error creating field accessors for timestamp field '" + timestamp + "' for type '" + type.getTypeName() + "'"));
            }
        }
        String string2 = duration = (annotationDescr = typeDescr.getAnnotation("duration")) != null ? annotationDescr.getSingleValue() : null;
        if (duration != null) {
            MVELAnalysisResult results;
            type.setDurationAttribute(duration);
            InternalKnowledgePackage pkg = pkgRegistry.getPackage();
            MVELDialect dialect = (MVELDialect)pkgRegistry.getDialectCompiletimeRegistry().getDialect("mvel");
            PackageBuildContext context = new PackageBuildContext();
            context.init(this.kbuilder, pkg, typeDescr, pkgRegistry.getDialectCompiletimeRegistry(), dialect, null);
            if (!type.isTypesafe()) {
                context.setTypesafe(false);
            }
            if ((results = (MVELAnalysisResult)context.getDialect().analyzeExpression(context, typeDescr, duration, new BoundIdentifiers(Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, type.getTypeClass()))) != null) {
                InternalReadAccessor reader = pkg.getClassFieldAccessorStore().getMVELReader(ClassUtils.getPackage((Class)type.getTypeClass()), type.getTypeClass().getName(), duration, type.isTypesafe(), results.getReturnType());
                MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("mvel");
                data.addCompileable((MVELCompileable)reader);
                ((MVELCompileable)reader).compile(data);
                type.setDurationExtractor(reader);
            } else {
                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Error processing @duration for TypeDeclaration '" + type.getFullName() + "': cannot access the field '" + duration + "'"));
            }
        }
        String string3 = expiration = (annotationDescr = typeDescr.getAnnotation("expires")) != null ? annotationDescr.getSingleValue() : null;
        if (expiration != null) {
            if (this.timeParser == null) {
                this.timeParser = new TimeIntervalParser();
            }
            type.setExpirationOffset(this.timeParser.parse(expiration)[0].longValue());
        }
        boolean dynamic = typeDescr.getAnnotationNames().contains("propertyChangeSupport");
        type.setDynamic(dynamic);
        PropertySpecificOption propertySpecificOption = this.kbuilder.getBuilderConfiguration().getOption(PropertySpecificOption.class);
        boolean propertyReactive = propertySpecificOption.isPropSpecific(typeDescr.getAnnotationNames().contains("propertyReactive"), typeDescr.getAnnotationNames().contains("classReactive"));
        this.setPropertyReactive(typeDescr.getResource(), type, propertyReactive);
        if (type.isValid()) {
            if (type.getNature() == TypeDeclaration.Nature.DEFINITION) {
                pkgRegistry.getPackage().addTypeDeclaration(type);
            } else {
                TypeDeclaration oldType = pkgRegistry.getPackage().getTypeDeclaration(type.getTypeName());
                if (oldType == null) {
                    pkgRegistry.getPackage().addTypeDeclaration(type);
                } else {
                    if (type.getRole() == TypeDeclaration.Role.EVENT) {
                        oldType.setRole(TypeDeclaration.Role.EVENT);
                        if (type.getDurationAttribute() != null) {
                            oldType.setDurationAttribute(type.getDurationAttribute());
                            oldType.setDurationExtractor(type.getDurationExtractor());
                        }
                        if (type.getTimestampAttribute() != null) {
                            oldType.setTimestampAttribute(type.getTimestampAttribute());
                            oldType.setTimestampExtractor(type.getTimestampExtractor());
                        }
                        if (type.getExpirationOffset() >= 0L) {
                            oldType.setExpirationOffset(type.getExpirationOffset());
                        }
                    }
                    if (type.isPropertyReactive()) {
                        oldType.setPropertyReactive(true);
                    }
                }
            }
        }
        return true;
    }

    private void buildFieldAccessors(TypeDeclaration type, PackageRegistry pkgRegistry) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, IOException, IntrospectionException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        ClassDefinition cd = type.getTypeClassDef();
        ClassFieldAccessorStore store = pkgRegistry.getPackage().getClassFieldAccessorStore();
        for (FieldDefinition attrDef : cd.getFieldsDefinitions()) {
            ClassFieldAccessor accessor = store.getAccessor(cd.getDefinedClass().getName(), attrDef.getName());
            attrDef.setReadWriteAccessor(accessor);
        }
    }

    private void setPropertyReactive(Resource resource, TypeDeclaration type, boolean propertyReactive) {
        if (propertyReactive && type.getSettableProperties().size() >= 64) {
            this.kbuilder.addBuilderResult(new DisabledPropertyReactiveWarning(resource, type.getTypeName()));
            type.setPropertyReactive(false);
        } else {
            type.setPropertyReactive(propertyReactive);
        }
    }

    void removeTypesGeneratedFromResource(Resource resource) {
        if (this.cacheTypes != null) {
            ArrayList typesToBeRemoved = new ArrayList();
            for (Map.Entry<String, TypeDeclaration> type : this.cacheTypes.entrySet()) {
                if (!resource.equals(type.getValue().getResource())) continue;
                typesToBeRemoved.add(type.getKey());
            }
            for (Map.Entry<String, TypeDeclaration> type : typesToBeRemoved) {
                this.cacheTypes.remove(type);
            }
        }
    }

    List<TypeDefinition> processTypeDeclarations(PackageRegistry pkgRegistry, PackageDescr packageDescr, List<TypeDefinition> unresolvedTypes, Map<String, TypeDeclarationDescr> unprocessableDescrs) {
        HashMap<String, PackageDescr> foreignPackages = null;
        for (AbstractClassTypeDeclarationDescr typeDescr : packageDescr.getClassAndEnumDeclarationDescrs()) {
            PackageDescr altDescr;
            PackageRegistry pkgReg;
            String className;
            int dotPos;
            String qName = typeDescr.getType().getFullName();
            Class<?> typeClass = this.getClassForType(qName);
            if (typeClass == null) {
                typeClass = this.getClassForType(typeDescr.getTypeName());
            }
            if (typeClass == null) {
                for (ImportDescr id : packageDescr.getImports()) {
                    int separator;
                    String imp = id.getTarget();
                    String tail = imp.substring((separator = imp.lastIndexOf(46)) + 1);
                    if (tail.equals(typeDescr.getTypeName())) {
                        typeDescr.setNamespace(imp.substring(0, separator));
                        typeClass = this.getClassForType(typeDescr.getType().getFullName());
                        break;
                    }
                    if (!tail.equals("*") || (typeClass = this.getClassForType(imp.substring(0, imp.length() - 1) + typeDescr.getType().getName())) == null) continue;
                    String resolvedNamespace = imp.substring(0, separator);
                    if (resolvedNamespace.equals(typeDescr.getNamespace())) break;
                    if (this.isCompatible(typeClass, typeDescr)) {
                        typeDescr.setNamespace(resolvedNamespace);
                        continue;
                    }
                    typeClass = null;
                }
            }
            if ((dotPos = (className = typeClass != null ? typeClass.getName() : qName).lastIndexOf(46)) >= 0) {
                typeDescr.setNamespace(className.substring(0, dotPos));
                typeDescr.setTypeName(className.substring(dotPos + 1));
            }
            if (StringUtils.isEmpty((CharSequence)typeDescr.getNamespace()) && typeDescr.getFields().isEmpty() && (pkgReg = this.kbuilder.getPackageRegistry(packageDescr.getName())) != null) {
                try {
                    Class clz = pkgReg.getTypeResolver().resolveType(typeDescr.getTypeName());
                    Package pkg = clz.getPackage();
                    if (pkg != null) {
                        typeDescr.setNamespace(pkg.getName());
                        int index = typeDescr.getNamespace() != null && !typeDescr.getNamespace().isEmpty() ? typeDescr.getNamespace().length() + 1 : 0;
                        typeDescr.setTypeName(clz.getCanonicalName().substring(index));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty((CharSequence)typeDescr.getNamespace())) {
                typeDescr.setNamespace(packageDescr.getNamespace());
            }
            if (typeDescr instanceof TypeDeclarationDescr) {
                this.fillSuperType((TypeDeclarationDescr)typeDescr, packageDescr);
                AnnotationDescr kind = typeDescr.getAnnotation("kind");
                if (typeClass != null && kind != null && kind.hasValue() && TypeDeclaration.Kind.TRAIT == TypeDeclaration.Kind.parseKind((String)kind.getSingleValue())) {
                    this.fillStaticInterfaces((TypeDeclarationDescr)typeDescr, typeClass);
                }
            }
            this.fillFieldTypes(typeDescr, packageDescr);
            if (typeDescr.getNamespace().equals(packageDescr.getNamespace())) continue;
            if (foreignPackages == null) {
                foreignPackages = new HashMap<String, PackageDescr>();
            }
            if (foreignPackages.containsKey(typeDescr.getNamespace())) {
                altDescr = (PackageDescr)foreignPackages.get(typeDescr.getNamespace());
            } else {
                altDescr = new PackageDescr(typeDescr.getNamespace());
                foreignPackages.put(typeDescr.getNamespace(), altDescr);
            }
            if (typeDescr instanceof TypeDeclarationDescr) {
                altDescr.addTypeDeclaration((TypeDeclarationDescr)typeDescr);
            } else if (typeDescr instanceof EnumDeclarationDescr) {
                altDescr.addEnumDeclaration((EnumDeclarationDescr)typeDescr);
            }
            for (ImportDescr imp : packageDescr.getImports()) {
                altDescr.addImport(imp);
            }
            if (this.kbuilder.getPackageRegistry().containsKey(altDescr.getNamespace())) continue;
            this.kbuilder.newPackage(altDescr);
        }
        if (foreignPackages != null) {
            for (String ns : foreignPackages.keySet()) {
                this.kbuilder.mergePackage(this.kbuilder.getPackageRegistry(ns), (PackageDescr)foreignPackages.get(ns));
            }
            foreignPackages.clear();
        }
        Collection<AbstractClassTypeDeclarationDescr> sortedTypeDescriptors = TypeDeclarationBuilder.sortByHierarchy(this.kbuilder, packageDescr.getClassAndEnumDeclarationDescrs());
        for (AbstractClassTypeDeclarationDescr typeDescr : sortedTypeDescriptors) {
            this.registerGeneratedType(typeDescr);
        }
        if (this.kbuilder.hasErrors()) {
            return Collections.emptyList();
        }
        for (AbstractClassTypeDeclarationDescr typeDescr : sortedTypeDescriptors) {
            if (!typeDescr.getNamespace().equals(packageDescr.getNamespace())) continue;
            this.processTypeDeclaration(pkgRegistry, typeDescr, sortedTypeDescriptors, unresolvedTypes, unprocessableDescrs);
        }
        return unresolvedTypes;
    }

    private void fillStaticInterfaces(TypeDeclarationDescr typeDescr, Class<?> typeClass) {
        for (Class iKlass : ClassUtils.getAllImplementedInterfaceNames(typeClass)) {
            typeDescr.addSuperType(iKlass.getName());
        }
    }

    public void processTypeDeclaration(PackageRegistry pkgRegistry, AbstractClassTypeDeclarationDescr typeDescr, Collection<AbstractClassTypeDeclarationDescr> sortedTypeDescriptors, List<TypeDefinition> unresolvedTypes, Map<String, TypeDeclarationDescr> unprocessableDescrs) {
        String className;
        String kind;
        String format;
        String typesafe;
        AnnotationDescr annotationDescr;
        String role;
        PackageRegistry sup;
        if (typeDescr instanceof TypeDeclarationDescr) {
            TypeDeclarationDescr tDescr = (TypeDeclarationDescr)typeDescr;
            boolean isNovel = this.isNovelClass(typeDescr);
            boolean inferFields = !isNovel && typeDescr.getFields().isEmpty();
            block4: for (QualifiedName qname : tDescr.getSuperTypes()) {
                if (!this.mergeInheritedFields(tDescr, unresolvedTypes, unprocessableDescrs, pkgRegistry.getTypeResolver())) continue;
                for (AbstractClassTypeDeclarationDescr descr : sortedTypeDescriptors) {
                    if (qname.equals(descr.getType())) {
                        typeDescr.getAnnotations().putAll(descr.getAnnotations());
                        continue block4;
                    }
                    if (!typeDescr.getType().equals(descr.getType())) continue;
                    continue block4;
                }
            }
            if (inferFields) {
                try {
                    Class<?> existingClass = this.getExistingDeclarationClass(typeDescr);
                    ClassFieldInspector inspector = new ClassFieldInspector(existingClass);
                    for (String name : inspector.getGetterMethods().keySet()) {
                        if (!inspector.getSetterMethods().containsKey(name) || inspector.isNonGetter(name) || "class".equals(name)) continue;
                        TypeFieldDescr inheritedFlDescr = new TypeFieldDescr(name, new PatternDescr(((Class)inspector.getFieldTypes().get(name)).getName()));
                        inheritedFlDescr.setInherited(!Modifier.isAbstract(((Method)inspector.getGetterMethods().get(name)).getModifiers()));
                        if (tDescr.getFields().containsKey(inheritedFlDescr.getFieldName())) continue;
                        tDescr.getFields().put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (unprocessableDescrs.containsKey(typeDescr.getType().getFullName())) {
            return;
        }
        TypeDeclaration type = new TypeDeclaration(typeDescr.getTypeName());
        if (typeDescr.getResource() == null) {
            typeDescr.setResource(this.kbuilder.getCurrentResource());
        }
        type.setResource(typeDescr.getResource());
        TypeDeclaration parent = null;
        if (!typeDescr.getSuperTypes().isEmpty() && (sup = this.kbuilder.getPackageRegistry(typeDescr.getSuperTypeNamespace())) != null) {
            parent = sup.getPackage().getTypeDeclaration(typeDescr.getSuperTypeName());
            if (parent == null) {
                for (TypeDefinition tdef : unresolvedTypes) {
                    if (!tdef.getTypeClassName().equals(typeDescr.getSuperTypes().get(0).getFullName())) continue;
                    parent = tdef.type;
                }
            }
            if (parent != null && parent.getNature() == TypeDeclaration.Nature.DECLARATION && this.kbuilder.getKnowledgeBase() != null) {
                parent = ((InternalKnowledgePackage)this.kbuilder.getKnowledgeBase().getPackagesMap().get(typeDescr.getSuperTypeNamespace())).getTypeDeclaration(typeDescr.getSuperTypeName());
            }
        }
        String string = role = (annotationDescr = this.getSingleAnnotation(typeDescr, "role")) != null ? annotationDescr.getSingleValue() : null;
        if (role != null) {
            type.setRole(TypeDeclaration.Role.parseRole((String)role));
        } else if (parent != null) {
            type.setRole(parent.getRole());
        }
        annotationDescr = this.getSingleAnnotation(typeDescr, "typesafe");
        String string2 = typesafe = annotationDescr != null ? annotationDescr.getSingleValue() : null;
        if (typesafe != null) {
            type.setTypesafe(Boolean.parseBoolean(typesafe));
        } else if (parent != null && BitMaskUtil.isSet((long)parent.getSetMask(), (long)2L)) {
            type.setTypesafe(parent.isTypesafe());
        }
        annotationDescr = this.getSingleAnnotation(typeDescr, "format");
        String string3 = format = annotationDescr != null ? annotationDescr.getSingleValue() : null;
        if (format != null) {
            type.setFormat(TypeDeclaration.Format.parseFormat((String)format));
        }
        String string4 = kind = (annotationDescr = this.getSingleAnnotation(typeDescr, "kind")) != null ? annotationDescr.getSingleValue() : null;
        if (kind != null) {
            type.setKind(TypeDeclaration.Kind.parseKind((String)kind));
        }
        if (typeDescr instanceof EnumDeclarationDescr) {
            type.setKind(TypeDeclaration.Kind.ENUM);
        }
        String string5 = className = (annotationDescr = this.getSingleAnnotation(typeDescr, "class")) != null ? annotationDescr.getSingleValue() : null;
        if (StringUtils.isEmpty((CharSequence)className)) {
            className = type.getTypeName();
        }
        try {
            this.generateDeclaredBean(typeDescr, type, pkgRegistry, unresolvedTypes);
            Class clazz = pkgRegistry.getTypeResolver().resolveType(typeDescr.getType().getFullName());
            type.setTypeClass(clazz);
        }
        catch (ClassNotFoundException e) {
            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Class '" + className + "' not found for type declaration of '" + type.getTypeName() + "'"));
            return;
        }
        if (!this.processTypeFields(pkgRegistry, typeDescr, type, true)) {
            unresolvedTypes.add(new TypeDefinition(type, typeDescr));
        }
    }

    private AnnotationDescr getSingleAnnotation(AbstractClassTypeDeclarationDescr typeDescr, String name) {
        AnnotationDescr annotationDescr = typeDescr.getAnnotation(name);
        if (annotationDescr != null && annotationDescr.isDuplicated()) {
            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Duplicated annotation '" + name + "' for type declaration of '" + typeDescr.getTypeName() + "'"));
            return null;
        }
        return annotationDescr;
    }

    public static Collection<AbstractClassTypeDeclarationDescr> sortByHierarchy(KnowledgeBuilderImpl kbuilder, Collection<? extends AbstractClassTypeDeclarationDescr> typeDeclarations) {
        HashMap<QualifiedName, Collection<QualifiedName>> taxonomy = new HashMap<QualifiedName, Collection<QualifiedName>>();
        HashMap<QualifiedName, AbstractClassTypeDeclarationDescr> cache = new HashMap<QualifiedName, AbstractClassTypeDeclarationDescr>();
        for (AbstractClassTypeDeclarationDescr abstractClassTypeDeclarationDescr : typeDeclarations) {
            QualifiedName name = abstractClassTypeDeclarationDescr.getType();
            cache.put(name, abstractClassTypeDeclarationDescr);
            if (taxonomy.get(name) == null) {
                taxonomy.put(name, new ArrayList());
            } else {
                kbuilder.addBuilderResult(new TypeDeclarationError(abstractClassTypeDeclarationDescr, "Found duplicate declaration for type " + abstractClassTypeDeclarationDescr.getType()));
            }
            Collection supers = (Collection)taxonomy.get(name);
            boolean circular = false;
            for (QualifiedName sup : abstractClassTypeDeclarationDescr.getSuperTypes()) {
                if (Object.class.getName().equals(name.getFullName())) continue;
                if (!TypeDeclarationBuilder.hasCircularDependency(abstractClassTypeDeclarationDescr.getType(), sup, taxonomy)) {
                    supers.add(sup);
                    continue;
                }
                circular = true;
                kbuilder.addBuilderResult(new TypeDeclarationError(abstractClassTypeDeclarationDescr, "Found circular dependency for type " + abstractClassTypeDeclarationDescr.getTypeName()));
                break;
            }
            if (circular) {
                abstractClassTypeDeclarationDescr.getSuperTypes().clear();
            }
            for (TypeFieldDescr field : abstractClassTypeDeclarationDescr.getFields().values()) {
                QualifiedName typeName = new QualifiedName(field.getPattern().getObjectType());
                if (TypeDeclarationBuilder.hasCircularDependency(name, typeName, taxonomy)) continue;
                supers.add(typeName);
            }
        }
        List sorted = new HierarchySorter().sort(taxonomy);
        ArrayList<AbstractClassTypeDeclarationDescr> arrayList = new ArrayList<AbstractClassTypeDeclarationDescr>(sorted.size());
        for (QualifiedName name : sorted) {
            arrayList.add((AbstractClassTypeDeclarationDescr)cache.get(name));
        }
        return arrayList;
    }

    private static boolean hasCircularDependency(QualifiedName name, QualifiedName typeName, Map<QualifiedName, Collection<QualifiedName>> taxonomy) {
        if (name.equals(typeName)) {
            return true;
        }
        if (taxonomy.containsKey(typeName)) {
            Collection<QualifiedName> parents = taxonomy.get(typeName);
            if (parents.contains(name)) {
                return true;
            }
            for (QualifiedName ancestor : parents) {
                if (!TypeDeclarationBuilder.hasCircularDependency(name, ancestor, taxonomy)) continue;
                return true;
            }
        }
        return false;
    }

    private Class resolveAnnotation(String annotation, TypeResolver resolver) {
        if ("format".equals(annotation)) {
            return null;
        }
        if ("class".equals(annotation)) {
            return null;
        }
        try {
            return resolver.resolveType(annotation.indexOf(46) < 0 ? annotation.substring(0, 1).toUpperCase() + annotation.substring(1) : annotation);
        }
        catch (ClassNotFoundException e) {
            if ("role".equals(annotation)) {
                return Role.class;
            }
            if ("key".equals(annotation)) {
                return Key.class;
            }
            if ("position".equals(annotation)) {
                return Position.class;
            }
            return null;
        }
    }

    private PriorityQueue<FieldDefinition> sortFields(Map<String, TypeFieldDescr> flds, PackageRegistry pkgRegistry) {
        PriorityQueue<FieldDefinition> queue = new PriorityQueue<FieldDefinition>(flds.size());
        int maxDeclaredPos = 0;
        int curr = 0;
        BitSet occupiedPositions = new BitSet(flds.size());
        for (TypeFieldDescr field : flds.values()) {
            int pos = field.getIndex();
            if (pos >= 0) {
                occupiedPositions.set(pos);
            }
            maxDeclaredPos = Math.max(maxDeclaredPos, pos);
        }
        for (TypeFieldDescr field : flds.values()) {
            try {
                String typeName;
                String typeNameKey = typeName = field.getPattern().getObjectType();
                int arrayIndex = typeName.indexOf("[");
                if (arrayIndex >= 0) {
                    typeNameKey = typeName.substring(0, arrayIndex);
                }
                String fullFieldType = this.generatedTypes.contains(typeNameKey) ? BuildUtils.resolveDeclaredType((String)typeName) : pkgRegistry.getTypeResolver().resolveType(typeName).getName();
                FieldDefinition fieldDef = new FieldDefinition(field.getFieldName(), fullFieldType);
                boolean isKey = field.getAnnotation("key") != null;
                fieldDef.setKey(isKey);
                fieldDef.setDeclIndex(field.getIndex());
                if (field.getIndex() < 0) {
                    int freePos = occupiedPositions.nextClearBit(0);
                    if (freePos < maxDeclaredPos) {
                        occupiedPositions.set(freePos);
                    } else {
                        freePos = maxDeclaredPos + 1;
                    }
                    fieldDef.setPriority(freePos * 256 + curr++);
                } else {
                    fieldDef.setPriority(field.getIndex() * 256 + curr++);
                }
                fieldDef.setInherited(field.isInherited());
                fieldDef.setInitExpr(field.getInitExpr());
                for (String annotationName : field.getAnnotationNames()) {
                    Class annotation = this.resolveAnnotation(annotationName, pkgRegistry.getTypeResolver());
                    if (annotation != null && annotation.isAnnotation()) {
                        try {
                            AnnotationDefinition annotationDefinition = AnnotationDefinition.build((Class)annotation, field.getAnnotations().get(annotationName).getValueMap(), (TypeResolver)pkgRegistry.getTypeResolver());
                            fieldDef.addAnnotation(annotationDefinition);
                        }
                        catch (NoSuchMethodException nsme) {
                            this.kbuilder.addBuilderResult(new TypeDeclarationError(field, "Annotated field " + field.getFieldName() + "  - undefined property in @annotation " + annotationName + ": " + nsme.getMessage() + ";"));
                        }
                    }
                    if (annotation != null && annotation != Key.class && annotation != Position.class) continue;
                    fieldDef.addMetaData(annotationName, (Object)field.getAnnotation(annotationName).getSingleValue());
                }
                queue.add(fieldDef);
            }
            catch (ClassNotFoundException cnfe) {
                this.kbuilder.addBuilderResult(new TypeDeclarationError(field, cnfe.getMessage()));
            }
        }
        return queue;
    }

    void registerGeneratedType(AbstractClassTypeDeclarationDescr typeDescr) {
        String fullName = typeDescr.getType().getFullName();
        this.generatedTypes.add(fullName);
    }

    private void generateDeclaredBean(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry, List<TypeDefinition> unresolvedTypeDefinitions) {
        ClassDefinition def;
        block37: {
            Class<?> existingDeclarationClass;
            AnnotationDescr traitableAnn;
            String fullName = typeDescr.getType().getFullName();
            if (type.getKind().equals((Object)TypeDeclaration.Kind.CLASS)) {
                TypeDeclarationDescr tdescr = (TypeDeclarationDescr)typeDescr;
                if (tdescr.getSuperTypes().size() > 1) {
                    this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Declared class " + fullName + "  - has more than one supertype;"));
                    return;
                }
                if (tdescr.getSuperTypes().isEmpty()) {
                    tdescr.addSuperType("java.lang.Object");
                }
            }
            boolean traitable = (traitableAnn = typeDescr.getAnnotation(Traitable.class.getSimpleName())) != null;
            String[] fullSuperTypes = new String[typeDescr.getSuperTypes().size() + 1];
            int j = 0;
            for (QualifiedName qname : typeDescr.getSuperTypes()) {
                fullSuperTypes[j++] = qname.getFullName();
            }
            fullSuperTypes[j] = Thing.class.getName();
            ArrayList<String> interfaceList = new ArrayList<String>();
            interfaceList.add(traitable ? Externalizable.class.getName() : Serializable.class.getName());
            if (traitable) {
                interfaceList.add(TraitableBean.class.getName());
            }
            String[] interfaces = interfaceList.toArray(new String[interfaceList.size()]);
            switch (type.getKind()) {
                case TRAIT: {
                    def = new ClassDefinition(fullName, "java.lang.Object", fullSuperTypes);
                    break;
                }
                case ENUM: {
                    def = new EnumClassDefinition(fullName, fullSuperTypes[0], null);
                    break;
                }
                default: {
                    def = new ClassDefinition(fullName, fullSuperTypes[0], interfaces);
                    def.setTraitable(traitable, traitableAnn != null && traitableAnn.getValue("logical") != null && Boolean.valueOf(traitableAnn.getValue("logical")) != false);
                }
            }
            for (String annotationName : typeDescr.getAnnotationNames()) {
                Class annotation = this.resolveAnnotation(annotationName, pkgRegistry.getTypeResolver());
                if (annotation != null && annotation.isAnnotation()) {
                    try {
                        AnnotationDefinition annotationDefinition = AnnotationDefinition.build((Class)annotation, typeDescr.getAnnotations().get(annotationName).getValueMap(), (TypeResolver)pkgRegistry.getTypeResolver());
                        def.addAnnotation(annotationDefinition);
                    }
                    catch (NoSuchMethodException nsme) {
                        this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Annotated type " + fullName + "  - undefined property in @annotation " + annotationName + ": " + nsme.getMessage() + ";"));
                    }
                }
                if (annotation != null && annotation != Role.class) continue;
                def.addMetaData(annotationName, (Object)typeDescr.getAnnotation(annotationName).getSingleValue());
            }
            if (type.getKind() == TypeDeclaration.Kind.ENUM) {
                for (EnumLiteralDescr lit : ((EnumDeclarationDescr)typeDescr).getLiterals()) {
                    ((EnumClassDefinition)def).addLiteral(new EnumLiteralDefinition(lit.getName(), lit.getConstructorArgs()));
                }
            }
            if (!typeDescr.getFields().isEmpty()) {
                PriorityQueue<FieldDefinition> fieldDefs = this.sortFields(typeDescr.getFields(), pkgRegistry);
                int n = fieldDefs.size();
                for (int k = 0; k < n; ++k) {
                    FieldDefinition fld = fieldDefs.poll();
                    if (unresolvedTypeDefinitions != null) {
                        for (TypeDefinition typeDef : unresolvedTypeDefinitions) {
                            if (!fld.getTypeName().equals(typeDef.getTypeClassName())) continue;
                            fld.setRecursive(true);
                            break;
                        }
                    }
                    fld.setIndex(k);
                    def.addField(fld);
                }
            }
            type.setNovel((existingDeclarationClass = this.getExistingDeclarationClass(typeDescr)) == null);
            type.setTypeClassDef(def);
            if (!type.isNovel()) {
                TypeDeclaration previousTypeDeclaration = this.kbuilder.getPackageRegistry(typeDescr.getNamespace()).getPackage().getTypeDeclaration(typeDescr.getTypeName());
                try {
                    if (type.isNovel()) {
                        type.setNature(TypeDeclaration.Nature.DEFINITION);
                    } else {
                        type.setNature(TypeDeclaration.Nature.DECLARATION);
                    }
                    if (previousTypeDeclaration == null) {
                        if (this.kbuilder.getBuilderConfiguration().isPreCompiled() || GeneratedFact.class.isAssignableFrom(existingDeclarationClass) || type.getTypeClassDef().getFields().isEmpty()) break block37;
                        try {
                            Class existingClass = pkgRegistry.getPackage().getTypeResolver().resolveType(typeDescr.getType().getFullName());
                            ClassFieldInspector cfi = new ClassFieldInspector(existingClass);
                            int fieldCount = 0;
                            for (String existingFieldName : cfi.getFieldTypesField().keySet()) {
                                if (cfi.isNonGetter(existingFieldName) || "class".equals(existingFieldName) || !cfi.getSetterMethods().containsKey(existingFieldName)) continue;
                                if (!typeDescr.getFields().containsKey(existingFieldName)) {
                                    type.setValid(false);
                                    this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "New declaration of " + typeDescr.getType().getFullName() + " does not include field " + existingFieldName));
                                    continue;
                                }
                                String fldType = ((Class)cfi.getFieldTypes().get(existingFieldName)).getName();
                                TypeFieldDescr declaredField = typeDescr.getFields().get(existingFieldName);
                                if (!fldType.equals(type.getTypeClassDef().getField(existingFieldName).getTypeName())) {
                                    type.setValid(false);
                                    this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "New declaration of " + typeDescr.getType().getFullName() + " redeclared field " + existingFieldName + " : \n" + "existing : " + fldType + " vs declared : " + declaredField.getPattern().getObjectType()));
                                    continue;
                                }
                                ++fieldCount;
                            }
                            if (fieldCount != typeDescr.getFields().size()) {
                                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "New declaration of " + typeDescr.getType().getFullName() + " can't declaredeclares a different set of fields \n" + "existing : " + cfi.getFieldTypesField() + "\n" + "declared : " + typeDescr.getFields()));
                            }
                            break block37;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            type.setValid(false);
                            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to redeclare " + typeDescr.getType().getFullName() + " : " + e.getMessage()));
                        }
                        catch (ClassNotFoundException e) {
                            type.setValid(false);
                            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to redeclare " + typeDescr.getType().getFullName() + " : " + e.getMessage()));
                        }
                        break block37;
                    }
                    int typeComparisonResult = this.compareTypeDeclarations(previousTypeDeclaration, type);
                    if (typeComparisonResult < 0) {
                        this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, typeDescr.getType().getFullName() + " declares more fields than the already existing version"));
                        type.setValid(false);
                    } else if (typeComparisonResult > 0 && !type.getTypeClassDef().getFields().isEmpty()) {
                        this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, typeDescr.getType().getFullName() + " declares less fields than the already existing version"));
                        type.setValid(false);
                    }
                    if (type.getNature() == TypeDeclaration.Nature.DECLARATION) {
                        this.mergeTypeDeclarations(previousTypeDeclaration, type);
                    }
                }
                catch (IncompatibleClassChangeError error) {
                    this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, error.getMessage()));
                }
            } else {
                type.setNature(TypeDeclaration.Nature.DEFINITION);
            }
        }
        this.generateDeclaredBean(typeDescr, type, pkgRegistry, this.expandImportsInFieldInitExpr(def, pkgRegistry));
    }

    private void mergeTypeDeclarations(TypeDeclaration oldDeclaration, TypeDeclaration newDeclaration) {
        if (oldDeclaration == null) {
            return;
        }
        for (FieldDefinition oldFactField : oldDeclaration.getTypeClassDef().getFieldsDefinitions()) {
            FieldDefinition newFactField = newDeclaration.getTypeClassDef().getField(oldFactField.getName());
            if (newFactField != null) continue;
            newDeclaration.getTypeClassDef().addField(oldFactField);
        }
        newDeclaration.setTypeClass(oldDeclaration.getTypeClass());
    }

    private int compareTypeDeclarations(TypeDeclaration oldDeclaration, TypeDeclaration newDeclaration) throws IncompatibleClassChangeError {
        if (!oldDeclaration.getFormat().equals((Object)newDeclaration.getFormat())) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different" + " format that its previous definition: " + newDeclaration.getFormat() + "!=" + oldDeclaration.getFormat());
        }
        if (!(oldDeclaration.getTypeClassDef().getSuperClass().equals(newDeclaration.getTypeClassDef().getSuperClass()) || oldDeclaration.getNature() == TypeDeclaration.Nature.DEFINITION && newDeclaration.getNature() == TypeDeclaration.Nature.DECLARATION && Object.class.getName().equals(newDeclaration.getTypeClassDef().getSuperClass()))) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different" + " superclass that its previous definition: " + newDeclaration.getTypeClassDef().getSuperClass() + " != " + oldDeclaration.getTypeClassDef().getSuperClass());
        }
        if (!this.nullSafeEqualityComparison((Comparable)((Object)oldDeclaration.getDurationAttribute()), (Comparable)((Object)newDeclaration.getDurationAttribute()))) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different" + " duration: " + newDeclaration.getDurationAttribute() + " != " + oldDeclaration.getDurationAttribute());
        }
        if (newDeclaration.getNature().equals((Object)TypeDeclaration.Nature.DEFINITION) && oldDeclaration.getSetMask() != newDeclaration.getSetMask()) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " is incompatible with" + " the previous definition: " + newDeclaration + " != " + oldDeclaration);
        }
        List oldFields = oldDeclaration.getTypeClassDef().getFields();
        HashMap<String, FactField> newFieldsMap = new HashMap<String, FactField>();
        for (FactField factField : newDeclaration.getTypeClassDef().getFields()) {
            newFieldsMap.put(factField.getName(), factField);
        }
        boolean allFieldsInOldDeclarationAreStillPresent = true;
        for (FactField oldFactField : oldFields) {
            FactField newFactField = (FactField)newFieldsMap.get(oldFactField.getName());
            if (newFactField != null) {
                String newFactType = ((FieldDefinition)newFactField).getTypeName();
                if (newFactType.equals(((FieldDefinition)oldFactField).getTypeName())) continue;
                throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + "." + newFactField.getName() + " has a different" + " type that its previous definition: " + newFactType + " != " + oldFactField.getType().getCanonicalName());
            }
            allFieldsInOldDeclarationAreStillPresent = false;
        }
        if (oldFields.size() < newFieldsMap.size()) {
            return -1;
        }
        if (oldFields.size() > newFieldsMap.size()) {
            return 1;
        }
        if (allFieldsInOldDeclarationAreStillPresent) {
            return 0;
        }
        throw new IncompatibleClassChangeError(newDeclaration.getTypeName() + " introduces" + " fields that are not present in its previous version.");
    }

    private boolean nullSafeEqualityComparison(Comparable c1, Comparable c2) {
        if (c1 == null) {
            return c2 == null;
        }
        return c2 != null && c1.compareTo(c2) == 0;
    }

    private ClassDefinition expandImportsInFieldInitExpr(ClassDefinition def, PackageRegistry pkgRegistry) {
        TypeResolver typeResolver = pkgRegistry.getPackage().getTypeResolver();
        for (FieldDefinition field : def.getFieldsDefinitions()) {
            field.setInitExpr(this.rewriteInitExprWithImports(field.getInitExpr(), typeResolver));
        }
        return def;
    }

    private String rewriteInitExprWithImports(String expr, TypeResolver typeResolver) {
        if (expr == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        boolean inTypeName = false;
        boolean afterDot = false;
        int typeStart = 0;
        for (int i = 0; i < expr.length(); ++i) {
            char ch = expr.charAt(i);
            if (Character.isJavaIdentifierStart(ch)) {
                if (!(inTypeName || inQuotes || afterDot)) {
                    typeStart = i;
                    inTypeName = true;
                }
            } else if (!Character.isJavaIdentifierPart(ch)) {
                if (ch == '\"') {
                    inQuotes = !inQuotes;
                } else if (ch == '.' && !inQuotes) {
                    afterDot = true;
                } else if (!Character.isSpaceChar(ch)) {
                    afterDot = false;
                }
                if (inTypeName) {
                    inTypeName = false;
                    String type = expr.substring(typeStart, i);
                    sb.append(this.getFullTypeName(type, typeResolver));
                }
            }
            if (inTypeName) continue;
            sb.append(ch);
        }
        if (inTypeName) {
            String type = expr.substring(typeStart);
            sb.append(this.getFullTypeName(type, typeResolver));
        }
        return sb.toString();
    }

    private String getFullTypeName(String type, TypeResolver typeResolver) {
        if (this.isLiteralOrKeyword(type)) {
            return type;
        }
        try {
            return typeResolver.getFullTypeName(type);
        }
        catch (ClassNotFoundException e) {
            return type;
        }
    }

    private boolean isLiteralOrKeyword(String type) {
        return "true".equals(type) || "false".equals(type) || "null".equals(type) || "new".equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDeclaredBean(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry, ClassDefinition def) {
        block30: {
            Class resolvedType;
            String availableName;
            PackageRegistry reg;
            if (typeDescr.getAnnotation(Traitable.class.getSimpleName()) != null || !type.getKind().equals((Object)TypeDeclaration.Kind.TRAIT) && this.kbuilder.getPackageRegistry().containsKey(def.getSuperClass()) && this.kbuilder.getPackageRegistry(def.getSuperClass()).getTraitRegistry().getTraitables().containsKey(def.getSuperClass())) {
                if (!this.isNovelClass(typeDescr)) {
                    try {
                        reg = this.kbuilder.getPackageRegistry(typeDescr.getNamespace());
                        availableName = typeDescr.getType().getFullName();
                        resolvedType = reg.getTypeResolver().resolveType(availableName);
                        this.updateTraitDefinition(type, resolvedType);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                pkgRegistry.getTraitRegistry().addTraitable(def);
            } else if (type.getKind().equals((Object)TypeDeclaration.Kind.TRAIT) || typeDescr.getAnnotation(Trait.class.getSimpleName()) != null) {
                if (!type.isNovel()) {
                    try {
                        reg = this.kbuilder.getPackageRegistry(typeDescr.getNamespace());
                        availableName = typeDescr.getType().getFullName();
                        resolvedType = reg.getTypeResolver().resolveType(availableName);
                        if (!Thing.class.isAssignableFrom(resolvedType)) {
                            this.updateTraitDefinition(type, resolvedType);
                            String target = typeDescr.getTypeName() + "_Trait__Extension";
                            TypeDeclarationDescr tempDescr = new TypeDeclarationDescr();
                            tempDescr.setNamespace(typeDescr.getNamespace());
                            tempDescr.setFields(typeDescr.getFields());
                            tempDescr.setType(target, typeDescr.getNamespace());
                            tempDescr.addSuperType(typeDescr.getType());
                            TypeDeclaration tempDeclr = new TypeDeclaration(target);
                            tempDeclr.setKind(TypeDeclaration.Kind.TRAIT);
                            tempDeclr.setTypesafe(type.isTypesafe());
                            tempDeclr.setNovel(true);
                            tempDeclr.setTypeClassName(tempDescr.getType().getFullName());
                            tempDeclr.setResource(type.getResource());
                            ClassDefinition tempDef = new ClassDefinition(target);
                            tempDef.setClassName(tempDescr.getType().getFullName());
                            tempDef.setTraitable(false);
                            for (FieldDefinition fld : def.getFieldsDefinitions()) {
                                tempDef.addField(fld);
                            }
                            tempDef.setInterfaces(def.getInterfaces());
                            tempDef.setSuperClass(def.getClassName());
                            tempDef.setDefinedClass(resolvedType);
                            tempDef.setAbstrakt(true);
                            tempDeclr.setTypeClassDef(tempDef);
                            type.setKind(TypeDeclaration.Kind.CLASS);
                            this.generateDeclaredBean((AbstractClassTypeDeclarationDescr)tempDescr, tempDeclr, pkgRegistry, tempDef);
                            try {
                                Class clazz = pkgRegistry.getTypeResolver().resolveType(tempDescr.getType().getFullName());
                                tempDeclr.setTypeClass(clazz);
                                break block30;
                            }
                            catch (ClassNotFoundException cnfe) {
                                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Internal Trait extension Class '" + target + "' could not be generated correctly'"));
                                break block30;
                            }
                            finally {
                                pkgRegistry.getPackage().addTypeDeclaration(tempDeclr);
                            }
                        }
                        this.updateTraitDefinition(type, resolvedType);
                        pkgRegistry.getTraitRegistry().addTrait(def);
                    }
                    catch (ClassNotFoundException cnfe) {}
                } else if (def.getClassName().endsWith("_Trait__Extension")) {
                    pkgRegistry.getTraitRegistry().addTrait(def.getClassName().replace("_Trait__Extension", ""), def);
                } else {
                    pkgRegistry.getTraitRegistry().addTrait(def);
                }
            }
        }
        if (type.isNovel()) {
            String fullName = typeDescr.getType().getFullName();
            JavaDialectRuntimeData dialect = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
            switch (type.getKind()) {
                case TRAIT: {
                    try {
                        this.buildClass(def, fullName, dialect, this.kbuilder.getBuilderConfiguration().getClassBuilderFactory().getTraitBuilder());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to compile declared trait " + fullName + ": " + e.getMessage() + ";"));
                    }
                    break;
                }
                case ENUM: {
                    try {
                        this.buildClass(def, fullName, dialect, (ClassBuilder)this.kbuilder.getBuilderConfiguration().getClassBuilderFactory().getEnumClassBuilder());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to compile declared enum " + fullName + ": " + e.getMessage() + ";"));
                    }
                    break;
                }
                default: {
                    try {
                        this.buildClass(def, fullName, dialect, this.kbuilder.getBuilderConfiguration().getClassBuilderFactory().getBeanClassBuilder());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to create a class for declared type " + fullName + ": " + e.getMessage() + ";"));
                    }
                }
            }
        }
    }

    private boolean isNovelClass(AbstractClassTypeDeclarationDescr typeDescr) {
        return this.getExistingDeclarationClass(typeDescr) == null;
    }

    private Class<?> getExistingDeclarationClass(AbstractClassTypeDeclarationDescr typeDescr) {
        PackageRegistry reg = this.kbuilder.getPackageRegistry(typeDescr.getNamespace());
        if (reg == null) {
            return null;
        }
        String availableName = typeDescr.getType().getFullName();
        try {
            return reg.getTypeResolver().resolveType(availableName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private void updateTraitDefinition(TypeDeclaration type, Class concrete) {
        try {
            ClassFieldInspector inspector = new ClassFieldInspector(concrete);
            Map methods = inspector.getGetterMethods();
            Map setters = inspector.getSetterMethods();
            int j = 0;
            for (String fieldName : methods.keySet()) {
                if ("core".equals(fieldName) || "fields".equals(fieldName) || inspector.isNonGetter(fieldName) || !setters.keySet().contains(fieldName)) continue;
                Class<?> ret = ((Method)methods.get(fieldName)).getReturnType();
                FieldDefinition field = new FieldDefinition();
                field.setName(fieldName);
                field.setTypeName(ret.getName());
                field.setIndex(j++);
                type.getTypeClassDef().addField(field);
            }
            HashSet<String> interfaces = new HashSet<String>();
            Collections.addAll(interfaces, type.getTypeClassDef().getInterfaces());
            for (Class iKlass : ClassUtils.getAllImplementedInterfaceNames((Class)concrete)) {
                interfaces.add(iKlass.getName());
            }
            type.getTypeClassDef().setInterfaces(interfaces.toArray(new String[interfaces.size()]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildClass(ClassDefinition def, String fullName, JavaDialectRuntimeData dialect, ClassBuilder cb) throws Exception {
        byte[] bytecode = cb.buildClass(def, this.kbuilder.getRootClassLoader());
        String resourceName = ClassUtils.convertClassToResourcePath((String)fullName);
        dialect.putClassDefinition(resourceName, bytecode);
        if (this.kbuilder.getKnowledgeBase() != null) {
            this.kbuilder.getKnowledgeBase().registerAndLoadTypeDefinition(fullName, bytecode);
        } else if (this.kbuilder.getRootClassLoader() instanceof ProjectClassLoader) {
            ((ProjectClassLoader)this.kbuilder.getRootClassLoader()).defineClass(fullName, resourceName, bytecode);
        } else {
            dialect.write(resourceName, bytecode);
        }
    }

    private boolean isCompatible(Class<?> typeClass, AbstractClassTypeDeclarationDescr typeDescr) {
        try {
            if (typeDescr.getFields().isEmpty()) {
                return true;
            }
            Class<?> sup = typeClass.getSuperclass();
            if (sup == null) {
                return true;
            }
            if (!sup.getName().equals(typeDescr.getSupertTypeFullName())) {
                return false;
            }
            ClassFieldInspector cfi = new ClassFieldInspector(typeClass, false);
            if (cfi.getGetterMethods().size() != typeDescr.getFields().size()) {
                return false;
            }
            for (String fieldName : cfi.getFieldTypes().keySet()) {
                Class fieldType;
                if (!typeDescr.getFields().containsKey(fieldName)) {
                    return false;
                }
                String fieldTypeName = typeDescr.getFields().get(fieldName).getPattern().getObjectType();
                if (fieldTypeName.equals((fieldType = (Class)cfi.getFieldTypes().get(fieldName)).getName()) && fieldTypeName.equals(fieldType.getSimpleName())) continue;
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

