/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.common.TupleEntryQueue;
import org.drools.core.common.TupleEntryQueueImpl;
import org.drools.core.phreak.TupleEntry;

public class StreamTupleEntryQueue {
    private final TupleEntryQueue queue = new TupleEntryQueueImpl();
    private final AtomicInteger insertCounter = new AtomicInteger(0);
    private final AtomicInteger updateCounter = new AtomicInteger(0);
    private final AtomicInteger deleteCounter = new AtomicInteger(0);

    public TupleEntry peek() {
        return this.queue.peek();
    }

    public boolean addInsert(TupleEntry entry) {
        this.queue.add(entry);
        return this.insertCounter.getAndIncrement() == 0;
    }

    public boolean addUpdate(TupleEntry entry) {
        this.queue.add(entry);
        return this.updateCounter.getAndIncrement() == 0;
    }

    public boolean addDelete(TupleEntry entry) {
        this.queue.add(entry);
        return this.deleteCounter.getAndIncrement() == 0;
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public synchronized TupleEntryQueue takeAllForFlushing() {
        this.insertCounter.set(0);
        this.updateCounter.set(0);
        this.deleteCounter.set(0);
        return this.queue.takeAll();
    }
}

