/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class QueryManager {
    public static final String ORDER_BY_KEY = "orderby";
    public static final String ASCENDING_KEY = "asc";
    public static final String DESCENDING_KEY = "desc";
    private Map<String, String> queries = new ConcurrentHashMap<String, String>();
    private static QueryManager instance;

    public static QueryManager get() {
        if (instance == null) {
            instance = new QueryManager();
        }
        return instance;
    }

    protected QueryManager() {
    }

    public void addNamedQueries(String ormFile) {
        try {
            this.parse(ormFile);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unable to read orm file due to " + e.getMessage(), e);
        }
    }

    public String getQuery(String name, Map<String, Object> params) {
        String query = null;
        if (!this.queries.containsKey(name)) {
            return null;
        }
        if (params != null && params.containsKey(ORDER_BY_KEY)) {
            StringBuffer buf = new StringBuffer(this.queries.get(name));
            buf.append(" \n ORDER BY " + this.adaptOrderBy((String)params.get(ORDER_BY_KEY)));
            if (params.containsKey(ASCENDING_KEY)) {
                buf.append(" ASC");
            } else if (params.containsKey(DESCENDING_KEY)) {
                buf.append(" DESC");
            }
            query = buf.toString();
        }
        return query;
    }

    protected void parse(String ormFile) throws XMLStreamException {
        String name = null;
        StringBuffer tagContent = new StringBuffer();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(ormFile));
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"named-query".equals(reader.getLocalName())) break;
                    name = reader.getAttributeValue(0);
                    break;
                }
                case 4: {
                    if (name == null) break;
                    tagContent.append(reader.getText());
                    break;
                }
                case 2: {
                    String origQuery;
                    if (!"named-query".equals(reader.getLocalName())) break;
                    String alteredQuery = origQuery = tagContent.toString();
                    int orderByIndex = origQuery.toLowerCase().indexOf("order by");
                    if (orderByIndex != -1) {
                        alteredQuery = origQuery.substring(0, orderByIndex);
                    }
                    this.queries.put(name, alteredQuery);
                    name = null;
                    tagContent = new StringBuffer();
                }
            }
        }
    }

    private String adaptOrderBy(String orderBy) {
        if (orderBy != null) {
            if (orderBy.equals("ProcessInstanceId")) {
                return "log.processInstanceId";
            }
            if (orderBy.equals("ProcessName")) {
                return "log.processName";
            }
            if (orderBy.equals("Initiator")) {
                return "log.identity";
            }
            if (orderBy.equals("ProcessVersion")) {
                return "log.processVersion";
            }
            if (orderBy.equals("Status")) {
                return "log.status";
            }
            if (orderBy.equals("StartDate")) {
                return "log.start";
            }
        }
        return orderBy;
    }
}

