/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.form.provider;

import java.io.ByteArrayInputStream;
import java.util.Map;
import org.jbpm.kie.services.impl.form.provider.FreemakerFormProvider;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.model.InternalTask;

public class InMemoryFormProvider
extends FreemakerFormProvider {
    private static final String DEFAULT_PROCESS = "DefaultProcess";
    private static final String DEFAULT_TASK = "DefaultTask";

    @Override
    public String render(String name, ProcessDefinition process, Map<String, Object> renderContext) {
        ProcessAssetDesc asset = null;
        if (!(process instanceof ProcessAssetDesc)) {
            return null;
        }
        asset = (ProcessAssetDesc)process;
        ByteArrayInputStream template = null;
        if (asset.getForms().containsKey(process.getId())) {
            template = new ByteArrayInputStream(asset.getForms().get(process.getId()).getBytes());
        } else if (asset.getForms().containsKey(process.getId() + "-taskform")) {
            template = new ByteArrayInputStream(asset.getForms().get(process.getId() + "-taskform").getBytes());
        } else if (asset.getForms().containsKey(DEFAULT_PROCESS)) {
            template = new ByteArrayInputStream(asset.getForms().get(DEFAULT_PROCESS).getBytes());
        }
        if (template == null) {
            return null;
        }
        return this.render(name, template, renderContext);
    }

    @Override
    public String render(String name, Task task, ProcessDefinition process, Map<String, Object> renderContext) {
        ProcessAssetDesc asset = null;
        if (!(process instanceof ProcessAssetDesc)) {
            return null;
        }
        asset = (ProcessAssetDesc)process;
        ByteArrayInputStream template = null;
        if (task != null && process != null) {
            String lookupName = "";
            String formName = ((InternalTask)task).getFormName();
            lookupName = formName != null && !formName.equals("") ? formName : ((I18NText)task.getNames().get(0)).getText();
            if (asset.getForms().containsKey(lookupName)) {
                template = new ByteArrayInputStream(asset.getForms().get(lookupName).getBytes());
            } else if (asset.getForms().containsKey(lookupName.replace(" ", "") + "-taskform")) {
                template = new ByteArrayInputStream(asset.getForms().get(lookupName.replace(" ", "") + "-taskform").getBytes());
            } else if (asset.getForms().containsKey(DEFAULT_TASK)) {
                template = new ByteArrayInputStream(asset.getForms().get(DEFAULT_TASK).getBytes());
            }
        }
        if (template == null) {
            return null;
        }
        return this.render(name, template, renderContext);
    }

    @Override
    public int getPriority() {
        return 3;
    }
}

