/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.kie.services.client.serialization.SerializationException;
import org.kie.services.client.serialization.SerializationProvider;

public class JsonSerializationProvider
implements SerializationProvider {
    public static final int JMS_SERIALIZATION_TYPE = 1;
    private ObjectMapper mapper = new ObjectMapper();
    private Class<?> outputType = null;

    @Override
    public String serialize(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (JsonGenerationException jge) {
            throw new SerializationException("Unable to serialize " + object.getClass().getSimpleName() + " instance", jge);
        }
        catch (JsonMappingException jme) {
            throw new SerializationException("Unable to serialize " + object.getClass().getSimpleName() + " instance", jme);
        }
        catch (IOException ie) {
            throw new SerializationException("Unable to serialize " + object.getClass().getSimpleName() + " instance", ie);
        }
    }

    @Override
    public Object deserialize(String jsonStr) {
        return this.deserialize(jsonStr, this.outputType);
    }

    public void setDeserializeOutputClass(Class<?> type) {
        this.outputType = type;
    }

    public <T> T deserialize(String jsonStr, Class<T> type) {
        try {
            return (T)this.mapper.readValue(jsonStr, type);
        }
        catch (JsonGenerationException jge) {
            throw new SerializationException("Unable to deserialize String " + type.getSimpleName() + " instance", jge);
        }
        catch (JsonMappingException jme) {
            throw new SerializationException("Unable to deserialize String " + type.getSimpleName() + " instance", jme);
        }
        catch (IOException ie) {
            throw new SerializationException("Unable to deserialize String to " + type.getSimpleName() + " instance", ie);
        }
    }

    @Override
    public void dispose() {
        if (this.mapper != null) {
            this.mapper = null;
        }
    }
}

