/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.UnitOfWorkHelper;

public class BridgeExceptionHandlerToErrorHandler
implements ExceptionHandler {
    private final LoggingExceptionHandler fallback;
    private final DefaultConsumer consumer;
    private final Processor bridge;

    public BridgeExceptionHandlerToErrorHandler(DefaultConsumer consumer) {
        this.consumer = consumer;
        this.fallback = new LoggingExceptionHandler(consumer.getEndpoint().getCamelContext(), consumer.getClass());
        this.bridge = consumer.getProcessor();
    }

    @Override
    public void handleException(Throwable exception) {
        this.handleException(null, exception);
    }

    @Override
    public void handleException(String message, Throwable exception) {
        this.handleException(message, null, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(String message, Exchange exchange, Throwable exception) {
        if (exchange == null) {
            exchange = this.consumer.getEndpoint().createExchange();
        }
        exchange.setException(exception);
        exchange.getIn().setBody(message);
        exchange.setProperty("CamelRedeliveryExhausted", Boolean.TRUE);
        UnitOfWork uow = null;
        try {
            uow = this.consumer.createUoW(exchange);
            this.bridge.process(exchange);
        }
        catch (Exception e) {
            this.fallback.handleException("Error handling exception " + exception.getMessage(), exchange, e);
        }
        finally {
            UnitOfWorkHelper.doneUow(uow, exchange);
        }
    }
}

